/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplConst;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.OptimizedBootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.PreOptimizedBootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class ReplicationSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private ReplScope replScope = new ReplScope();
    private String sourceDbNameOrPattern;
    private HiveConf conf;
    private Hive db;
    private static final String dumpSchema = "dump_dir,last_repl_id#string,string";

    ReplicationSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.db = ((BaseSemanticAnalyzer)this).db;
        this.conf = new HiveConf(((BaseSemanticAnalyzer)this).conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal");
        this.LOG.debug(ast.getName() + ":" + ast.getToken().getText() + "=" + ast.getText());
        this.setTxnConfigs();
        switch (ast.getToken().getType()) {
            case 1168: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: dump");
                try {
                    this.analyzeReplDump(ast);
                    break;
                }
                catch (SemanticException e) {
                    ReplUtils.reportStatusInReplicationMetrics("REPL_DUMP", ReplUtils.isErrorRecoverable(e) ? Status.FAILED_ADMIN : Status.FAILED, null, this.conf, null, null);
                    throw e;
                }
            }
            case 1169: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: load");
                try {
                    this.analyzeReplLoad(ast);
                    break;
                }
                catch (SemanticException e) {
                    if (!e.getMessage().equals(ErrorMsg.REPL_FAILED_WITH_NON_RECOVERABLE_ERROR.getMsg())) {
                        ReplUtils.reportStatusInReplicationMetrics("REPL_LOAD", ReplUtils.isErrorRecoverable(e) ? Status.FAILED_ADMIN : Status.FAILED, null, this.conf, null, null);
                    }
                    throw e;
                }
            }
            case 1170: {
                this.LOG.debug("ReplicationSemanticAnalyzer: analyzeInternal: status");
                this.analyzeReplStatus(ast);
                break;
            }
            default: {
                throw new SemanticException("Unexpected root token");
            }
        }
    }

    private void setTxnConfigs() {
        String validTxnList = this.queryState.getValidTxnList();
        if (validTxnList != null) {
            this.conf.set("hive.txn.valid.txns", validTxnList);
        }
    }

    private void setReplDumpTablesList(Tree replTablesNode, ReplScope replScope) throws HiveException {
        int childCount = replTablesNode.getChildCount();
        assert (childCount <= 2);
        String replScopeType = replScope == this.replScope ? "Current" : "Old";
        for (int listIdx = 0; listIdx < childCount; ++listIdx) {
            String tableList = ReplicationSemanticAnalyzer.unescapeSQLString(replTablesNode.getChild(listIdx).getText());
            if (tableList.isEmpty()) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_DB_OR_TABLE_PATTERN, new String[0]);
            }
            if (listIdx == 0) {
                this.LOG.info("{} ReplScope: Set Included Tables List: {}", (Object)replScopeType, (Object)tableList);
                replScope.setIncludedTablePatterns(tableList);
                continue;
            }
            this.LOG.info("{} ReplScope: Set Excluded Tables List: {}", (Object)replScopeType, (Object)tableList);
            replScope.setExcludedTablePatterns(tableList);
        }
    }

    private void initReplDump(ASTNode ast) throws HiveException {
        int numChildren = ast.getChildCount();
        String dbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        this.LOG.info("Current ReplScope: Set DB Name: {}", (Object)dbNameOrPattern);
        this.replScope.setDbName(dbNameOrPattern);
        block4: for (int childIdx = 1; childIdx < numChildren; ++childIdx) {
            Tree currNode = ast.getChild(childIdx);
            switch (currNode.getType()) {
                case 1166: {
                    Map<String, String> replConfigs = ReplicationSemanticAnalyzer.getProps((ASTNode)currNode.getChild(0));
                    for (Map.Entry<String, String> config : replConfigs.entrySet()) {
                        this.conf.set(config.getKey(), config.getValue());
                    }
                    continue block4;
                }
                case 1171: {
                    this.setReplDumpTablesList(currNode, this.replScope);
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unrecognized token " + currNode.getType() + " in REPL DUMP statement.");
                }
            }
        }
        List<String> databases = Utils.matchesDb(this.db, dbNameOrPattern);
        if (databases.size() == 0) {
            throw new SemanticException(ErrorMsg.REPL_SOURCE_DATABASE_NOT_FOUND.format(dbNameOrPattern));
        }
        for (String dbName : databases) {
            Database database = this.db.getDatabase(dbName);
            if (database != null) {
                Map dbParams = database.getParameters();
                if (!MetaStoreUtils.isTargetOfReplication((Database)database)) continue;
                this.LOG.info("Triggering optimized bootstrap for database {} since it is marked as target of replication (repl.target.for) with {} set to {}", new Object[]{dbName, "repl.failover.endpoint", Objects.nonNull(dbParams) ? dbParams.get("repl.failover.endpoint") : null});
                continue;
            }
            throw new SemanticException("Cannot dump database " + dbName + " as it does not exist");
        }
    }

    private void analyzeReplDump(ASTNode ast) throws SemanticException {
        try {
            this.initReplDump(ast);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
        try {
            this.ctx.setResFile(this.ctx.getLocalTmpPath());
            Task<ReplDumpWork> replDumpWorkTask = TaskFactory.get(new ReplDumpWork(this.replScope, ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_PATH.getMsg(), (ASTNode)ast), this.ctx.getResFile().toUri().toString()), this.conf);
            this.rootTasks.add(replDumpWorkTask);
            for (String dbName : Utils.matchesDb(this.db, this.replScope.getDbName())) {
                if (!this.replScope.includeAllTables()) {
                    for (String tblName : Utils.matchesTbl(this.db, dbName, this.replScope)) {
                        this.inputs.add(new ReadEntity(this.db.getTable(dbName, tblName)));
                    }
                    continue;
                }
                this.inputs.add(new ReadEntity(this.db.getDatabase(dbName)));
            }
            this.setFetchTask(this.createFetchTask(dumpSchema));
        }
        catch (Exception e) {
            this.LOG.warn("Error during analyzeReplDump", (Throwable)e);
            throw new SemanticException((Throwable)e);
        }
    }

    private void initReplLoad(ASTNode ast) throws HiveException {
        this.sourceDbNameOrPattern = PlanUtils.stripQuotes(ast.getChild(0).getText());
        int numChildren = ast.getChildCount();
        block5: for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 980: {
                    this.replScope.setDbName(PlanUtils.stripQuotes(childNode.getChild(0).getText()));
                    continue block5;
                }
                case 1166: {
                    this.setConfigs((ASTNode)childNode.getChild(0));
                    continue block5;
                }
                case 1171: {
                    continue block5;
                }
                default: {
                    throw new SemanticException("Unrecognized token in REPL LOAD statement.");
                }
            }
        }
    }

    private void analyzeReplLoad(ASTNode ast) throws SemanticException {
        try {
            this.initReplLoad(ast);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        try {
            Objects.requireNonNull(this.sourceDbNameOrPattern, "REPL LOAD Source database name shouldn't be null");
            Objects.requireNonNull(this.replScope.getDbName(), "REPL LOAD Target database name shouldn't be null");
            Path loadPath = this.getCurrentLoadPath();
            Path latestDumpPath = ReplUtils.getLatestDumpPath(ReplUtils.getEncodedDumpRootPath(this.conf, this.sourceDbNameOrPattern.toLowerCase()), this.conf);
            if (ReplUtils.failedWithNonRecoverableError(latestDumpPath, this.conf)) {
                Path nonRecoverableFile = new Path(latestDumpPath, ReplAck.NON_RECOVERABLE_MARKER.toString());
                ReplUtils.reportStatusInReplicationMetrics("REPL_LOAD", Status.FAILED_ADMIN, nonRecoverableFile.toString(), this.conf, this.sourceDbNameOrPattern, null);
                throw new Exception(ErrorMsg.REPL_FAILED_WITH_NON_RECOVERABLE_ERROR.getMsg());
            }
            if (loadPath != null) {
                DumpMetaData dmd = new DumpMetaData(loadPath, this.conf);
                boolean evDump = false;
                if (dmd.isIncrementalDump() || dmd.isOptimizedBootstrapDump() || dmd.isPreOptimizedBootstrapDump()) {
                    this.LOG.debug("{} contains an incremental / Optimized bootstrap dump", (Object)loadPath);
                    evDump = true;
                } else {
                    this.LOG.debug("{} contains an bootstrap dump", (Object)loadPath);
                }
                ReplicationMetricCollector metricCollector = this.initReplicationLoadMetricCollector(loadPath.toString(), this.replScope.getDbName(), dmd);
                ReplLoadWork replLoadWork = new ReplLoadWork(this.conf, loadPath.toString(), this.sourceDbNameOrPattern, this.replScope.getDbName(), dmd.getReplScope(), this.queryState.getLineageState(), evDump, dmd.getEventTo(), dmd.getDumpExecutionId(), metricCollector, dmd.isReplScopeModified());
                this.rootTasks.add(TaskFactory.get(replLoadWork, this.conf));
                if (dmd.isPreOptimizedBootstrapDump()) {
                    dmd.setOptimizedBootstrapToDumpMetadataFile(this.conf.getLong("scheduled.query.executionid", 0L));
                }
            } else {
                ReplUtils.reportStatusInReplicationMetrics("REPL_LOAD", Status.SKIPPED, null, this.conf, this.sourceDbNameOrPattern, null);
                this.LOG.warn("No dump to load or the previous dump already loaded");
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }

    private ReplicationMetricCollector initReplicationLoadMetricCollector(String dumpDirectory, String dbNameToLoadIn, DumpMetaData dmd) throws SemanticException {
        ReplicationMetricCollector collector;
        if (dmd.isPreOptimizedBootstrapDump() || dmd.isOptimizedBootstrapDump()) {
            Database dbToLoad = null;
            try {
                dbToLoad = this.db.getDatabase(dbNameToLoadIn);
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage(), (Throwable)e);
            }
            if (dbToLoad == null) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{dbNameToLoadIn});
            }
            String failoverType = "";
            try {
                failoverType = MetaStoreUtils.isDbBeingPlannedFailedOver((Database)this.db.getDatabase(dbNameToLoadIn)) ? ReplConst.FailoverType.PLANNED.toString() : ReplConst.FailoverType.UNPLANNED.toString();
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
            collector = dmd.isPreOptimizedBootstrapDump() ? new PreOptimizedBootstrapLoadMetricCollector(dbNameToLoadIn, dumpDirectory, dmd.getDumpExecutionId(), this.conf, MetaStoreUtils.FailoverEndpoint.TARGET.toString(), failoverType) : new OptimizedBootstrapLoadMetricCollector(dbNameToLoadIn, dumpDirectory, dmd.getDumpExecutionId(), this.conf, MetaStoreUtils.FailoverEndpoint.TARGET.toString(), failoverType);
        } else {
            collector = dmd.isBootstrapDump() ? new BootstrapLoadMetricCollector(dbNameToLoadIn, dumpDirectory, dmd.getDumpExecutionId(), this.conf) : new IncrementalLoadMetricCollector(dbNameToLoadIn, dumpDirectory, dmd.getDumpExecutionId(), this.conf);
        }
        return collector;
    }

    private Path getCurrentLoadPath() throws IOException {
        FileStatus[] statuses;
        Path loadPathBase = ReplUtils.getEncodedDumpRootPath(this.conf, this.sourceDbNameOrPattern.toLowerCase());
        FileSystem fs = loadPathBase.getFileSystem((Configuration)this.conf);
        if (fs.exists(loadPathBase = fs.makeQualified(loadPathBase)) && (statuses = loadPathBase.getFileSystem((Configuration)this.conf).listStatus(loadPathBase)).length > 0) {
            FileStatus latestUpdatedStatus = statuses[0];
            for (FileStatus status : statuses) {
                if (status.getModificationTime() <= latestUpdatedStatus.getModificationTime()) continue;
                latestUpdatedStatus = status;
            }
            Path hiveDumpPath = new Path(latestUpdatedStatus.getPath(), "hive");
            if (loadPathBase.getFileSystem((Configuration)this.conf).exists(new Path(hiveDumpPath, ReplAck.DUMP_ACKNOWLEDGEMENT.toString())) && !loadPathBase.getFileSystem((Configuration)this.conf).exists(new Path(hiveDumpPath, ReplAck.LOAD_ACKNOWLEDGEMENT.toString()))) {
                return hiveDumpPath;
            }
        }
        return null;
    }

    private void setConfigs(ASTNode node) throws SemanticException {
        Map<String, String> replConfigs = ReplicationSemanticAnalyzer.getProps(node);
        for (Map.Entry<String, String> config : replConfigs.entrySet()) {
            String key = config.getKey();
            if (key.equalsIgnoreCase(HiveConf.ConfVars.HIVE_QUERY_ID.varname)) {
                String queryTag = config.getValue();
                if (!StringUtils.isEmpty((CharSequence)queryTag)) {
                    QueryState.setApplicationTag(this.conf, queryTag);
                }
                this.queryState.setQueryTag(queryTag);
                continue;
            }
            this.conf.set(key, config.getValue());
        }
        try {
            this.db = Hive.get(this.conf);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private void initReplStatus(ASTNode ast) throws SemanticException {
        this.replScope.setDbName(PlanUtils.stripQuotes(ast.getChild(0).getText()));
        int numChildren = ast.getChildCount();
        for (int i = 1; i < numChildren; ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            if (childNode.getToken().getType() != 1166) {
                throw new SemanticException("Unrecognized token in REPL STATUS statement.");
            }
            this.setConfigs((ASTNode)childNode.getChild(0));
        }
    }

    private void analyzeReplStatus(ASTNode ast) throws SemanticException {
        this.initReplStatus(ast);
        String dbNameOrPattern = this.replScope.getDbName();
        String replLastId = this.getReplStatus(dbNameOrPattern);
        this.prepareReturnValues(Collections.singletonList(replLastId), "last_repl_id#string");
        this.setFetchTask(this.createFetchTask("last_repl_id#string"));
        this.LOG.debug("ReplicationSemanticAnalyzer.analyzeReplStatus: writing repl.last.id={} out to {} using configuration {}", new Object[]{replLastId, this.ctx.getResFile(), this.conf});
    }

    private String getReplStatus(String dbNameOrPattern) throws SemanticException {
        try {
            Database database = this.db.getDatabase(dbNameOrPattern);
            if (database != null) {
                this.inputs.add(new ReadEntity(database));
                Map params = database.getParameters();
                if (params != null && params.containsKey(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString())) {
                    return (String)params.get(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString());
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        return null;
    }

    private void prepareReturnValues(List<String> values, String schema) throws SemanticException {
        this.LOG.debug("prepareReturnValues : " + schema);
        for (String s : values) {
            this.LOG.debug("    > " + s);
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        Utils.writeOutput(Collections.singletonList(values), this.ctx.getResFile(), this.conf);
    }
}

