/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticGraphWalker;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class TaskGraphWalker
implements SemanticGraphWalker {
    protected Stack<Node> opStack;
    private final List<Node> toWalk = new ArrayList<Node>();
    private final HashMap<Node, Object> retMap = new HashMap();
    private final SemanticDispatcher dispatcher;
    private final TaskGraphWalkerContext walkerCtx;

    public TaskGraphWalker(SemanticDispatcher disp) {
        this.dispatcher = disp;
        this.opStack = new Stack();
        this.walkerCtx = new TaskGraphWalkerContext(this.retMap);
    }

    public List<Node> getToWalk() {
        return this.toWalk;
    }

    public Set<Node> getDispatchedList() {
        return this.retMap.keySet();
    }

    public void dispatch(Node nd, Stack<Node> ndStack, TaskGraphWalkerContext walkerCtx) throws SemanticException {
        Object[] nodeOutputs = null;
        if (nd.getChildren() != null) {
            nodeOutputs = new Object[nd.getChildren().size() + 1];
            nodeOutputs[0] = walkerCtx;
            int i = 1;
            for (Node child : nd.getChildren()) {
                nodeOutputs[i++] = this.retMap.get(child);
            }
        } else {
            nodeOutputs = new Object[]{walkerCtx};
        }
        Object retVal = this.dispatcher.dispatch(nd, ndStack, nodeOutputs);
        this.retMap.put(nd, retVal);
    }

    @Override
    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        while (this.toWalk.size() > 0) {
            Node nd = this.toWalk.remove(0);
            this.walk(nd);
            if (nodeOutput == null) continue;
            nodeOutput.put(nd, this.retMap.get(nd));
        }
    }

    public void walk(Node nd) throws SemanticException {
        if (!(nd instanceof Task)) {
            throw new SemanticException("Task Graph Walker only walks for Task Graph");
        }
        if (this.getDispatchedList().contains(nd)) {
            return;
        }
        if (this.opStack.empty() || nd != this.opStack.peek()) {
            this.opStack.push(nd);
        }
        List<Task<?>> nextTaskList = null;
        HashSet nextTaskSet = new HashSet();
        List<Task<?>> taskListInConditionalTask = null;
        if (nd instanceof ConditionalTask) {
            taskListInConditionalTask = ((ConditionalTask)nd).getListTasks();
            for (Task<Object> tsk : taskListInConditionalTask) {
                List<Task<?>> childTask = tsk.getChildTasks();
                if (childTask == null) continue;
                nextTaskSet.addAll(tsk.getChildTasks());
            }
            if (nextTaskSet.size() > 0) {
                nextTaskList = new ArrayList();
                for (Task<Object> tsk : nextTaskSet) {
                    nextTaskList.add(tsk);
                }
            }
        } else {
            nextTaskList = ((Task)nd).getChildTasks();
        }
        if (nextTaskList == null || this.getDispatchedList().containsAll(nextTaskList)) {
            this.dispatch(nd, this.opStack, this.walkerCtx);
            this.opStack.pop();
            return;
        }
        this.getToWalk().add(0, nd);
        this.getToWalk().removeAll(nextTaskList);
        this.getToWalk().addAll(0, nextTaskList);
    }

    public class TaskGraphWalkerContext {
        private final HashMap<Node, Object> reMap;

        public TaskGraphWalkerContext(HashMap<Node, Object> reMap) {
            this.reMap = reMap;
        }

        public void addToDispatchList(Node dispatchedObj) {
            if (dispatchedObj != null) {
                TaskGraphWalker.this.retMap.put(dispatchedObj, null);
            }
        }
    }
}

