/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.AcidConstants;
import org.apache.hadoop.hive.common.AcidMetaDataFile;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionState;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.Ref;
import org.apache.orc.FileFormatException;
import org.apache.orc.impl.OrcAcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidUtils {
    public static final String CONF_ACID_KEY = "hive.doing.acid";
    public static final String BASE_PREFIX = "base_";
    public static final String COMPACTOR_TABLE_PROPERTY = "compactiontable";
    public static final PathFilter baseFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BASE_PREFIX);
        }
    };
    public static final String DELTA_PREFIX = "delta_";
    public static final String DELETE_DELTA_PREFIX = "delete_delta_";
    public static final String DELTA_SIDE_FILE_SUFFIX = "_flush_length";
    public static final PathFilter deltaFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELTA_PREFIX);
        }
    };
    public static final PathFilter deleteEventDeltaDirFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELETE_DELTA_PREFIX);
        }
    };
    public static final String BUCKET_PREFIX = "bucket_";
    public static final PathFilter bucketFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BUCKET_PREFIX) && !path.getName().endsWith(AcidUtils.DELTA_SIDE_FILE_SUFFIX);
        }
    };
    public static final String BUCKET_DIGITS = "%05d";
    public static final String LEGACY_FILE_BUCKET_DIGITS = "%06d";
    public static final String DELTA_DIGITS = "%07d";
    public static final String STATEMENT_DIGITS = "%04d";
    public static final int MAX_STATEMENTS_PER_TXN = 10000;
    public static final Pattern LEGACY_BUCKET_DIGIT_PATTERN = Pattern.compile("^[0-9]{6}");
    public static final Pattern BUCKET_PATTERN = Pattern.compile("bucket_([0-9]+)(_[0-9]+)?$");
    private static final Set<Integer> READ_TXN_TOKENS = new HashSet<Integer>();
    private static Cache<String, DirInfoValue> dirCache;
    private static AtomicBoolean dirCacheInited;
    public static final PathFilter originalBucketFilter;
    private static final Logger LOG;
    public static final Pattern ORIGINAL_PATTERN;
    public static final Pattern ORIGINAL_PATTERN_COPY;
    public static final PathFilter acidHiddenFileFilter;
    public static final PathFilter acidTempDirFilter;
    public static final String VISIBILITY_PREFIX = "_v";
    public static final Pattern VISIBILITY_PATTERN;
    private static final HadoopShims SHIMS;

    private AcidUtils() {
    }

    public static Path createBucketFile(Path subdir, int bucket) {
        return AcidUtils.createBucketFile(subdir, bucket, null, true);
    }

    public static Path createBucketFile(Path subdir, int bucket, Integer attemptId) {
        return AcidUtils.createBucketFile(subdir, bucket, attemptId, true);
    }

    private static Path createBucketFile(Path subdir, int bucket, Integer attemptId, boolean isAcidSchema) {
        if (isAcidSchema) {
            String fileName = BUCKET_PREFIX + String.format(BUCKET_DIGITS, bucket);
            if (attemptId != null) {
                fileName = fileName + "_" + attemptId;
            }
            return new Path(subdir, fileName);
        }
        return new Path(subdir, String.format(BUCKET_DIGITS, bucket));
    }

    public static String deltaSubdir(long min, long max) {
        return DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    public static String deltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    @VisibleForTesting
    public static String deleteDeltaSubdir(long min, long max) {
        return DELETE_DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    @VisibleForTesting
    public static String deleteDeltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deleteDeltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    public static String baseDir(long writeId) {
        return AcidConstants.baseDir((long)writeId);
    }

    public static String baseOrDeltaSubdir(boolean baseDirRequired, long min, long max, int statementId) {
        if (!baseDirRequired) {
            return AcidUtils.deltaSubdir(min, max, statementId);
        }
        return AcidUtils.baseDir(min);
    }

    public static Path baseOrDeltaSubdirPath(Path directory, AcidOutputFormat.Options options) {
        Object subdir = options.isWritingBase() ? BASE_PREFIX + String.format(DELTA_DIGITS, options.getMaximumWriteId()) : (options.getStatementId() == -1 ? (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId()) : AcidUtils.deltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId())) : (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId(), options.getStatementId()) : AcidUtils.deltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId(), options.getStatementId())));
        subdir = AcidUtils.addVisibilitySuffix((String)subdir, options.getVisibilityTxnId());
        return new Path(directory, (String)subdir);
    }

    public static Path createFilename(Path directory, AcidOutputFormat.Options options) {
        if (options.getOldStyle()) {
            return new Path(directory, String.format(LEGACY_FILE_BUCKET_DIGITS, options.getBucketId()) + "_0");
        }
        return AcidUtils.createBucketFile(AcidUtils.baseOrDeltaSubdirPath(directory, options), options.getBucketId(), options.getAttemptId());
    }

    public static String addVisibilitySuffix(String baseOrDeltaDir, long visibilityTxnId) {
        if (visibilityTxnId == 0L) {
            return baseOrDeltaDir;
        }
        return baseOrDeltaDir + VISIBILITY_PREFIX + String.format(DELTA_DIGITS, visibilityTxnId);
    }

    public static boolean isLocklessReadsEnabled(org.apache.hadoop.hive.ql.metadata.Table table, HiveConf conf) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED) && AcidUtils.isTransactionalTable(table);
    }

    public static boolean isTableSoftDeleteEnabled(org.apache.hadoop.hive.ql.metadata.Table table, HiveConf conf) {
        boolean isSoftDelete = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX) || HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
        return isSoftDelete && AcidUtils.isTransactionalTable(table) && Boolean.parseBoolean(table.getProperty("soft_delete"));
    }

    public static boolean isCompactionTable(Properties tblProperties) {
        return tblProperties != null && AcidUtils.isCompactionTable((Map<String, String>)Maps.fromProperties((Properties)tblProperties));
    }

    public static boolean isCompactionTable(Map<String, String> parameters) {
        return StringUtils.isNotBlank((CharSequence)parameters.get(COMPACTOR_TABLE_PROPERTY));
    }

    public static int parseBucketId(Path bucketFile) {
        Matcher matcher;
        String filename = bucketFile.getName();
        if (ORIGINAL_PATTERN.matcher(filename).matches() || ORIGINAL_PATTERN_COPY.matcher(filename).matches()) {
            return Integer.parseInt(filename.substring(0, filename.indexOf(95)));
        }
        if (filename.startsWith(BUCKET_PREFIX) && (matcher = BUCKET_PATTERN.matcher(filename)).matches()) {
            String bucketId = matcher.group(1);
            filename = filename.substring(0, matcher.end(1));
            if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
                Utilities.FILE_OP_LOGGER.debug("Parsing bucket ID = " + bucketId + " from file name '" + filename + "'");
            }
            return Integer.parseInt(bucketId);
        }
        return -1;
    }

    public static Integer parseAttemptId(Path bucketFile) {
        String filename = bucketFile.getName();
        Matcher matcher = BUCKET_PATTERN.matcher(filename);
        Integer attemptId = null;
        if (matcher.matches()) {
            Integer n = attemptId = matcher.group(2) != null ? Integer.valueOf(matcher.group(2).substring(1)) : null;
        }
        if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
            Utilities.FILE_OP_LOGGER.debug("Parsing attempt ID = " + attemptId + " from file name '" + bucketFile + "'");
        }
        return attemptId;
    }

    public static AcidOutputFormat.Options parseBaseOrDeltaBucketFilename(Path bucketFile, Configuration conf) {
        AcidOutputFormat.Options result = new AcidOutputFormat.Options(conf);
        String filename = bucketFile.getName();
        int bucket = AcidUtils.parseBucketId(bucketFile);
        Integer attemptId = AcidUtils.parseAttemptId(bucketFile);
        if (ORIGINAL_PATTERN.matcher(filename).matches() || ORIGINAL_PATTERN_COPY.matcher(filename).matches()) {
            long minWriteId = 0L;
            long maxWriteId = 0L;
            int statementId = -1;
            if (bucketFile.getParent().getName().startsWith(DELTA_PREFIX)) {
                ParsedDeltaLight parsedDelta = ParsedDeltaLight.parse(bucketFile.getParent());
                minWriteId = parsedDelta.getMinWriteId();
                maxWriteId = parsedDelta.getMaxWriteId();
                statementId = parsedDelta.getStatementId();
            }
            result.setOldStyle(true).minimumWriteId(minWriteId).maximumWriteId(maxWriteId).statementId(statementId).bucket(bucket).writingBase(!bucketFile.getParent().getName().startsWith(DELTA_PREFIX));
        } else if (filename.startsWith(BUCKET_PREFIX)) {
            if (bucketFile.getParent().getName().startsWith(BASE_PREFIX)) {
                result.setOldStyle(false).minimumWriteId(0L).maximumWriteId(ParsedBaseLight.parseBase(bucketFile.getParent()).getWriteId()).bucket(bucket).writingBase(true);
            } else if (bucketFile.getParent().getName().startsWith(DELTA_PREFIX)) {
                ParsedDeltaLight parsedDelta = ParsedDeltaLight.parse(bucketFile.getParent());
                result.setOldStyle(false).minimumWriteId(parsedDelta.minWriteId).maximumWriteId(parsedDelta.maxWriteId).statementId(parsedDelta.statementId).bucket(bucket).attemptId(attemptId);
            } else if (bucketFile.getParent().getName().startsWith(DELETE_DELTA_PREFIX)) {
                ParsedDeltaLight parsedDelta = ParsedDeltaLight.parse(bucketFile.getParent());
                result.setOldStyle(false).minimumWriteId(parsedDelta.minWriteId).maximumWriteId(parsedDelta.maxWriteId).statementId(parsedDelta.statementId).bucket(bucket);
            }
        } else {
            result.setOldStyle(true).bucket(bucket).minimumWriteId(0L).maximumWriteId(0L);
        }
        return result;
    }

    public static Map<String, Integer> getDeltaToAttemptIdMap(Map<String, AcidInputFormat.DeltaMetaData> pathToDeltaMetaData, Path[] deleteDeltaDirs, int bucket) {
        HashMap<String, Integer> deltaToAttemptId = new HashMap<String, Integer>();
        block0: for (Path delta : deleteDeltaDirs) {
            AcidInputFormat.DeltaMetaData deltaMetaData = pathToDeltaMetaData.get(delta.getName());
            for (AcidInputFormat.DeltaFileMetaData files : deltaMetaData.getDeltaFiles()) {
                if (bucket != files.getBucketId()) continue;
                deltaToAttemptId.put(delta.getName(), files.getAttemptId());
                continue block0;
            }
        }
        return deltaToAttemptId;
    }

    public static DataOperationType toDataOperationType(Operation op) {
        switch (op) {
            case NOT_ACID: {
                return DataOperationType.UNSET;
            }
            case INSERT: {
                return DataOperationType.INSERT;
            }
            case UPDATE: {
                return DataOperationType.UPDATE;
            }
            case DELETE: {
                return DataOperationType.DELETE;
            }
        }
        throw new IllegalArgumentException("Unexpected Operation: " + op);
    }

    public static Path[] getPaths(List<ParsedDelta> deltas) {
        Path[] result = new Path[deltas.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = deltas.get(i).getPath();
        }
        return result;
    }

    public static List<AcidInputFormat.DeltaMetaData> serializeDeleteDeltas(List<ParsedDelta> deltas, FileSystem fs) throws IOException {
        ArrayList<AcidInputFormat.DeltaMetaData> result = new ArrayList<AcidInputFormat.DeltaMetaData>(deltas.size());
        AcidInputFormat.DeltaMetaData last = null;
        for (ParsedDelta parsedDelta : deltas) {
            Integer stmtId;
            assert (parsedDelta.isDeleteDelta()) : "expected delete_delta, got " + parsedDelta.getPath();
            Integer n = stmtId = parsedDelta.statementId >= 0 ? Integer.valueOf(parsedDelta.statementId) : null;
            if (last != null && last.getMinWriteId() == parsedDelta.getMinWriteId() && last.getMaxWriteId() == parsedDelta.getMaxWriteId()) {
                if (stmtId != null) {
                    last.getStmtIds().add(stmtId);
                }
                for (HadoopShims.HdfsFileStatusWithId fileStatus : parsedDelta.getFiles(fs, null)) {
                    last.getDeltaFiles().add(new AcidInputFormat.DeltaFileMetaData(fileStatus, stmtId, AcidUtils.parseBucketId(fileStatus.getFileStatus().getPath())));
                }
                continue;
            }
            ArrayList<Integer> stmtIds = new ArrayList<Integer>();
            if (stmtId != null) {
                stmtIds.add(stmtId);
            }
            last = new AcidInputFormat.DeltaMetaData(parsedDelta.getMinWriteId(), parsedDelta.getMaxWriteId(), stmtIds, parsedDelta.getVisibilityTxnId(), parsedDelta.getFiles(fs, null).stream().map(file -> new AcidInputFormat.DeltaFileMetaData((HadoopShims.HdfsFileStatusWithId)file, stmtId, AcidUtils.parseBucketId(file.getFileStatus().getPath()))).collect(Collectors.toList()));
            result.add(last);
        }
        return result;
    }

    public static Path[] deserializeDeleteDeltas(Path root, List<AcidInputFormat.DeltaMetaData> deleteDeltas, Map<String, AcidInputFormat.DeltaMetaData> pathToDeltaMetaData) {
        ArrayList results = new ArrayList(deleteDeltas.size());
        for (AcidInputFormat.DeltaMetaData dmd : deleteDeltas) {
            results.addAll(dmd.getPaths(root).stream().map(Pair::getLeft).collect(Collectors.toList()));
            if (pathToDeltaMetaData == null) continue;
            for (Pair<Path, Integer> pathPair : dmd.getPaths(root)) {
                pathToDeltaMetaData.put(((Path)pathPair.getLeft()).getName(), dmd);
            }
        }
        return results.toArray(new Path[results.size()]);
    }

    public static ParsedDelta parsedDelta(Path deltaDir, FileSystem fs) throws IOException {
        return AcidUtils.parsedDelta(deltaDir, fs, null);
    }

    private static ParsedDelta parsedDelta(Path deltaDir, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
        ParsedDeltaLight deltaLight = ParsedDeltaLight.parse(deltaDir);
        boolean isRawFormat = !deltaLight.isDeleteDelta && MetaDataFile.isRawFormat(deltaDir, fs, dirSnapshot);
        List files = null;
        if (dirSnapshot != null) {
            PathFilter filter = isRawFormat ? originalBucketFilter : bucketFileFilter;
            files = dirSnapshot.getFiles().stream().filter(fileStatus -> filter.accept(fileStatus.getPath())).map(HdfsUtils.HdfsFileStatusWithoutId::new).collect(Collectors.toList());
        }
        return new ParsedDelta(deltaLight, isRawFormat, files);
    }

    public static boolean isAcid(Path directory, Configuration conf) throws IOException {
        return AcidUtils.isAcid(null, directory, conf);
    }

    public static boolean isAcid(FileSystem fileSystem, Path directory, Configuration conf) throws IOException {
        FileSystem fs = fileSystem == null ? directory.getFileSystem(conf) : fileSystem;
        for (FileStatus file : fs.listStatus(directory)) {
            String filename = file.getPath().getName();
            if (!filename.startsWith(BASE_PREFIX) && !filename.startsWith(DELTA_PREFIX) && !filename.startsWith(DELETE_DELTA_PREFIX) || !file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static AcidDirectory getAcidState(FileSystem fileSystem, Path candidateDirectory, Configuration conf, ValidWriteIdList writeIdList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles) throws IOException {
        return AcidUtils.getAcidState(fileSystem, candidateDirectory, conf, writeIdList, useFileIds, ignoreEmptyFiles, null);
    }

    public static AcidDirectory getAcidState(FileSystem fileSystem, Path candidateDirectory, Configuration conf, ValidWriteIdList writeIdList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles, Map<Path, HdfsDirSnapshot> dirSnapshots) throws IOException {
        ValidTxnList validTxnList = AcidUtils.getValidTxnList(conf);
        FileSystem fs = fileSystem == null ? candidateDirectory.getFileSystem(conf) : fileSystem;
        AcidDirectory directory = new AcidDirectory(candidateDirectory, fs, useFileIds);
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId = HdfsUtils.tryListLocatedHdfsStatus(useFileIds, fs, candidateDirectory, FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId child : childrenWithId) {
                AcidUtils.getChildState(directory, child, writeIdList, validTxnList, ignoreEmptyFiles);
            }
        } else {
            if (dirSnapshots == null) {
                dirSnapshots = AcidUtils.getHdfsDirSnapshots(fs, candidateDirectory);
            }
            AcidUtils.getChildState(directory, dirSnapshots, writeIdList, validTxnList, ignoreEmptyFiles);
        }
        if (directory.getBase() != null) {
            for (HadoopShims.HdfsFileStatusWithId fswid : directory.getOriginalFiles()) {
                directory.getObsolete().add(fswid.getFileStatus().getPath());
            }
            directory.getObsolete().addAll(directory.getOriginalDirectories());
            directory.getOriginalFiles().clear();
            directory.getOriginalDirectories().clear();
        } else if (childrenWithId != null) {
            for (Path origDir : directory.getOriginalDirectories()) {
                directory.getOriginalFiles().addAll(HdfsUtils.listFileStatusWithId(fs, origDir, useFileIds, true, null));
            }
        }
        AcidUtils.findBestWorkingDeltas(writeIdList, directory);
        if (directory.getOldestBase() != null && directory.getBase() == null && AcidUtils.isCompactedBase(directory.getOldestBase(), fs, dirSnapshots)) {
            long[] exceptions = writeIdList.getInvalidWriteIds();
            String minOpenWriteId = exceptions != null && exceptions.length > 0 ? Long.toString(exceptions[0]) : "x";
            throw new IOException(ErrorMsg.ACID_NOT_ENOUGH_HISTORY.format(new String[]{Long.toString(writeIdList.getHighWatermark()), minOpenWriteId, directory.getOldestBase().toString()}));
        }
        Path basePath = directory.getBaseDirectory();
        if (basePath != null) {
            boolean isBaseInRawFormat = MetaDataFile.isRawFormat(basePath, fs, dirSnapshots != null ? dirSnapshots.get(basePath) : null);
            directory.getBase().setRawFormat(isBaseInRawFormat);
        }
        LOG.debug("in directory " + candidateDirectory.toUri().toString() + " base = " + basePath + " deltas = " + directory.getCurrentDirectories().size());
        directory.getOriginalFiles().sort(Comparator.comparing(HadoopShims.HdfsFileStatusWithId::getFileStatus));
        return directory;
    }

    public static AcidDirectory getAcidState(StorageDescriptor sd, ValidWriteIdList writeIds, HiveConf conf) throws IOException {
        Path location = new Path(sd.getLocation());
        FileSystem fs = location.getFileSystem((Configuration)conf);
        return AcidUtils.getAcidState(fs, location, (Configuration)conf, writeIds, (Ref<Boolean>)Ref.from((Object)false), false);
    }

    private static void findBestWorkingDeltas(ValidWriteIdList writeIdList, AcidDirectory directory) {
        Collections.sort(directory.getCurrentDirectories());
        ArrayList<ParsedDelta> deltas = new ArrayList<ParsedDelta>();
        long current = directory.getBase() == null ? 0L : directory.getBase().getWriteId();
        int lastStmtId = -1;
        ParsedDelta prev = null;
        for (ParsedDelta next : directory.getCurrentDirectories()) {
            if (next.maxWriteId > current) {
                if (writeIdList.isWriteIdRangeValid(current + 1L, next.maxWriteId) == ValidWriteIdList.RangeResponse.NONE) continue;
                deltas.add(next);
                current = next.maxWriteId;
                lastStmtId = next.statementId;
                prev = next;
                continue;
            }
            if (next.maxWriteId == current && lastStmtId >= 0) {
                deltas.add(next);
                prev = next;
                continue;
            }
            if (prev != null && next.maxWriteId == prev.maxWriteId && next.minWriteId == prev.minWriteId && next.statementId == prev.statementId) {
                deltas.add(next);
                prev = next;
                continue;
            }
            directory.getObsolete().add(next.path);
        }
        directory.getCurrentDirectories().clear();
        directory.getCurrentDirectories().addAll(deltas);
    }

    private static ValidTxnList getValidTxnList(Configuration conf) {
        ValidReadTxnList validTxnList = null;
        String s = conf.get("hive.txn.valid.txns");
        if (!Strings.isNullOrEmpty((String)s)) {
            validTxnList = new ValidReadTxnList();
            validTxnList.readFromString(s);
        }
        return validTxnList;
    }

    public static Map<Path, HdfsDirSnapshot> getHdfsDirSnapshotsForCleaner(FileSystem fs, Path path) throws IOException {
        HashMap<Path, HdfsDirSnapshot> dirToSnapshots = new HashMap<Path, HdfsDirSnapshot>();
        ArrayDeque<RemoteIterator> stack = new ArrayDeque<RemoteIterator>();
        stack.push(FileUtils.listStatusIterator((FileSystem)fs, (Path)path, (PathFilter)acidHiddenFileFilter));
        while (!stack.isEmpty()) {
            RemoteIterator itr = (RemoteIterator)stack.pop();
            while (itr.hasNext()) {
                FileStatus fStatus = (FileStatus)itr.next();
                Path fPath = fStatus.getPath();
                if (baseFileFilter.accept(fPath) || deltaFileFilter.accept(fPath) || deleteEventDeltaDirFilter.accept(fPath)) {
                    AcidUtils.addToSnapshot(dirToSnapshots, fPath);
                    continue;
                }
                if (fStatus.isDirectory()) {
                    stack.push(FileUtils.listStatusIterator((FileSystem)fs, (Path)fPath, (PathFilter)acidHiddenFileFilter));
                    continue;
                }
                HdfsDirSnapshot hdfsDirSnapshot = AcidUtils.addToSnapshot(dirToSnapshots, fPath.getParent());
                hdfsDirSnapshot.addFile(fStatus);
            }
        }
        return dirToSnapshots;
    }

    private static HdfsDirSnapshot addToSnapshot(Map<Path, HdfsDirSnapshot> dirToSnapshots, Path fPath) {
        HdfsDirSnapshot dirSnapshot = dirToSnapshots.get(fPath);
        if (dirSnapshot == null) {
            dirSnapshot = new HdfsDirSnapshotImpl(fPath);
            dirToSnapshots.put(fPath, dirSnapshot);
        }
        return dirSnapshot;
    }

    public static Map<Path, HdfsDirSnapshot> getHdfsDirSnapshots(FileSystem fs, Path path) throws IOException {
        HashMap<Path, HdfsDirSnapshot> dirToSnapshots = new HashMap<Path, HdfsDirSnapshot>();
        ArrayDeque<RemoteIterator> stack = new ArrayDeque<RemoteIterator>();
        stack.push(FileUtils.listStatusIterator((FileSystem)fs, (Path)path, (PathFilter)acidHiddenFileFilter));
        while (!stack.isEmpty()) {
            RemoteIterator itr = (RemoteIterator)stack.pop();
            while (itr.hasNext()) {
                FileStatus fStatus = (FileStatus)itr.next();
                Path fPath = fStatus.getPath();
                if (fStatus.isDirectory()) {
                    stack.push(FileUtils.listStatusIterator((FileSystem)fs, (Path)fPath, (PathFilter)acidHiddenFileFilter));
                    continue;
                }
                Path parentDirPath = fPath.getParent();
                if (!acidTempDirFilter.accept(parentDirPath)) continue;
                while (AcidUtils.isChildOfDelta(parentDirPath, path)) {
                    parentDirPath = parentDirPath.getParent();
                }
                HdfsDirSnapshot dirSnapshot = AcidUtils.addToSnapshot(dirToSnapshots, parentDirPath);
                if (fStatus.getPath().toString().contains("_metadata_acid")) {
                    dirSnapshot.addMetadataFile(fStatus);
                    continue;
                }
                if (fStatus.getPath().toString().contains("_orc_acid_version")) {
                    dirSnapshot.addOrcAcidFormatFile(fStatus);
                    continue;
                }
                dirSnapshot.addFile(fStatus);
            }
        }
        return dirToSnapshots;
    }

    public static boolean isChildOfDelta(Path childDir, Path rootPath) {
        if (childDir.toUri().toString().length() <= rootPath.toUri().toString().length()) {
            return false;
        }
        String fullName = childDir.toUri().toString().substring(rootPath.toUri().toString().length() + 1);
        String dirName = childDir.getName();
        return !dirName.startsWith(BASE_PREFIX) && !dirName.startsWith(DELTA_PREFIX) && !dirName.startsWith(DELETE_DELTA_PREFIX) && (fullName.contains(BASE_PREFIX) || fullName.contains(DELTA_PREFIX) || fullName.contains(DELETE_DELTA_PREFIX));
    }

    private static boolean isValidBase(ParsedBaseLight parsedBase, ValidWriteIdList writeIdList, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
        boolean isValidBase;
        if (dirSnapshot != null && dirSnapshot.isValidBase() != null) {
            isValidBase = dirSnapshot.isValidBase();
        } else {
            isValidBase = parsedBase.getWriteId() == Long.MIN_VALUE ? true : (writeIdList.getMinOpenWriteId() != null && parsedBase.getWriteId() <= writeIdList.getMinOpenWriteId() ? true : (AcidUtils.isCompactedBase(parsedBase, fs, dirSnapshot) ? writeIdList.isValidBase(parsedBase.getWriteId()) : writeIdList.isWriteIdValid(parsedBase.getWriteId())));
            if (dirSnapshot != null) {
                dirSnapshot.setIsValidBase(isValidBase);
            }
        }
        return isValidBase;
    }

    private static boolean isCompactedBase(ParsedBaseLight parsedBase, FileSystem fs, Map<Path, HdfsDirSnapshot> snapshotMap) throws IOException {
        return AcidUtils.isCompactedBase(parsedBase, fs, snapshotMap != null ? snapshotMap.get(parsedBase.getBaseDirPath()) : null);
    }

    private static boolean isCompactedBase(ParsedBaseLight parsedBase, FileSystem fs, HdfsDirSnapshot snapshot) throws IOException {
        return parsedBase.getVisibilityTxnId() > 0L || MetaDataFile.isCompacted(parsedBase.getBaseDirPath(), fs, snapshot);
    }

    private static void getChildState(AcidDirectory directory, HadoopShims.HdfsFileStatusWithId childWithId, ValidWriteIdList writeIdList, ValidTxnList validTxnList, boolean ignoreEmptyFiles) throws IOException {
        Path childPath = childWithId.getFileStatus().getPath();
        String fn = childPath.getName();
        if (!childWithId.getFileStatus().isDirectory()) {
            if (!ignoreEmptyFiles || childWithId.getFileStatus().getLen() != 0L) {
                directory.getOriginalFiles().add(childWithId);
            }
        } else if (fn.startsWith(BASE_PREFIX)) {
            AcidUtils.processBaseDir(childPath, writeIdList, validTxnList, directory, null);
        } else if (fn.startsWith(DELTA_PREFIX) || fn.startsWith(DELETE_DELTA_PREFIX)) {
            AcidUtils.processDeltaDir(childPath, writeIdList, validTxnList, directory, null);
        } else {
            directory.getOriginalDirectories().add(childPath);
        }
    }

    private static void getChildState(AcidDirectory directory, Map<Path, HdfsDirSnapshot> dirSnapshots, ValidWriteIdList writeIdList, ValidTxnList validTxnList, boolean ignoreEmptyFiles) throws IOException {
        for (HdfsDirSnapshot dirSnapshot : dirSnapshots.values()) {
            Path dirPath = dirSnapshot.getPath();
            String dirName = dirPath.getName();
            if (dirPath.toString().endsWith(directory.getPath().toString())) {
                for (FileStatus fileStatus : dirSnapshot.getFiles()) {
                    if (ignoreEmptyFiles && fileStatus.getLen() == 0L) continue;
                    directory.getOriginalFiles().add(new HdfsUtils.HdfsFileStatusWithoutId(fileStatus));
                }
                continue;
            }
            if (dirName.startsWith(BASE_PREFIX)) {
                AcidUtils.processBaseDir(dirPath, writeIdList, validTxnList, directory, dirSnapshot);
                continue;
            }
            if (dirName.startsWith(DELTA_PREFIX) || dirName.startsWith(DELETE_DELTA_PREFIX)) {
                AcidUtils.processDeltaDir(dirPath, writeIdList, validTxnList, directory, dirSnapshot);
                continue;
            }
            directory.getOriginalDirectories().add(dirPath);
            for (FileStatus stat : dirSnapshot.getFiles()) {
                if (ignoreEmptyFiles && stat.getLen() == 0L) continue;
                directory.getOriginalFiles().add(new HdfsUtils.HdfsFileStatusWithoutId(stat));
            }
        }
    }

    private static void processBaseDir(Path baseDir, ValidWriteIdList writeIdList, ValidTxnList validTxnList, AcidDirectory directory, HdfsDirSnapshot dirSnapshot) throws IOException {
        ParsedBaseLight parsedBase = ParsedBaseLight.parseBase(baseDir);
        if (!AcidUtils.isDirUsable(baseDir, parsedBase.getVisibilityTxnId(), directory.getAbortedDirectories(), validTxnList)) {
            return;
        }
        long writeId = parsedBase.getWriteId();
        if (directory.getOldestBase() == null || directory.getOldestBase().writeId > writeId) {
            directory.setOldestBase(parsedBase);
        }
        boolean isCompactedBase = AcidUtils.isCompactedBase(parsedBase, directory.getFs(), dirSnapshot);
        if (writeIdList.isWriteIdAborted(writeId) && !isCompactedBase) {
            directory.getAbortedDirectories().add(baseDir);
            directory.getAbortedWriteIds().add(parsedBase.writeId);
            return;
        }
        if (directory.getBase() == null || directory.getBase().getWriteId() < writeId || directory.getBase().getWriteId() == writeId && isCompactedBase && validTxnList.isTxnValid(parsedBase.getVisibilityTxnId())) {
            if (AcidUtils.isValidBase(parsedBase, writeIdList, directory.getFs(), dirSnapshot)) {
                List<HadoopShims.HdfsFileStatusWithId> files = null;
                if (dirSnapshot != null) {
                    files = dirSnapshot.getFiles().stream().map(HdfsUtils.HdfsFileStatusWithoutId::new).collect(Collectors.toList());
                }
                if (directory.getBase() != null) {
                    directory.getObsolete().add(directory.getBase().getBaseDirPath());
                }
                directory.setBase(new ParsedBase(parsedBase, files));
            }
        } else {
            directory.getObsolete().add(baseDir);
        }
    }

    private static void processDeltaDir(Path deltadir, ValidWriteIdList writeIdList, ValidTxnList validTxnList, AcidDirectory directory, HdfsDirSnapshot dirSnapshot) throws IOException {
        ParsedDelta delta = AcidUtils.parsedDelta(deltadir, directory.getFs(), dirSnapshot);
        if (!AcidUtils.isDirUsable(deltadir, delta.getVisibilityTxnId(), directory.getAbortedDirectories(), validTxnList)) {
            return;
        }
        ValidWriteIdList.RangeResponse abortRange = writeIdList.isWriteIdRangeAborted(delta.minWriteId, delta.maxWriteId);
        if (ValidWriteIdList.RangeResponse.ALL == abortRange) {
            directory.getAbortedDirectories().add(deltadir);
            directory.getAbortedWriteIds().addAll(LongStream.rangeClosed(delta.minWriteId, delta.maxWriteId).boxed().collect(Collectors.toList()));
        } else {
            if (ValidWriteIdList.RangeResponse.SOME == abortRange) {
                directory.setUnCompactedAborts(true);
            }
            if (writeIdList.isWriteIdRangeValid(delta.minWriteId, delta.maxWriteId) != ValidWriteIdList.RangeResponse.NONE) {
                directory.getCurrentDirectories().add(delta);
            }
        }
    }

    private static boolean isDirUsable(Path child, long visibilityTxnId, List<Path> aborted, ValidTxnList validTxnList) {
        if (validTxnList == null) {
            throw new IllegalArgumentException("No ValidTxnList for " + child);
        }
        if (!validTxnList.isTxnValid(visibilityTxnId)) {
            boolean isAborted = validTxnList.isTxnAborted(visibilityTxnId);
            if (isAborted) {
                aborted.add(child);
            }
            LOG.debug("getChildState() ignoring(" + aborted + ") " + child);
            return false;
        }
        return true;
    }

    public static boolean isTablePropertyTransactional(Properties props) {
        return AcidUtils.isTablePropertyTransactional((Map<String, String>)Maps.fromProperties((Properties)props));
    }

    public static boolean isTablePropertyTransactional(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional");
        if (resultStr == null) {
            resultStr = parameters.get("transactional".toUpperCase());
        }
        return Boolean.parseBoolean(resultStr);
    }

    public static boolean isDeleteDelta(Path p) {
        return p.getName().startsWith(DELETE_DELTA_PREFIX);
    }

    public static boolean isInsertDelta(Path p) {
        return p.getName().startsWith(DELTA_PREFIX);
    }

    public static boolean isTransactionalTable(CreateTableDesc table) {
        if (table == null || table.getTblProps() == null) {
            return false;
        }
        return AcidUtils.isTransactionalTable(table.getTblProps());
    }

    public static boolean isTransactionalTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return table != null && AcidUtils.isTransactionalTable(table.getTTable());
    }

    public static boolean isTransactionalTable(Table table) {
        return table != null && AcidUtils.isTransactionalTable(table.getParameters());
    }

    public static boolean isTransactionalTable(Map<String, String> props) {
        return props != null && AcidUtils.isTablePropertyTransactional(props);
    }

    public static boolean isTransactionalView(CreateMaterializedViewDesc view) {
        if (view == null || view.getTblProps() == null) {
            return false;
        }
        return AcidUtils.isTransactionalTable(view.getTblProps());
    }

    public static boolean isFullAcidTable(CreateTableDesc td) {
        if (td == null || td.getTblProps() == null) {
            return false;
        }
        return AcidUtils.isFullAcidTable(td.getTblProps());
    }

    public static boolean isFullAcidTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return table != null && AcidUtils.isFullAcidTable(table.getTTable());
    }

    public static boolean isFullAcidTable(Table table) {
        return table != null && AcidUtils.isFullAcidTable(table.getParameters());
    }

    public static boolean isFullAcidTable(Map<String, String> params) {
        return AcidUtils.isTransactionalTable(params) && !AcidUtils.isInsertOnlyTable(params);
    }

    public static boolean isFullAcidScan(Configuration conf) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN)) {
            return false;
        }
        int propInt = conf.getInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, -1);
        if (propInt == -1) {
            return true;
        }
        AcidOperationalProperties props = AcidOperationalProperties.parseInt(propInt);
        return !props.isInsertOnly();
    }

    public static boolean isInsertOnlyFetchBucketId(Configuration conf) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN)) {
            return false;
        }
        int propInt = conf.getInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, -1);
        if (propInt == -1) {
            return false;
        }
        AcidOperationalProperties props = AcidOperationalProperties.parseInt(propInt);
        if (!props.isInsertOnly()) {
            return false;
        }
        return props.isFetchBucketId();
    }

    public static void setAcidOperationalProperties(Configuration conf, boolean isTxnTable, AcidOperationalProperties properties) {
        if (isTxnTable) {
            HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, (boolean)isTxnTable);
            if (properties != null) {
                HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES, (int)properties.toInt());
            }
        } else {
            conf.unset(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname);
            conf.unset(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname);
        }
    }

    public static void setAcidOperationalProperties(Map<String, String> parameters, boolean isTxnTable, AcidOperationalProperties properties) {
        parameters.put(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, Boolean.toString(isTxnTable));
        if (properties != null) {
            parameters.put(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, properties.toString());
        }
    }

    public static AcidOperationalProperties getAcidOperationalProperties(org.apache.hadoop.hive.ql.metadata.Table table) {
        String transactionalProperties = table.getProperty("transactional_properties");
        if (transactionalProperties == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(transactionalProperties);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Configuration conf) {
        return AcidOperationalProperties.parseInt(HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES));
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Properties props) {
        String resultStr = props.getProperty("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static long getLogicalLength(FileSystem fs, FileStatus file) throws IOException {
        Path acidDir = file.getPath().getParent();
        if (AcidUtils.isInsertDelta(acidDir)) {
            ParsedDeltaLight pd = ParsedDeltaLight.parse(acidDir);
            if (!pd.mayContainSideFile()) {
                return file.getLen();
            }
        } else {
            return file.getLen();
        }
        return AcidUtils.getLastFlushLength(fs, file);
    }

    private static long getLastFlushLength(FileSystem fs, FileStatus deltaFile) throws IOException {
        long l;
        block10: {
            Path sideFile = OrcAcidUtils.getSideFile((Path)deltaFile.getPath());
            FSDataInputStream stream = fs.open(sideFile);
            try {
                long result = -1L;
                while (stream.available() > 0) {
                    result = stream.readLong();
                }
                if (result < 0L) {
                    throw new IOException(sideFile + " found but is not readable.  Consider waiting or orcfiledump --recover");
                }
                l = result;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return deltaFile.getLen();
                }
            }
            stream.close();
        }
        return l;
    }

    public static boolean isInsertOnlyTable(Map<String, String> params) {
        String transactionalProp = params.get("transactional_properties");
        return "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static boolean isInsertOnlyTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return AcidUtils.isTransactionalTable(table) && AcidUtils.getAcidOperationalProperties(table).isInsertOnly();
    }

    public static boolean isInsertOnlyTable(Properties params) {
        return AcidUtils.isInsertOnlyTable((Map<String, String>)Maps.fromProperties((Properties)params));
    }

    public static Boolean isToInsertOnlyTable(org.apache.hadoop.hive.ql.metadata.Table tbl, Map<String, String> props) {
        String transactional = props.get("transactional");
        String transactionalProp = props.get("transactional_properties");
        if (transactional == null && transactionalProp == null) {
            return null;
        }
        if (transactional == null && tbl != null) {
            transactional = tbl.getParameters().get("transactional");
        }
        boolean isSetToTxn = Boolean.parseBoolean(transactional);
        if (transactionalProp == null) {
            if (isSetToTxn || tbl == null) {
                return false;
            }
            throw new RuntimeException("Cannot change 'transactional' without 'transactional_properties'");
        }
        if (!"insert_only".equalsIgnoreCase(transactionalProp)) {
            return false;
        }
        if (!isSetToTxn) {
            if (tbl == null) {
                return true;
            }
            throw new RuntimeException("Cannot set 'transactional_properties' to 'insert_only' without setting 'transactional' to 'true'");
        }
        return true;
    }

    public static Boolean isToFullAcid(org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> props) {
        String transactionalProp;
        if (AcidUtils.isTransactionalTable(table) && "default".equalsIgnoreCase(transactionalProp = props.get("transactional_properties"))) {
            return AcidUtils.canBeMadeAcid(table.getTableName(), table.getSd());
        }
        return false;
    }

    public static boolean canBeMadeAcid(String fullTableName, StorageDescriptor sd) {
        return AcidUtils.isAcidInputOutputFormat(fullTableName, sd) && sd.getSortColsSize() <= 0;
    }

    private static boolean isAcidInputOutputFormat(String fullTableName, StorageDescriptor sd) {
        if (sd.getInputFormat() == null || sd.getOutputFormat() == null) {
            return false;
        }
        try {
            return Class.forName("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat").isAssignableFrom(Class.forName(sd.getInputFormat())) && Class.forName("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat").isAssignableFrom(Class.forName(sd.getOutputFormat()));
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not determine if " + fullTableName + " can be made Acid due to: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isRemovedInsertOnlyTable(Set<String> removedSet) {
        boolean hasTxn = removedSet.contains("transactional");
        boolean hasProps = removedSet.contains("transactional_properties");
        return hasTxn || hasProps;
    }

    public static ValidTxnWriteIdList getValidTxnWriteIdList(Configuration conf) {
        String txnString = conf.get("hive.txn.tables.valid.writeids");
        return ValidTxnWriteIdList.fromValue((String)txnString);
    }

    public static ValidWriteIdList getTableValidWriteIdList(Configuration conf, String fullTableName) {
        ValidTxnWriteIdList validTxnList = AcidUtils.getValidTxnWriteIdList(conf);
        return validTxnList.getTableValidWriteIdList(fullTableName);
    }

    public static void setValidWriteIdList(Configuration conf, ValidWriteIdList validWriteIds) {
        conf.set("hive.txn.valid.writeids", validWriteIds.toString());
        LOG.debug("Setting ValidWriteIdList: " + validWriteIds.toString() + " isAcidTable: " + HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, (boolean)false) + " acidProperty: " + AcidUtils.getAcidOperationalProperties(conf));
    }

    public static void setValidWriteIdList(Configuration conf, TableScanDesc tsDesc) {
        if (tsDesc.isTranscationalTable()) {
            String tableName;
            String dbName = tsDesc.getDatabaseName();
            ValidWriteIdList validWriteIdList = AcidUtils.getTableValidWriteIdList(conf, AcidUtils.getFullTableName(dbName, tableName = tsDesc.getTableName()));
            if (validWriteIdList != null) {
                AcidUtils.setValidWriteIdList(conf, validWriteIdList);
            } else {
                LOG.error("setValidWriteIdList on table: " + AcidUtils.getFullTableName(dbName, tableName) + " isAcidTable: true acidProperty: " + AcidUtils.getAcidOperationalProperties(conf) + " couldn't find the ValidWriteId list from ValidTxnWriteIdList: " + conf.get("hive.txn.tables.valid.writeids"));
                throw new IllegalStateException("ACID table: " + AcidUtils.getFullTableName(dbName, tableName) + " is missing from the ValidWriteIdList config: " + conf.get("hive.txn.tables.valid.writeids"));
            }
        }
    }

    public static TableSnapshot getTableSnapshot(Configuration conf, org.apache.hadoop.hive.ql.metadata.Table tbl) throws LockException {
        return AcidUtils.getTableSnapshot(conf, tbl, false);
    }

    public static TableSnapshot getTableSnapshot(Configuration conf, org.apache.hadoop.hive.ql.metadata.Table tbl, boolean isStatsUpdater) throws LockException {
        return AcidUtils.getTableSnapshot(conf, tbl, tbl.getDbName(), tbl.getTableName(), isStatsUpdater);
    }

    public static TableSnapshot getTableSnapshot(Configuration conf, org.apache.hadoop.hive.ql.metadata.Table tbl, String dbName, String tblName, boolean isStatsUpdater) throws LockException, AssertionError {
        if (!AcidUtils.isTransactionalTable(tbl)) {
            return null;
        }
        if (dbName == null) {
            dbName = tbl.getDbName();
        }
        if (tblName == null) {
            tblName = tbl.getTableName();
        }
        long writeId = -1L;
        Object validWriteIdList = null;
        if (SessionState.get() != null) {
            HiveTxnManager sessionTxnMgr = SessionState.get().getTxnMgr();
            String fullTableName = AcidUtils.getFullTableName(dbName, tblName);
            if (sessionTxnMgr != null && sessionTxnMgr.getCurrentTxnId() > 0L) {
                validWriteIdList = AcidUtils.getTableValidWriteIdList(conf, fullTableName);
                if (isStatsUpdater && (writeId = sessionTxnMgr.getAllocatedTableWriteId(dbName, tblName)) < 1L) {
                    LOG.debug("Stats updater for {}.{} doesn't have a write ID ({})", new Object[]{dbName, tblName, writeId});
                }
                if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST) && conf.get("hive.txn.valid.txns") == null) {
                    return null;
                }
                if (validWriteIdList == null) {
                    validWriteIdList = AcidUtils.getTableValidWriteIdListWithTxnList(conf, dbName, tblName);
                }
                if (validWriteIdList == null) {
                    throw new AssertionError((Object)("Cannot find valid write ID list for " + tblName));
                }
            }
        }
        return new TableSnapshot(writeId, validWriteIdList != null ? validWriteIdList.toString() : null);
    }

    public static ValidWriteIdList getTableValidWriteIdListWithTxnList(Configuration conf, String dbName, String tableName) throws LockException {
        HiveTxnManager sessionTxnMgr = SessionState.get().getTxnMgr();
        if (sessionTxnMgr == null) {
            return null;
        }
        String validTxnList = conf.get("hive.txn.valid.txns");
        ArrayList<String> tablesInput = new ArrayList<String>();
        String fullTableName = AcidUtils.getFullTableName(dbName, tableName);
        tablesInput.add(fullTableName);
        ValidTxnWriteIdList validTxnWriteIdList = sessionTxnMgr.getValidWriteIds(tablesInput, validTxnList);
        return validTxnWriteIdList != null ? validTxnWriteIdList.getTableValidWriteIdList(fullTableName) : null;
    }

    public static String getFullTableName(String dbName, String tableName) {
        return TableName.fromString((String)tableName, null, (String)dbName).getNotEmptyDbTable().toLowerCase();
    }

    public static List<FileStatus> getAcidFilesForStats(org.apache.hadoop.hive.ql.metadata.Table table, Path dir, Configuration jc, FileSystem fs) throws IOException {
        Map<Path, HdfsDirSnapshot> hdfsDirSnapshots;
        AcidDirectory acidInfo;
        ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
        ValidWriteIdList idList = AcidUtils.getTableValidWriteIdList(jc, AcidUtils.getFullTableName(table.getDbName(), table.getTableName()));
        if (idList == null) {
            LOG.warn("Cannot get ACID state for " + table.getDbName() + "." + table.getTableName() + " from " + jc.get("hive.txn.tables.valid.writeids"));
            return null;
        }
        if (fs == null) {
            fs = dir.getFileSystem(jc);
        }
        if (!(acidInfo = AcidUtils.getAcidState(fs, dir, jc, idList, null, false, hdfsDirSnapshots = AcidUtils.getHdfsDirSnapshots(fs, dir))).getCurrentDirectories().isEmpty() && AcidUtils.isFullAcidTable(table)) {
            Utilities.FILE_OP_LOGGER.warn("Computing stats for an ACID table; stats may be inaccurate");
        }
        for (HadoopShims.HdfsFileStatusWithId hfs : acidInfo.getOriginalFiles()) {
            fileList.add(hfs.getFileStatus());
        }
        for (ParsedDelta delta : acidInfo.getCurrentDirectories()) {
            fileList.addAll(hdfsDirSnapshots.get(delta.getPath()).getFiles());
        }
        if (acidInfo.getBaseDirectory() != null) {
            fileList.addAll(hdfsDirSnapshots.get(acidInfo.getBaseDirectory()).getFiles());
        }
        return fileList;
    }

    public static List<Path> getValidDataPaths(Path dataPath, Configuration conf, String validWriteIdStr) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        if (validWriteIdStr == null || validWriteIdStr.isEmpty()) {
            pathList.add(dataPath);
            return pathList;
        }
        ValidReaderWriteIdList validWriteIdList = ValidReaderWriteIdList.fromValue((String)validWriteIdStr);
        AcidDirectory acidInfo = AcidUtils.getAcidState(dataPath.getFileSystem(conf), dataPath, conf, (ValidWriteIdList)validWriteIdList, null, false);
        for (HadoopShims.HdfsFileStatusWithId hfs : acidInfo.getOriginalFiles()) {
            pathList.add(hfs.getFileStatus().getPath());
        }
        for (ParsedDelta delta : acidInfo.getCurrentDirectories()) {
            pathList.add(delta.getPath());
        }
        if (acidInfo.getBaseDirectory() != null) {
            pathList.add(acidInfo.getBaseDirectory());
        }
        return pathList;
    }

    public static String getAcidSubDir(Path dataPath) {
        String dataDir = dataPath.getName();
        if (dataDir.startsWith(BASE_PREFIX) || dataDir.startsWith(DELTA_PREFIX) || dataDir.startsWith(DELETE_DELTA_PREFIX)) {
            return dataDir;
        }
        return null;
    }

    public static String getFirstLevelAcidDirPath(Path dataPath, FileSystem fileSystem) throws IOException {
        if (dataPath == null) {
            return null;
        }
        String firstLevelAcidDir = AcidUtils.getAcidSubDir(dataPath);
        if (firstLevelAcidDir != null) {
            return firstLevelAcidDir;
        }
        String acidDirPath = AcidUtils.getFirstLevelAcidDirPath(dataPath.getParent(), fileSystem);
        if (acidDirPath == null) {
            return null;
        }
        if (fileSystem.isDirectory(dataPath)) {
            return acidDirPath + "/" + dataPath.getName();
        }
        return acidDirPath;
    }

    public static boolean isAcidEnabled(HiveConf hiveConf) {
        String txnMgr = hiveConf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER);
        boolean concurrency = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        String dbTxnMgr = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
        return txnMgr.equals(dbTxnMgr) && concurrency;
    }

    public static Long extractWriteId(Path file) {
        String fileName = file.getName();
        if (!fileName.startsWith(DELTA_PREFIX) && !fileName.startsWith(BASE_PREFIX)) {
            LOG.trace("Cannot extract write ID for a MM table: {}", (Object)file);
            return null;
        }
        Object[] parts = fileName.split("_", 4);
        if (parts.length < 2) {
            LOG.debug("Cannot extract write ID for a MM table: " + file + " (" + Arrays.toString(parts) + ")");
            return null;
        }
        long writeId = -1L;
        try {
            writeId = Long.parseLong((String)parts[1]);
        }
        catch (NumberFormatException ex) {
            LOG.debug("Cannot extract write ID for a MM table: " + file + "; parsing " + (String)parts[1] + " got " + ex.getMessage());
            return null;
        }
        return writeId;
    }

    public static void setNonTransactional(Map<String, String> tblProps) {
        tblProps.put("transactional", "false");
        tblProps.remove("transactional_properties");
    }

    private static boolean needsLock(Entity entity, boolean isExternalEnabled) {
        return AcidUtils.needsLock(entity, isExternalEnabled, false);
    }

    private static boolean needsLock(Entity entity, boolean isExternalEnabled, boolean isLocklessReads) {
        switch (entity.getType()) {
            case TABLE: {
                return AcidUtils.isLockableTable(entity.getTable(), isExternalEnabled, isLocklessReads);
            }
            case PARTITION: {
                return AcidUtils.isLockableTable(entity.getPartition().getTable(), isExternalEnabled, isLocklessReads);
            }
        }
        return true;
    }

    private static boolean isLockableTable(org.apache.hadoop.hive.ql.metadata.Table t, boolean isExternalEnabled, boolean isLocklessReads) {
        if (t.isTemporary()) {
            return false;
        }
        switch (t.getTableType()) {
            case MANAGED_TABLE: 
            case MATERIALIZED_VIEW: {
                return !isLocklessReads || !AcidUtils.isTransactionalTable(t);
            }
            case EXTERNAL_TABLE: {
                return isExternalEnabled;
            }
        }
        return false;
    }

    public static List<LockComponent> makeLockComponents(Set<WriteEntity> outputs, Set<ReadEntity> inputs, Context.Operation operation, HiveConf conf) {
        LockComponent comp;
        org.apache.hadoop.hive.ql.metadata.Table t;
        LockComponentBuilder compBuilder;
        ArrayList<LockComponent> lockComponents = new ArrayList<LockComponent>();
        boolean isLocklessReadsEnabled = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
        boolean skipReadLock = !conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_READ_LOCKS);
        boolean skipNonAcidReadLock = !conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_NONACID_READ_LOCKS);
        boolean sharedWrite = !conf.getBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK);
        boolean isExternalEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_EXT_LOCKING_ENABLED);
        boolean isMerge = operation == Context.Operation.MERGE;
        List<ReadEntity> readEntities = inputs.stream().filter(input -> !input.isDummy() && input.needsLock() && !input.isUpdateOrDelete() && AcidUtils.needsLock(input, isExternalEnabled, isLocklessReadsEnabled) && !skipReadLock).collect(Collectors.toList());
        Set<org.apache.hadoop.hive.ql.metadata.Table> fullTableLock = AcidUtils.getFullTableLock(readEntities, conf);
        block20: for (ReadEntity input2 : readEntities) {
            compBuilder = new LockComponentBuilder();
            compBuilder.setSharedRead();
            compBuilder.setOperationType(DataOperationType.SELECT);
            t = null;
            switch (input2.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(input2.getDatabase().getName());
                    break;
                }
                case TABLE: {
                    t = input2.getTable();
                    if (!fullTableLock.contains(t)) continue block20;
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: 
                case DUMMYPARTITION: {
                    compBuilder.setPartitionName(input2.getPartition().getName());
                    t = input2.getPartition().getTable();
                    if (fullTableLock.contains(t)) continue block20;
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block20;
                }
            }
            if (skipNonAcidReadLock && !AcidUtils.isTransactionalTable(t)) continue;
            if (t != null) {
                compBuilder.setIsTransactional(AcidUtils.isTransactionalTable(t));
            }
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request {} ", (Object)comp);
            lockComponents.add(comp);
        }
        block21: for (WriteEntity output : outputs) {
            if (output.getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR || !AcidUtils.needsLock(output, isExternalEnabled)) continue;
            compBuilder = new LockComponentBuilder();
            t = null;
            HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_ACID_DIR_CACHE_DURATION, (int)0);
            switch (output.getType()) {
                case DATABASE: {
                    compBuilder.setDbName(output.getDatabase().getName());
                    break;
                }
                case TABLE: 
                case DUMMYPARTITION: {
                    t = output.getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                case PARTITION: {
                    compBuilder.setPartitionName(output.getPartition().getName());
                    t = output.getPartition().getTable();
                    compBuilder.setDbName(t.getDbName());
                    compBuilder.setTableName(t.getTableName());
                    break;
                }
                default: {
                    continue block21;
                }
            }
            switch (output.getWriteType()) {
                case DDL_EXCLUSIVE: {
                    compBuilder.setExclusive();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case DDL_EXCL_WRITE: {
                    compBuilder.setExclWrite();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case CTAS: {
                    assert (t != null);
                    if (AcidUtils.isTransactionalTable(t)) {
                        compBuilder.setExclWrite();
                        compBuilder.setOperationType(DataOperationType.INSERT);
                        break;
                    }
                    compBuilder.setExclusive();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case INSERT_OVERWRITE: {
                    assert (t != null);
                    if (AcidUtils.isTransactionalTable(t)) {
                        if (conf.getBoolVar(HiveConf.ConfVars.TXN_OVERWRITE_X_LOCK) && !sharedWrite && !isLocklessReadsEnabled) {
                            compBuilder.setExclusive();
                        } else {
                            compBuilder.setExclWrite();
                        }
                        compBuilder.setOperationType(DataOperationType.UPDATE);
                        break;
                    }
                    if (t.isNonNative()) {
                        compBuilder.setLock(AcidUtils.getLockTypeFromStorageHandler(output, t));
                        compBuilder.setOperationType(DataOperationType.UPDATE);
                        break;
                    }
                    compBuilder.setExclusive();
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case INSERT: {
                    assert (t != null);
                    if (AcidUtils.isTransactionalTable(t)) {
                        boolean isExclMergeInsert = conf.getBoolVar(HiveConf.ConfVars.TXN_MERGE_INSERT_X_LOCK) && isMerge;
                        compBuilder.setSharedRead();
                        if (sharedWrite || !isExclMergeInsert && isLocklessReadsEnabled) {
                            compBuilder.setSharedWrite();
                        } else if (isExclMergeInsert) {
                            compBuilder.setExclWrite();
                        }
                        if (isExclMergeInsert) {
                            compBuilder.setOperationType(DataOperationType.UPDATE);
                            break;
                        }
                    } else if (t.isNonNative()) {
                        compBuilder.setLock(AcidUtils.getLockTypeFromStorageHandler(output, t));
                    } else if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE)) {
                        compBuilder.setExclusive();
                    } else {
                        compBuilder.setSharedRead();
                    }
                    compBuilder.setOperationType(DataOperationType.INSERT);
                    break;
                }
                case DDL_SHARED: {
                    compBuilder.setSharedRead();
                    if (output.isTxnAnalyze()) continue block21;
                    compBuilder.setOperationType(DataOperationType.NO_TXN);
                    break;
                }
                case UPDATE: 
                case DELETE: {
                    assert (t != null);
                    if (AcidUtils.isTransactionalTable(t) && sharedWrite) {
                        compBuilder.setSharedWrite();
                    } else if (t.isNonNative()) {
                        compBuilder.setLock(AcidUtils.getLockTypeFromStorageHandler(output, t));
                    } else {
                        compBuilder.setExclWrite();
                    }
                    compBuilder.setOperationType(DataOperationType.valueOf((String)output.getWriteType().name()));
                    break;
                }
                case DDL_NO_LOCK: {
                    continue block21;
                }
                default: {
                    throw new RuntimeException("Unknown write type " + output.getWriteType().toString());
                }
            }
            if (t != null) {
                compBuilder.setIsTransactional(AcidUtils.isTransactionalTable(t));
            }
            compBuilder.setIsDynamicPartitionWrite(output.isDynamicPartitionWrite());
            comp = compBuilder.build();
            LOG.debug("Adding lock component to lock request " + comp.toString());
            lockComponents.add(comp);
        }
        return lockComponents;
    }

    private static LockType getLockTypeFromStorageHandler(WriteEntity output, org.apache.hadoop.hive.ql.metadata.Table t) {
        HiveStorageHandler storageHandler = (HiveStorageHandler)Preconditions.checkNotNull((Object)t.getStorageHandler(), (Object)"Non-native tables must have an instance of storage handler.");
        LockType lockType = storageHandler.getLockType(output);
        if (lockType == null) {
            throw new IllegalArgumentException(String.format("Lock type for Database.Table [%s.%s] is null", t.getDbName(), t.getTableName()));
        }
        return lockType;
    }

    public static boolean isExclusiveCTASEnabled(Configuration conf) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TXN_CTAS_X_LOCK);
    }

    public static boolean isExclusiveCTAS(Set<WriteEntity> outputs, HiveConf conf) {
        return outputs.stream().anyMatch(we -> we.getWriteType().equals((Object)WriteEntity.WriteType.CTAS) && AcidUtils.isExclusiveCTASEnabled((Configuration)conf));
    }

    private static Set<org.apache.hadoop.hive.ql.metadata.Table> getFullTableLock(List<ReadEntity> readEntities, HiveConf conf) {
        int partLocksThreshold = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCKS_PARTITION_THRESHOLD);
        Map<org.apache.hadoop.hive.ql.metadata.Table, Long> partLocksPerTable = readEntities.stream().filter(input -> input.getType() == Entity.Type.PARTITION).map(Entity::getPartition).collect(Collectors.groupingBy(Partition::getTable, Collectors.counting()));
        return readEntities.stream().filter(input -> input.getType() == Entity.Type.TABLE).map(Entity::getTable).filter(t -> !partLocksPerTable.containsKey(t) || partLocksThreshold > 0 && (long)partLocksThreshold <= (Long)partLocksPerTable.get(t)).collect(Collectors.toSet());
    }

    public static void validateAcidFiles(org.apache.hadoop.hive.ql.metadata.Table table, FileStatus[] srcs, FileSystem fs) throws SemanticException {
        if (!AcidUtils.isFullAcidTable(table)) {
            return;
        }
        AcidUtils.validateAcidFiles(srcs, fs);
    }

    private static void validateAcidFiles(FileStatus[] srcs, FileSystem fs) throws SemanticException {
        try {
            if (srcs == null) {
                return;
            }
            for (FileStatus oneSrc : srcs) {
                if (MetaDataFile.isRawFormatFile(oneSrc.getPath(), fs)) continue;
                throw new SemanticException(ErrorMsg.LOAD_DATA_ACID_FILE, new String[]{oneSrc.getPath().toString()});
            }
        }
        catch (IOException ex) {
            throw new SemanticException((Throwable)ex);
        }
    }

    public static void validateAcidPartitionLocation(String location, Configuration conf) throws SemanticException {
        try {
            URI uri = new URI(location);
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
            FileStatus[] fileStatuses = LoadSemanticAnalyzer.matchFilesOrDir(fs, new Path(uri));
            AcidUtils.validateAcidFiles(fileStatuses, fs);
        }
        catch (IOException | URISyntaxException ex) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ex.getMessage()), (Throwable)ex);
        }
    }

    public static TxnType getTxnType(Configuration conf, ASTNode tree) {
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_READONLY_ENABLED) && AcidUtils.isReadOnlyTxn(tree)) {
            return TxnType.READ_ONLY;
        }
        if (tree.getToken().getType() == 908) {
            return TxnType.MATER_VIEW_REBUILD;
        }
        if (AcidUtils.isSoftDeleteTxn(conf, tree)) {
            return TxnType.SOFT_DELETE;
        }
        return TxnType.DEFAULT;
    }

    private static boolean isReadOnlyTxn(ASTNode tree) {
        CalcitePlanner.ASTSearcher astSearcher = new CalcitePlanner.ASTSearcher();
        return READ_TXN_TOKENS.contains(tree.getToken().getType()) || tree.getToken().getType() == 1155 && Stream.of({1056}, {1055, 1243}).noneMatch(pattern -> astSearcher.simpleBreadthFirstSearch(tree, (int)pattern) != null);
    }

    private static boolean isSoftDeleteTxn(Configuration conf, ASTNode tree) {
        boolean locklessReadsEnabled = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
        switch (tree.getToken().getType()) {
            case 1001: 
            case 1006: 
            case 1009: {
                return locklessReadsEnabled || HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX);
            }
            case 856: {
                boolean isRenamePart;
                boolean isDropParts;
                boolean bl = isDropParts = tree.getFirstChildWithType(870) != null;
                if (isDropParts) {
                    return locklessReadsEnabled || HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_DROP_PARTITION_USE_BASE);
                }
                boolean bl2 = isRenamePart = tree.getFirstChildWithType(884) != null;
                if (!isRenamePart) break;
                return locklessReadsEnabled || HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_RENAME_PARTITION_MAKE_COPY);
            }
        }
        return false;
    }

    public static String getPathSuffix(long txnId) {
        return ".v" + String.format(DELTA_DIGITS, txnId);
    }

    @VisibleForTesting
    public static void initDirCache(int durationInMts) {
        if (dirCacheInited.get()) {
            LOG.debug("DirCache got initialized already");
            return;
        }
        dirCache = CacheBuilder.newBuilder().expireAfterWrite((long)durationInMts, TimeUnit.MINUTES).softValues().build();
        dirCacheInited.set(true);
    }

    private static void printDirCacheEntries() {
        if (dirCache != null) {
            LOG.debug("Cache entries: {}", (Object)Arrays.toString(dirCache.asMap().keySet().toArray()));
        }
    }

    public static AcidDirectory getAcidStateFromCache(Supplier<FileSystem> fileSystem, Path candidateDirectory, Configuration conf, ValidWriteIdList writeIdList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles) throws IOException {
        boolean recompute;
        int dirCacheDuration = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_ACID_DIR_CACHE_DURATION);
        if (dirCacheDuration < 0) {
            LOG.debug("dirCache is not enabled");
            return AcidUtils.getAcidState(fileSystem.get(), candidateDirectory, conf, writeIdList, useFileIds, ignoreEmptyFiles);
        }
        AcidUtils.initDirCache(dirCacheDuration);
        String key = writeIdList.getTableName() + "_" + candidateDirectory.toString();
        DirInfoValue value = (DirInfoValue)dirCache.getIfPresent((Object)key);
        long[] exceptions = writeIdList.getInvalidWriteIds();
        boolean bl = recompute = exceptions != null && exceptions.length > 0;
        if (recompute) {
            LOG.info("invalidating cache entry for key: {}", (Object)key);
            dirCache.invalidate((Object)key);
            value = null;
        }
        if (value != null && !value.getTxnString().equalsIgnoreCase(writeIdList.writeToString())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeIdList: {} from cache: {} is not matching for key: {}", new Object[]{writeIdList.writeToString(), value.getTxnString(), key});
            }
            recompute = true;
        }
        if (recompute || value == null) {
            AcidDirectory dirInfo = AcidUtils.getAcidState(fileSystem.get(), candidateDirectory, conf, writeIdList, useFileIds, ignoreEmptyFiles);
            value = new DirInfoValue(writeIdList.writeToString(), dirInfo);
            if (value.dirInfo != null && value.dirInfo.getBaseDirectory() != null && value.dirInfo.getCurrentDirectories().isEmpty()) {
                if (dirCacheDuration > 0) {
                    dirCache.put((Object)key, (Object)value);
                } else {
                    LOG.info("Not populating cache for {}, as duration is set to 0", (Object)key);
                }
            }
        } else {
            LOG.info("Got {} from cache, cache size: {}", (Object)key, (Object)dirCache.size());
        }
        if (LOG.isDebugEnabled()) {
            AcidUtils.printDirCacheEntries();
        }
        return value.getDirInfo();
    }

    public static void tryInvalidateDirCache(Table table) {
        if (dirCacheInited.get()) {
            boolean partitioned;
            String key = AcidUtils.getFullTableName(table.getDbName(), table.getTableName()) + "_" + table.getSd().getLocation();
            boolean bl = partitioned = table.getPartitionKeys() != null && !table.getPartitionKeys().isEmpty();
            if (!partitioned) {
                dirCache.invalidate((Object)key);
            } else {
                dirCache.invalidateAll((Iterable)dirCache.asMap().keySet().stream().filter(k -> k.startsWith(key)).collect(Collectors.toSet()));
            }
        }
    }

    public static boolean isNonNativeAcidTable(org.apache.hadoop.hive.ql.metadata.Table table) {
        return table != null && table.getStorageHandler() != null && table.getStorageHandler().supportsAcidOperations() != HiveStorageHandler.AcidSupportType.NONE;
    }

    public static List<VirtualColumn> getAcidVirtualColumns(org.apache.hadoop.hive.ql.metadata.Table table) {
        if (AcidUtils.isTransactionalTable(table)) {
            return Lists.newArrayList((Object[])new VirtualColumn[]{VirtualColumn.ROWID});
        }
        if (AcidUtils.isNonNativeAcidTable(table)) {
            return table.getStorageHandler().acidVirtualColumns();
        }
        return Collections.emptyList();
    }

    public static boolean acidTableWithoutTransactions(org.apache.hadoop.hive.ql.metadata.Table table) {
        return table != null && table.getStorageHandler() != null && table.getStorageHandler().supportsAcidOperations() == HiveStorageHandler.AcidSupportType.WITHOUT_TRANSACTIONS;
    }

    public static String getPartitionName(Map<String, String> partitionSpec) throws SemanticException {
        String partitionName = null;
        if (partitionSpec != null) {
            try {
                partitionName = Warehouse.makePartName(partitionSpec, (boolean)false);
            }
            catch (MetaException e) {
                throw new SemanticException("partition " + partitionSpec.toString() + " not found");
            }
        }
        return partitionName;
    }

    public static CompactionType compactionTypeStr2ThriftType(String inputValue) throws SemanticException {
        try {
            return CompactionType.valueOf((String)inputValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException("Unexpected compaction type " + inputValue);
        }
    }

    public static CompactionState compactionStateStr2Enum(String inputValue) throws SemanticException {
        try {
            return CompactionState.fromString((String)inputValue);
        }
        catch (IllegalArgumentException e) {
            throw new SemanticException("Unexpected compaction state " + inputValue);
        }
    }

    static {
        dirCacheInited = new AtomicBoolean();
        READ_TXN_TOKENS.addAll(Arrays.asList(990, 993, 1021, 1022));
        originalBucketFilter = new PathFilter(){

            public boolean accept(Path path) {
                return ORIGINAL_PATTERN.matcher(path.getName()).matches() || ORIGINAL_PATTERN_COPY.matcher(path.getName()).matches();
            }
        };
        LOG = LoggerFactory.getLogger(AcidUtils.class);
        ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
        ORIGINAL_PATTERN_COPY = Pattern.compile("[0-9]+_[0-9]+_copy_[0-9]+");
        acidHiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                if (name.startsWith("_metadata_acid")) {
                    return true;
                }
                if (name.startsWith("_orc_acid_version")) {
                    return true;
                }
                return FileUtils.HIDDEN_FILES_PATH_FILTER.accept(p);
            }
        };
        acidTempDirFilter = new PathFilter(){

            public boolean accept(Path dirPath) {
                String dirPathStr = dirPath.toString();
                if (dirPathStr.contains("_tmp_space.db")) {
                    return true;
                }
                return !dirPathStr.contains("/.") && !dirPathStr.contains("/_");
            }
        };
        VISIBILITY_PATTERN = AcidConstants.VISIBILITY_PATTERN;
        SHIMS = ShimLoader.getHadoopShims();
    }

    @Immutable
    public static class ParsedDeltaLight
    implements Comparable<ParsedDeltaLight> {
        final long minWriteId;
        final long maxWriteId;
        final Path path;
        final int statementId;
        final boolean isDeleteDelta;
        final long visibilityTxnId;

        public static ParsedDeltaLight parse(Path deltaDir) {
            long max;
            boolean isDeleteDelta;
            String filename = deltaDir.getName();
            int idxOfVis = filename.indexOf(AcidUtils.VISIBILITY_PREFIX);
            long visibilityTxnId = 0L;
            if (idxOfVis >= 0) {
                visibilityTxnId = Long.parseLong(filename.substring(idxOfVis + AcidUtils.VISIBILITY_PREFIX.length()));
                filename = filename.substring(0, idxOfVis);
            }
            String rest = filename.substring(((isDeleteDelta = filename.startsWith(AcidUtils.DELETE_DELTA_PREFIX)) ? AcidUtils.DELETE_DELTA_PREFIX : AcidUtils.DELTA_PREFIX).length());
            int split = rest.indexOf(95);
            int split2 = rest.indexOf(95, split + 1);
            long min = Long.parseLong(rest.substring(0, split));
            long l = max = split2 == -1 ? Long.parseLong(rest.substring(split + 1)) : Long.parseLong(rest.substring(split + 1, split2));
            if (split2 == -1) {
                return new ParsedDeltaLight(min, max, deltaDir, -1, isDeleteDelta, visibilityTxnId);
            }
            int statementId = Integer.parseInt(rest.substring(split2 + 1));
            return new ParsedDeltaLight(min, max, deltaDir, statementId, isDeleteDelta, visibilityTxnId);
        }

        private ParsedDeltaLight(long min, long max, Path path, int statementId, boolean isDeleteDelta, long visibilityTxnId) {
            this.minWriteId = min;
            this.maxWriteId = max;
            this.path = path;
            this.statementId = statementId;
            this.isDeleteDelta = isDeleteDelta;
            this.visibilityTxnId = visibilityTxnId;
        }

        public long getMinWriteId() {
            return this.minWriteId;
        }

        public long getMaxWriteId() {
            return this.maxWriteId;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean hasStatementId() {
            return this.statementId >= 0;
        }

        public int getStatementId() {
            return this.hasStatementId() ? this.statementId : 0;
        }

        public boolean isDeleteDelta() {
            return this.isDeleteDelta;
        }

        public long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        boolean mayContainSideFile() {
            return !this.isDeleteDelta() && this.getMinWriteId() != this.getMaxWriteId() && this.getVisibilityTxnId() <= 0L;
        }

        @Override
        public int compareTo(ParsedDeltaLight parsedDelta) {
            if (this.minWriteId != parsedDelta.minWriteId) {
                if (this.minWriteId < parsedDelta.minWriteId) {
                    return -1;
                }
                return 1;
            }
            if (this.maxWriteId != parsedDelta.maxWriteId) {
                if (this.maxWriteId < parsedDelta.maxWriteId) {
                    return 1;
                }
                return -1;
            }
            if (this.statementId != parsedDelta.statementId) {
                if (this.statementId < parsedDelta.statementId) {
                    return -1;
                }
                return 1;
            }
            return this.path.compareTo(parsedDelta.path);
        }
    }

    public static class ParsedBaseLight {
        protected final long writeId;
        protected final long visibilityTxnId;
        protected final Path baseDirPath;

        ParsedBaseLight(long writeId, Path baseDirPath) {
            this(writeId, 0L, baseDirPath);
        }

        ParsedBaseLight(long writeId, long visibilityTxnId, Path baseDirPath) {
            this.writeId = writeId;
            this.visibilityTxnId = visibilityTxnId;
            this.baseDirPath = baseDirPath;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public long getVisibilityTxnId() {
            return this.visibilityTxnId;
        }

        public Path getBaseDirPath() {
            return this.baseDirPath;
        }

        public static ParsedBaseLight parseBase(Path path) {
            String filename = path.getName();
            if (!filename.startsWith(AcidUtils.BASE_PREFIX)) {
                throw new IllegalArgumentException(filename + " does not start with base_");
            }
            int idxOfv = filename.indexOf(AcidUtils.VISIBILITY_PREFIX);
            if (idxOfv < 0) {
                return new ParsedBaseLight(Long.parseLong(filename.substring(AcidUtils.BASE_PREFIX.length())), path);
            }
            return new ParsedBaseLight(Long.parseLong(filename.substring(AcidUtils.BASE_PREFIX.length(), idxOfv)), Long.parseLong(filename.substring(idxOfv + AcidUtils.VISIBILITY_PREFIX.length())), path);
        }

        public String toString() {
            return "Path: " + this.baseDirPath + "; writeId: " + this.writeId + "; visibilityTxnId: " + this.visibilityTxnId;
        }
    }

    public static enum Operation implements Serializable
    {
        NOT_ACID,
        INSERT,
        UPDATE,
        DELETE;

    }

    @Immutable
    public static final class ParsedDelta
    extends ParsedDeltaLight
    implements ParsedDirectory {
        private final boolean isRawFormat;
        private List<HadoopShims.HdfsFileStatusWithId> files;

        private ParsedDelta(ParsedDeltaLight delta, boolean isRawFormat, List<HadoopShims.HdfsFileStatusWithId> files) {
            super(delta.minWriteId, delta.maxWriteId, delta.path, delta.statementId, delta.isDeleteDelta, delta.visibilityTxnId);
            this.isRawFormat = isRawFormat;
            this.files = files;
        }

        public boolean isRawFormat() {
            return this.isRawFormat;
        }

        @Override
        public List<HadoopShims.HdfsFileStatusWithId> getFiles(FileSystem fs, Ref<Boolean> useFileIds) throws IOException {
            if (this.files == null && fs != null) {
                this.files = HdfsUtils.listFileStatusWithId(fs, this.path, useFileIds, false, this.isRawFormat() ? originalBucketFilter : bucketFileFilter);
            }
            return this.files;
        }
    }

    public static interface HdfsDirSnapshot {
        public Path getPath();

        public void addOrcAcidFormatFile(FileStatus var1);

        public FileStatus getOrcAcidFormatFile();

        public void addMetadataFile(FileStatus var1);

        public FileStatus getMetadataFile();

        public List<FileStatus> getFiles();

        public void addFile(FileStatus var1);

        public Long getFileId();

        public Boolean isRawFormat();

        public void setIsRawFormat(boolean var1);

        public Boolean isBase();

        public void setIsBase(boolean var1);

        public Boolean isValidBase();

        public void setIsValidBase(boolean var1);

        public Boolean isCompactedBase();

        public void setIsCompactedBase(boolean var1);

        public boolean contains(Path var1);
    }

    public static class MetaDataFile
    extends AcidMetaDataFile {
        static boolean isCompacted(Path baseOrDeltaDir, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
            boolean bl;
            block11: {
                if (dirSnapshot != null && dirSnapshot.getMetadataFile() == null) {
                    return false;
                }
                Path formatFile = new Path(baseOrDeltaDir, "_metadata_acid");
                FSDataInputStream strm = fs.open(formatFile);
                try {
                    Map metaData = (Map)new ObjectMapper().readValue((InputStream)strm, Map.class);
                    if (!"0".equalsIgnoreCase((String)metaData.get(AcidMetaDataFile.Field.VERSION.toString()))) {
                        throw new IllegalStateException("Unexpected Meta Data version: " + (String)metaData.get(AcidMetaDataFile.Field.VERSION));
                    }
                    String dataFormat = metaData.getOrDefault(AcidMetaDataFile.Field.DATA_FORMAT.toString(), "null");
                    AcidMetaDataFile.DataFormat format = AcidMetaDataFile.DataFormat.valueOf((String)dataFormat.toUpperCase());
                    boolean bl2 = bl = AcidMetaDataFile.DataFormat.COMPACTED == format;
                    if (strm == null) break block11;
                }
                catch (Throwable metaData) {
                    try {
                        if (strm != null) {
                            try {
                                strm.close();
                            }
                            catch (Throwable throwable) {
                                metaData.addSuppressed(throwable);
                            }
                        }
                        throw metaData;
                    }
                    catch (FileNotFoundException e) {
                        return false;
                    }
                    catch (IOException e) {
                        String msg = "Failed to read " + baseOrDeltaDir + "/_metadata_acid: " + e.getMessage();
                        LOG.error(msg, (Throwable)e);
                        throw e;
                    }
                }
                strm.close();
            }
            return bl;
        }

        private static Path chooseFile(Path baseOrDeltaDir, FileSystem fs) throws IOException {
            FileStatus[] dataFiles;
            if (!baseOrDeltaDir.getName().startsWith(AcidUtils.BASE_PREFIX) && !baseOrDeltaDir.getName().startsWith(AcidUtils.DELTA_PREFIX)) {
                throw new IllegalArgumentException(baseOrDeltaDir + " is not a base/delta");
            }
            try {
                dataFiles = fs.listStatus(baseOrDeltaDir, originalBucketFilter);
            }
            catch (FileNotFoundException e) {
                dataFiles = null;
            }
            return dataFiles != null && dataFiles.length > 0 ? dataFiles[0].getPath() : null;
        }

        public static boolean isRawFormat(Path baseOrDeltaDir, FileSystem fs, HdfsDirSnapshot dirSnapshot) throws IOException {
            ParsedDeltaLight pd;
            if (AcidUtils.isDeleteDelta(baseOrDeltaDir)) {
                return false;
            }
            if (AcidUtils.isInsertDelta(baseOrDeltaDir) ? (pd = ParsedDeltaLight.parse(baseOrDeltaDir)).getMinWriteId() != pd.getMaxWriteId() : AcidUtils.isCompactedBase(ParsedBaseLight.parseBase(baseOrDeltaDir), fs, dirSnapshot)) {
                return false;
            }
            Path dataFile = null;
            if (dirSnapshot != null && dirSnapshot.getFiles() != null && dirSnapshot.getFiles().size() > 0) {
                for (FileStatus fileStatus : dirSnapshot.getFiles()) {
                    if (!originalBucketFilter.accept(fileStatus.getPath())) continue;
                    dataFile = fileStatus.getPath();
                }
            } else {
                dataFile = MetaDataFile.chooseFile(baseOrDeltaDir, fs);
            }
            if (dataFile == null) {
                return false;
            }
            return MetaDataFile.isRawFormatFile(dataFile, fs);
        }

        public static boolean isRawFormatFile(Path dataFile, FileSystem fs) throws IOException {
            boolean bl;
            block9: {
                Reader reader = OrcFile.createReader(dataFile, OrcFile.readerOptions(fs.getConf()));
                try {
                    bl = OrcInputFormat.isOriginal(reader);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidProtocolBufferException | FileFormatException ex) {
                        LOG.debug("isRawFormat() called on " + dataFile + " which is not an ORC file: " + ex.getMessage());
                        return true;
                    }
                    catch (FileNotFoundException ex) {
                        return false;
                    }
                }
                reader.close();
            }
            return bl;
        }
    }

    public static final class ParsedBase
    extends ParsedBaseLight
    implements ParsedDirectory {
        private boolean rawFormat;
        private List<HadoopShims.HdfsFileStatusWithId> files;

        ParsedBase(ParsedBaseLight pb, List<HadoopShims.HdfsFileStatusWithId> files) {
            super(pb.writeId, pb.visibilityTxnId, pb.baseDirPath);
            this.files = files;
        }

        public boolean isRawFormat() {
            return this.rawFormat;
        }

        public void setRawFormat(boolean rawFormat) {
            this.rawFormat = rawFormat;
        }

        @Override
        public List<HadoopShims.HdfsFileStatusWithId> getFiles(FileSystem fs, Ref<Boolean> useFileIds) throws IOException {
            if (this.files == null && fs != null) {
                this.files = HdfsUtils.listFileStatusWithId(fs, this.baseDirPath, useFileIds, false, FileUtils.HIDDEN_FILES_PATH_FILTER);
            }
            return this.files;
        }

        public void setFiles(List<HadoopShims.HdfsFileStatusWithId> files) {
            this.files = files;
        }

        @Override
        public String toString() {
            return super.toString() + "; rawFormat: " + this.rawFormat;
        }
    }

    public static class HdfsDirSnapshotImpl
    implements HdfsDirSnapshot {
        private Path dirPath;
        private FileStatus metadataFStatus = null;
        private FileStatus orcAcidFormatFStatus = null;
        private List<FileStatus> files = new ArrayList<FileStatus>();
        private Long fileId = null;
        private Boolean isRawFormat = null;
        private Boolean isBase = null;
        private Boolean isValidBase = null;
        private Boolean isCompactedBase = null;

        public HdfsDirSnapshotImpl(Path path, List<FileStatus> files) {
            this.dirPath = path;
            this.files = files;
        }

        public HdfsDirSnapshotImpl(Path path) {
            this.dirPath = path;
        }

        @Override
        public Path getPath() {
            return this.dirPath;
        }

        @Override
        public List<FileStatus> getFiles() {
            return this.files;
        }

        @Override
        public void addFile(FileStatus file) {
            this.files.add(file);
        }

        @Override
        public Long getFileId() {
            return this.fileId;
        }

        @Override
        public Boolean isRawFormat() {
            return this.isRawFormat;
        }

        @Override
        public void setIsRawFormat(boolean isRawFormat) {
            this.isRawFormat = isRawFormat;
        }

        @Override
        public Boolean isBase() {
            return this.isBase;
        }

        @Override
        public Boolean isValidBase() {
            return this.isValidBase;
        }

        @Override
        public Boolean isCompactedBase() {
            return this.isCompactedBase;
        }

        @Override
        public void setIsBase(boolean isBase) {
            this.isBase = isBase;
        }

        @Override
        public void setIsValidBase(boolean isValidBase) {
            this.isValidBase = isValidBase;
        }

        @Override
        public void setIsCompactedBase(boolean isCompactedBase) {
            this.isCompactedBase = isCompactedBase;
        }

        @Override
        public void addOrcAcidFormatFile(FileStatus fStatus) {
            this.orcAcidFormatFStatus = fStatus;
        }

        @Override
        public FileStatus getOrcAcidFormatFile() {
            return this.orcAcidFormatFStatus;
        }

        @Override
        public void addMetadataFile(FileStatus fStatus) {
            this.metadataFStatus = fStatus;
        }

        @Override
        public FileStatus getMetadataFile() {
            return this.metadataFStatus;
        }

        @Override
        public boolean contains(Path path) {
            for (FileStatus fileStatus : this.getFiles()) {
                if (!fileStatus.getPath().equals((Object)path)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Path: " + this.dirPath);
            sb.append("; ");
            sb.append("Files: { ");
            for (FileStatus fStatus : this.files) {
                sb.append(fStatus);
                sb.append(", ");
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static final class OrcAcidVersion {
        public static final String ACID_VERSION_KEY = "hive.acid.version";
        public static final String ACID_FORMAT = "_orc_acid_version";
        private static final Charset UTF8 = Charset.forName("UTF-8");
        public static final int ORC_ACID_VERSION = 2;

        public static void setAcidVersionInDataFile(Writer writer) {
            writer.addUserMetadata(ACID_VERSION_KEY, UTF8.encode(String.valueOf(2)));
        }

        public static void writeVersionFile(Path deltaOrBaseDir, FileSystem fs) throws IOException {
            Path formatFile = OrcAcidVersion.getVersionFilePath(deltaOrBaseDir);
            if (!fs.isFile(formatFile)) {
                try (FSDataOutputStream strm = fs.create(formatFile, false);){
                    strm.write(UTF8.encode(String.valueOf(2)).array());
                }
                catch (IOException ioe) {
                    LOG.error("Failed to create " + formatFile + " due to: " + ioe.getMessage(), (Throwable)ioe);
                    throw ioe;
                }
            }
        }

        public static Path getVersionFilePath(Path deltaOrBase) {
            return new Path(deltaOrBase, ACID_FORMAT);
        }
    }

    public static class AcidOperationalProperties {
        private int description = 0;
        public static final int SPLIT_UPDATE_BIT = 1;
        public static final String SPLIT_UPDATE_STRING = "split_update";
        public static final int HASH_BASED_MERGE_BIT = 2;
        public static final String HASH_BASED_MERGE_STRING = "hash_merge";
        public static final int INSERT_ONLY_BIT = 4;
        public static final int INSERT_ONLY_FETCH_BUCKET_ID_BIT = 8;
        public static final int FETCH_DELETED_ROWS_BIT = 16;
        public static final String INSERT_ONLY_STRING = "insert_only";
        public static final String INSERT_ONLY_FETCH_BUCKET_ID_STRING = "insert_only_fetch_bucket_id";
        public static final String FETCH_DELETED_ROWS_STRING = "fetch_deleted_rows";
        public static final String DEFAULT_VALUE_STRING = "default";
        public static final String INSERTONLY_VALUE_STRING = "insert_only";

        private AcidOperationalProperties() {
        }

        public static AcidOperationalProperties getDefault() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setSplitUpdate(true);
            obj.setHashBasedMerge(false);
            obj.setInsertOnly(false);
            return obj;
        }

        public static AcidOperationalProperties getInsertOnly() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setInsertOnly(true);
            return obj;
        }

        public static AcidOperationalProperties parseString(String propertiesStr) {
            String[] options;
            if (propertiesStr == null) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase(DEFAULT_VALUE_STRING)) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase("insert_only")) {
                return AcidOperationalProperties.getInsertOnly();
            }
            AcidOperationalProperties obj = new AcidOperationalProperties();
            block8: for (String option : options = propertiesStr.split("\\|")) {
                if (option.trim().length() == 0) continue;
                switch (option) {
                    case "split_update": {
                        obj.setSplitUpdate(true);
                        continue block8;
                    }
                    case "hash_merge": {
                        obj.setHashBasedMerge(true);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value " + option + " for ACID operational properties!");
                    }
                }
            }
            return obj;
        }

        public static AcidOperationalProperties parseInt(int properties) {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            if ((properties & 1) > 0) {
                obj.setSplitUpdate(true);
            }
            if ((properties & 2) > 0) {
                obj.setHashBasedMerge(true);
            }
            if ((properties & 4) > 0) {
                obj.setInsertOnly(true);
            }
            if ((properties & 8) > 0) {
                obj.setInsertOnlyFetchBucketId(true);
            }
            if ((properties & 0x10) > 0) {
                obj.setFetchDeletedRows(true);
            }
            return obj;
        }

        public AcidOperationalProperties setSplitUpdate(boolean isSplitUpdate) {
            return this.set(isSplitUpdate, 1);
        }

        public AcidOperationalProperties setHashBasedMerge(boolean isHashBasedMerge) {
            return this.set(isHashBasedMerge, 2);
        }

        public AcidOperationalProperties setInsertOnly(boolean isInsertOnly) {
            return this.set(isInsertOnly, 4);
        }

        public AcidOperationalProperties setInsertOnlyFetchBucketId(boolean fetchBucketId) {
            return this.set(fetchBucketId, 8);
        }

        public AcidOperationalProperties setFetchDeletedRows(boolean fetchDeletedRows) {
            return this.set(fetchDeletedRows, 16);
        }

        private AcidOperationalProperties set(boolean value, int bit) {
            this.description = value ? this.description | bit : this.description & ~bit;
            return this;
        }

        public boolean isSplitUpdate() {
            return (this.description & 1) > 0;
        }

        public boolean isHashBasedMerge() {
            return (this.description & 2) > 0;
        }

        public boolean isInsertOnly() {
            return (this.description & 4) > 0;
        }

        public boolean isFetchBucketId() {
            return (this.description & 8) > 0;
        }

        public boolean isFetchDeletedRows() {
            return (this.description & 0x10) > 0;
        }

        public int toInt() {
            return this.description;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (this.isSplitUpdate()) {
                str.append("|split_update");
            }
            if (this.isHashBasedMerge()) {
                str.append("|hash_merge");
            }
            if (this.isInsertOnly()) {
                str.append("|insert_only");
            }
            if (this.isFetchBucketId()) {
                str.append("|insert_only_fetch_bucket_id");
            }
            if (this.isFetchBucketId()) {
                str.append("|fetch_deleted_rows");
            }
            return str.toString();
        }
    }

    public static class TableSnapshot {
        private long writeId;
        private String validWriteIdList;

        public TableSnapshot() {
        }

        public TableSnapshot(long writeId, String validWriteIdList) {
            this.writeId = writeId;
            this.validWriteIdList = validWriteIdList;
        }

        public String getValidWriteIdList() {
            return this.validWriteIdList;
        }

        public long getWriteId() {
            return this.writeId;
        }

        public void setWriteId(long writeId) {
            this.writeId = writeId;
        }

        public void setValidWriteIdList(String validWriteIdList) {
            this.validWriteIdList = validWriteIdList;
        }

        public String toString() {
            return "[validWriteIdList=" + this.validWriteIdList + ", writeId=" + this.writeId + "]";
        }
    }

    static class DirInfoValue {
        private String txnString;
        private AcidDirectory dirInfo;

        DirInfoValue(String txnString, AcidDirectory dirInfo) {
            this.txnString = txnString;
            this.dirInfo = dirInfo;
        }

        String getTxnString() {
            return this.txnString;
        }

        AcidDirectory getDirInfo() {
            return this.dirInfo;
        }
    }

    public static class IdFullPathFiler
    extends IdPathFilter {
        private final Path basePath;

        public IdFullPathFiler(long writeId, int stmtId, Path basePath) {
            super(writeId, stmtId);
            this.basePath = basePath;
        }

        @Override
        public boolean accept(Path path) {
            do {
                if (!super.accept(path)) continue;
                return true;
            } while ((path = path.getParent()) != null && !path.equals((Object)this.basePath));
            return false;
        }
    }

    public static class IdPathFilter
    implements PathFilter {
        private String baseDirName;
        private String deltaDirName;
        private String deleteDeltaDirName;
        private final boolean isDeltaPrefix;
        private final Set<String> dpSpecs;
        private final int dpLevel;

        public IdPathFilter(long writeId, int stmtId) {
            this(writeId, stmtId, null, 0);
        }

        public IdPathFilter(long writeId, int stmtId, Set<String> dpSpecs, int dpLevel) {
            String deltaDirName = AcidUtils.DELTA_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId) + "_" + String.format(AcidUtils.DELTA_DIGITS, writeId);
            String deleteDeltaDirName = AcidUtils.DELETE_DELTA_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId) + "_" + String.format(AcidUtils.DELTA_DIGITS, writeId);
            boolean bl = this.isDeltaPrefix = stmtId < 0;
            if (!this.isDeltaPrefix) {
                deltaDirName = deltaDirName + "_" + String.format(AcidUtils.STATEMENT_DIGITS, stmtId);
                deleteDeltaDirName = deleteDeltaDirName + "_" + String.format(AcidUtils.STATEMENT_DIGITS, stmtId);
            }
            this.baseDirName = AcidUtils.BASE_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId);
            this.deltaDirName = deltaDirName;
            this.deleteDeltaDirName = deleteDeltaDirName;
            this.dpSpecs = dpSpecs;
            this.dpLevel = dpLevel;
        }

        public boolean accept(Path path) {
            String name = path.getName();
            if (this.dpLevel > 0 && this.dpSpecs != null && !this.dpSpecs.isEmpty()) {
                Path parent = path.getParent();
                Object partitionSpec = parent.getName();
                for (int i = 1; i < this.dpLevel; ++i) {
                    parent = parent.getParent();
                    partitionSpec = parent.getName() + "/" + (String)partitionSpec;
                }
                return name.equals(this.baseDirName) && this.dpSpecs.contains(partitionSpec);
            }
            return name.equals(this.baseDirName) || this.isDeltaPrefix && (name.startsWith(this.deltaDirName) || name.startsWith(this.deleteDeltaDirName)) || !this.isDeltaPrefix && (name.equals(this.deltaDirName) || name.equals(this.deleteDeltaDirName));
        }
    }

    public static class AnyIdDirFilter
    implements PathFilter {
        public boolean accept(Path path) {
            return AcidUtils.extractWriteId(path) != null;
        }
    }

    public static interface ParsedDirectory {
        public List<HadoopShims.HdfsFileStatusWithId> getFiles(FileSystem var1, Ref<Boolean> var2) throws IOException;
    }

    public static interface Directory {
        public List<FileInfo> getFiles() throws IOException;

        public FileSystem getFs();

        public Path getPath();

        public List<ParsedDelta> getDeleteDeltas();
    }

    public static class FileInfo {
        private final HadoopShims.HdfsFileStatusWithId fileId;
        private final AcidBaseFileType acidBaseFileType;

        public FileInfo(HadoopShims.HdfsFileStatusWithId fileId, AcidBaseFileType acidBaseFileType) {
            this.fileId = fileId;
            this.acidBaseFileType = acidBaseFileType;
        }

        public boolean isOriginal() {
            return this.acidBaseFileType == AcidBaseFileType.ORIGINAL_BASE;
        }

        public HadoopShims.HdfsFileStatusWithId getHdfsFileStatusWithId() {
            return this.fileId;
        }
    }

    public static enum AcidBaseFileType {
        ORIGINAL_BASE,
        ACID_SCHEMA;

    }

    public static final class BucketMetaData {
        private static final BucketMetaData INVALID = new BucketMetaData(-1, 0);
        public final int bucketId;
        public final int copyNumber;

        public static BucketMetaData parse(String bucketFileName) {
            if (ORIGINAL_PATTERN.matcher(bucketFileName).matches()) {
                int bucketId = Integer.parseInt(bucketFileName.substring(0, bucketFileName.indexOf(95)));
                return new BucketMetaData(bucketId, 0);
            }
            if (ORIGINAL_PATTERN_COPY.matcher(bucketFileName).matches()) {
                int copyNumber = Integer.parseInt(bucketFileName.substring(bucketFileName.lastIndexOf(95) + 1));
                int bucketId = Integer.parseInt(bucketFileName.substring(0, bucketFileName.indexOf(95)));
                return new BucketMetaData(bucketId, copyNumber);
            }
            if (bucketFileName.startsWith(AcidUtils.BUCKET_PREFIX)) {
                return new BucketMetaData(Integer.parseInt(bucketFileName.substring(bucketFileName.indexOf(95) + 1)), 0);
            }
            return INVALID;
        }

        public static BucketMetaData parse(Path bucketFile) {
            return BucketMetaData.parse(bucketFile.getName());
        }

        private BucketMetaData(int bucketId, int copyNumber) {
            this.bucketId = bucketId;
            this.copyNumber = copyNumber;
        }
    }
}

