/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class SelectStringColLikeStringScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private byte[] pattern;
    transient AbstractFilterStringColLikeStringScalar.Checker checker = null;

    public SelectStringColLikeStringScalar() {
    }

    public SelectStringColLikeStringScalar(int colNum, byte[] pattern, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.pattern = pattern;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.checker == null) {
            this.checker = this.borrowChecker();
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outV.vector;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outV.isNull;
        if (n == 0) {
            return;
        }
        outV.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = this.checker.check(vector[0], start[0], length[0]) ? 1 : 0;
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = false;
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                }
            } else {
                Arrays.fill(outV.isNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!nullPos[i]) {
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                    outV.isNull[i] = false;
                    continue;
                }
                outputVector[i] = 1L;
                outV.isNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!nullPos[i]) {
                    outputVector[i] = this.checker.check(vector[i], start[i], length[i]) ? 1 : 0;
                    outV.isNull[i] = false;
                    continue;
                }
                outputVector[i] = 1L;
                outV.isNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    private AbstractFilterStringColLikeStringScalar.Checker borrowChecker() {
        FilterStringColLikeStringScalar fil = new FilterStringColLikeStringScalar();
        return fil.createChecker(new String(this.pattern, StandardCharsets.UTF_8));
    }

    public void setPattern(byte[] pattern) {
        this.pattern = pattern;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

