/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Writable;

public class VectorMapOperator
extends AbstractMapOperator {
    private static final long serialVersionUID = 1L;
    private transient HashMap<Path, VectorPartitionContext> fileToPartitionContextMap;
    private transient Operator<? extends OperatorDesc> oneRootOperator;
    private transient TypeInfo tableStructTypeInfo;
    private transient StandardStructObjectInspector tableStandardStructObjectInspector;
    private transient TypeInfo[] tableRowTypeInfos;
    private transient int[] dataColumnNums;
    private transient StandardStructObjectInspector neededStandardStructObjectInspector;
    private transient VectorizedRowBatchCtx batchContext;
    private transient VectorizedRowBatch vectorizedInputFileFormatBatch;
    private transient VectorizedRowBatch deserializerBatch;
    private transient long batchCounter;
    private transient int dataColumnCount;
    private transient int partitionColumnCount;
    private transient Object[] partitionValues;
    private transient int virtualColumnCount;
    private transient boolean hasRowIdentifier;
    private transient int rowIdentifierColumnNum;
    private transient boolean[] dataColumnsToIncludeTruncated;
    private transient VectorPartitionDesc.VectorMapOperatorReadType currentReadType;
    private transient VectorPartitionContext currentVectorPartContext;
    private transient int currentDataColumnCount;
    private transient DeserializeRead currentDeserializeRead;
    private transient VectorDeserializeRow currentVectorDeserializeRow;
    private Deserializer currentPartDeserializer;
    private StructObjectInspector currentPartRawRowObjectInspector;
    private VectorAssignRow currentVectorAssign;

    public VectorPartitionContext createAndInitPartitionContext(PartitionDesc partDesc, Configuration hconf) throws SerDeException, Exception {
        VectorPartitionDesc vectorPartDesc = partDesc.getVectorPartitionDesc();
        if (vectorPartDesc == null) {
            return null;
        }
        VectorPartitionDesc.VectorMapOperatorReadType vectorMapOperatorReadType = vectorPartDesc.getVectorMapOperatorReadType();
        if (vectorMapOperatorReadType == VectorPartitionDesc.VectorMapOperatorReadType.VECTOR_DESERIALIZE || vectorMapOperatorReadType == VectorPartitionDesc.VectorMapOperatorReadType.ROW_DESERIALIZE) {
            boolean isAcid = AcidUtils.isTablePropertyTransactional(partDesc.getTableDesc().getProperties());
            Preconditions.checkState((boolean)Utilities.isSchemaEvolutionEnabled(hconf, isAcid));
        }
        VectorPartitionContext vectorPartitionContext = switch (vectorMapOperatorReadType) {
            case VectorPartitionDesc.VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT -> new VectorizedInputFileFormatPartitionContext(partDesc);
            case VectorPartitionDesc.VectorMapOperatorReadType.VECTOR_DESERIALIZE -> new VectorDeserializePartitionContext(partDesc);
            case VectorPartitionDesc.VectorMapOperatorReadType.ROW_DESERIALIZE -> new RowDeserializePartitionContext(partDesc);
            default -> throw new RuntimeException("Unexpected vector MapOperator read type " + vectorMapOperatorReadType.name());
        };
        vectorPartitionContext.init(hconf);
        return vectorPartitionContext;
    }

    private void determineDataColumnsToIncludeTruncated() {
        Preconditions.checkState((this.batchContext != null ? 1 : 0) != 0);
        Preconditions.checkState((this.dataColumnNums != null ? 1 : 0) != 0);
        boolean[] columnsToInclude = new boolean[this.dataColumnCount];
        int count = this.dataColumnNums.length;
        int columnNum = -1;
        for (int i = 0; i < count; ++i) {
            columnNum = this.dataColumnNums[i];
            Preconditions.checkState((columnNum < this.dataColumnCount ? 1 : 0) != 0);
            columnsToInclude[columnNum] = true;
        }
        this.dataColumnsToIncludeTruncated = columnNum == -1 ? new boolean[0] : Arrays.copyOf(columnsToInclude, columnNum + 1);
    }

    public VectorMapOperator() {
    }

    public VectorMapOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initEmptyInputChildren(List<Operator<?>> children, Configuration hconf) throws SerDeException, Exception {
        Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0);
        this.oneRootOperator = children.get(0);
        this.internalSetChildren(hconf);
    }

    @Override
    public void setChildren(Configuration hconf) throws Exception {
        Iterator<Operator<? extends OperatorDesc>> aliasToWorkIterator = ((MapWork)this.conf).getAliasToWork().values().iterator();
        this.oneRootOperator = aliasToWorkIterator.next();
        Preconditions.checkState((!aliasToWorkIterator.hasNext() ? 1 : 0) != 0);
        this.internalSetChildren(hconf);
    }

    private void internalSetChildren(Configuration hconf) throws Exception {
        this.currentReadType = VectorPartitionDesc.VectorMapOperatorReadType.NONE;
        this.batchContext = ((MapWork)this.conf).getVectorizedRowBatchCtx();
        this.vectorizedInputFileFormatBatch = this.batchContext.createVectorizedRowBatch();
        ((MapWork)this.conf).setVectorizedRowBatch(this.vectorizedInputFileFormatBatch);
        this.deserializerBatch = this.batchContext.createVectorizedRowBatch();
        this.batchCounter = 0L;
        this.dataColumnCount = this.batchContext.getDataColumnCount();
        this.partitionColumnCount = this.batchContext.getPartitionColumnCount();
        this.partitionValues = new Object[this.partitionColumnCount];
        this.virtualColumnCount = this.batchContext.getVirtualColumnCount();
        this.rowIdentifierColumnNum = this.batchContext.findVirtualColumnNum(VirtualColumn.ROWID);
        this.hasRowIdentifier = this.rowIdentifierColumnNum != -1;
        this.dataColumnNums = this.batchContext.getDataColumnNums();
        Preconditions.checkState((this.dataColumnNums != null ? 1 : 0) != 0);
        this.determineDataColumnsToIncludeTruncated();
        String[] rowColumnNames = this.batchContext.getRowColumnNames();
        TypeInfo[] rowColumnTypeInfos = this.batchContext.getRowColumnTypeInfos();
        this.tableStructTypeInfo = TypeInfoFactory.getStructTypeInfo(Arrays.asList(rowColumnNames), Arrays.asList(rowColumnTypeInfos));
        this.tableStandardStructObjectInspector = (StandardStructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)this.tableStructTypeInfo);
        this.tableRowTypeInfos = this.batchContext.getRowColumnTypeInfos();
        this.fileToPartitionContextMap = new HashMap();
        HashMap<PartitionDesc, VectorPartitionContext> partitionContextMap = new HashMap<PartitionDesc, VectorPartitionContext>();
        for (Map.Entry<Path, List<String>> entry : ((MapWork)this.conf).getPathToAliases().entrySet()) {
            VectorPartitionContext vectorPartitionContext;
            Path path = entry.getKey();
            PartitionDesc partDesc = ((MapWork)this.conf).getPathToPartitionInfo().get(path);
            if (!partitionContextMap.containsKey(partDesc)) {
                vectorPartitionContext = this.createAndInitPartitionContext(partDesc, hconf);
                partitionContextMap.put(partDesc, vectorPartitionContext);
            } else {
                vectorPartitionContext = (VectorPartitionContext)partitionContextMap.get(partDesc);
            }
            this.fileToPartitionContextMap.put(path, vectorPartitionContext);
        }
        ArrayList<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
        children.add(this.oneRootOperator);
        this.setChildOperators(children);
    }

    @Override
    public void initializeMapOperator(Configuration hconf) throws HiveException {
        super.initializeMapOperator(hconf);
        this.oneRootOperator.initialize(hconf, new ObjectInspector[]{this.tableStandardStructObjectInspector});
    }

    @Override
    public void initializeContexts() throws HiveException {
        Path fpath = this.getExecContext().getCurrentInputPath();
        Path nominalPath = this.getNominalPath(fpath);
        this.setupPartitionContextVars(nominalPath);
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        super.cleanUpInputFileChangedOp();
        Path fpath = this.getExecContext().getCurrentInputPath();
        Path nominalPath = this.getNominalPath(fpath);
        this.setupPartitionContextVars(nominalPath);
        this.oneRootOperator.setInputContext(this.currentVectorPartContext.tableName, this.currentVectorPartContext.partName);
    }

    private void setRowIdentiferToNull(VectorizedRowBatch batch) {
        ColumnVector rowIdentifierColVector = batch.cols[this.rowIdentifierColumnNum];
        rowIdentifierColVector.isNull[0] = true;
        rowIdentifierColVector.noNulls = false;
        rowIdentifierColVector.isRepeating = true;
    }

    private boolean flushDeserializerBatch() throws HiveException {
        if (this.deserializerBatch.size > 0) {
            ++this.batchCounter;
            this.oneRootOperator.process(this.deserializerBatch, 0);
            this.deserializerBatch.reset();
            if (this.oneRootOperator.getDone()) {
                this.setDone(true);
                return false;
            }
        }
        return true;
    }

    private void setupPartitionContextVars(Path nominalPath) throws HiveException {
        this.currentVectorPartContext = this.fileToPartitionContextMap.get(nominalPath);
        if (this.currentVectorPartContext == null) {
            return;
        }
        PartitionDesc partDesc = this.currentVectorPartContext.getPartDesc();
        VectorPartitionDesc vectorPartDesc = partDesc.getVectorPartitionDesc();
        this.currentReadType = vectorPartDesc.getVectorMapOperatorReadType();
        if (this.currentReadType == VectorPartitionDesc.VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT) {
            this.currentDataColumnCount = 0;
            this.currentDeserializeRead = null;
            this.currentVectorDeserializeRow = null;
            this.currentPartDeserializer = null;
            this.currentPartRawRowObjectInspector = null;
            this.currentVectorAssign = null;
        } else {
            Preconditions.checkState((this.currentReadType == VectorPartitionDesc.VectorMapOperatorReadType.VECTOR_DESERIALIZE || this.currentReadType == VectorPartitionDesc.VectorMapOperatorReadType.ROW_DESERIALIZE ? 1 : 0) != 0);
            if (!this.flushDeserializerBatch()) {
                return;
            }
            this.currentDataColumnCount = this.currentVectorPartContext.getReaderDataColumnCount();
            if (this.currentDataColumnCount < this.dataColumnCount) {
                for (int i = this.currentDataColumnCount; i < this.dataColumnCount; ++i) {
                    ColumnVector colVector = this.deserializerBatch.cols[i];
                    if (colVector == null) continue;
                    colVector.isNull[0] = true;
                    colVector.noNulls = false;
                    colVector.isRepeating = true;
                }
            }
            if (this.batchContext.getPartitionColumnCount() > 0) {
                VectorizedRowBatchCtx.getPartitionValues(this.batchContext, partDesc, this.partitionValues);
                this.batchContext.addPartitionColsToBatch(this.deserializerBatch, this.partitionValues);
            }
            if (this.hasRowIdentifier) {
                this.setRowIdentiferToNull(this.deserializerBatch);
            }
            switch (this.currentReadType) {
                case VECTOR_DESERIALIZE: {
                    VectorDeserializePartitionContext vectorDeserPartContext = (VectorDeserializePartitionContext)this.currentVectorPartContext;
                    this.currentDeserializeRead = vectorDeserPartContext.getDeserializeRead();
                    this.currentVectorDeserializeRow = vectorDeserPartContext.getVectorDeserializeRow();
                    this.currentPartDeserializer = null;
                    this.currentPartRawRowObjectInspector = null;
                    this.currentVectorAssign = null;
                    break;
                }
                case ROW_DESERIALIZE: {
                    RowDeserializePartitionContext rowDeserPartContext = (RowDeserializePartitionContext)this.currentVectorPartContext;
                    this.currentDeserializeRead = null;
                    this.currentVectorDeserializeRow = null;
                    this.currentPartDeserializer = rowDeserPartContext.getPartDeserializer();
                    this.currentPartRawRowObjectInspector = rowDeserPartContext.getPartRawRowObjectInspector();
                    this.currentVectorAssign = rowDeserPartContext.getVectorAssign();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected VectorMapOperator read type " + this.currentReadType.name());
                }
            }
        }
    }

    @Override
    public Deserializer getCurrentDeserializer() {
        return null;
    }

    private boolean deliverVectorizedRowBatch(Writable value) throws HiveException {
        ++this.batchCounter;
        if (value != null) {
            int idx;
            VectorizedRowBatch batch = (VectorizedRowBatch)value;
            this.numRows += (long)batch.size;
            if (this.hasRowIdentifier && (idx = this.batchContext.findVirtualColumnNum(VirtualColumn.ROWID)) < 0) {
                this.setRowIdentiferToNull(batch);
            }
        }
        this.oneRootOperator.process(value, 0);
        if (this.oneRootOperator.getDone()) {
            this.setDone(true);
            return false;
        }
        return true;
    }

    private void resetVectorizedRowBatchForDeserialize() {
        int c;
        for (c = 0; c < this.currentDataColumnCount; ++c) {
            this.resetColumnVector(this.deserializerBatch.cols[c]);
        }
        for (c = this.dataColumnCount + this.partitionColumnCount; c < this.deserializerBatch.cols.length; ++c) {
            if (c == this.rowIdentifierColumnNum) continue;
            this.resetColumnVector(this.deserializerBatch.cols[c]);
        }
        this.deserializerBatch.selectedInUse = false;
        this.deserializerBatch.size = 0;
        this.deserializerBatch.endOfFile = false;
    }

    private void resetColumnVector(ColumnVector columnVector) {
        if (columnVector != null) {
            columnVector.reset();
            columnVector.init();
        }
    }

    @Override
    public void process(Writable value) throws HiveException {
        block20: {
            ExecMapperContext context = this.getExecContext();
            if (context != null && context.inputFileChanged()) {
                this.cleanUpInputFileChanged();
            }
            if (!this.oneRootOperator.getDone()) {
                try {
                    if (this.currentReadType == VectorPartitionDesc.VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT) {
                        if (!this.deliverVectorizedRowBatch(value)) {
                            return;
                        }
                        break block20;
                    }
                    if (value instanceof VectorizedRowBatch) {
                        if (!this.flushDeserializerBatch()) {
                            return;
                        }
                        if (!this.deliverVectorizedRowBatch(value)) {
                            return;
                        }
                        break block20;
                    }
                    Preconditions.checkState((this.currentReadType == VectorPartitionDesc.VectorMapOperatorReadType.VECTOR_DESERIALIZE || this.currentReadType == VectorPartitionDesc.VectorMapOperatorReadType.ROW_DESERIALIZE ? 1 : 0) != 0);
                    if (this.deserializerBatch.size == 1024) {
                        this.numRows += (long)this.deserializerBatch.size;
                        ++this.batchCounter;
                        this.oneRootOperator.process(this.deserializerBatch, 0);
                        this.resetVectorizedRowBatchForDeserialize();
                        if (this.oneRootOperator.getDone()) {
                            this.setDone(true);
                            return;
                        }
                    }
                    switch (this.currentReadType) {
                        case VECTOR_DESERIALIZE: {
                            BinaryComparable binComp = (BinaryComparable)value;
                            this.currentDeserializeRead.set(binComp.getBytes(), 0, binComp.getLength());
                            try {
                                this.currentVectorDeserializeRow.deserialize(this.deserializerBatch, this.deserializerBatch.size++);
                                break;
                            }
                            catch (Exception e) {
                                throw new HiveException("\nDeserializeRead detail: " + this.currentVectorDeserializeRow.getDetailedReadPositionString(), (Throwable)e);
                            }
                        }
                        case ROW_DESERIALIZE: {
                            Object deserialized = this.currentPartDeserializer.deserialize(value);
                            ArrayList<Object> standardObjects = new ArrayList<Object>();
                            try {
                                ObjectInspectorUtils.copyToStandardObject(standardObjects, (Object)deserialized, (StructObjectInspector)this.currentPartRawRowObjectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                            }
                            catch (Exception e) {
                                throw new HiveException("copyToStandardObject failed: " + e);
                            }
                            if (standardObjects.size() < this.currentDataColumnCount) {
                                throw new HiveException("Input File Format returned row with too few columns");
                            }
                            this.currentVectorAssign.assignRow(this.deserializerBatch, this.deserializerBatch.size++, standardObjects, this.currentDataColumnCount);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected vector MapOperator read type " + this.currentReadType.name());
                        }
                    }
                }
                catch (Exception e) {
                    throw new HiveException("Hive Runtime Error while processing row ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        throw new HiveException("Hive 2 Internal error: should not be called!");
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort && this.oneRootOperator != null && !this.oneRootOperator.getDone() && this.currentReadType != VectorPartitionDesc.VectorMapOperatorReadType.VECTORIZED_INPUT_FILE_FORMAT && this.deserializerBatch.size > 0) {
            this.numRows += (long)this.deserializerBatch.size;
            ++this.batchCounter;
            this.oneRootOperator.process(this.deserializerBatch, 0);
            this.deserializerBatch.size = 0;
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return VectorMapOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAP";
    }

    @Override
    public OperatorType getType() {
        return null;
    }

    protected class VectorizedInputFileFormatPartitionContext
    extends VectorPartitionContext {
        private VectorizedInputFileFormatPartitionContext(PartitionDesc partDesc) {
            super(partDesc);
        }

        @Override
        public void init(Configuration hconf) {
        }

        @Override
        public int getReaderDataColumnCount() {
            throw new RuntimeException("Not applicable");
        }
    }

    protected class VectorDeserializePartitionContext
    extends VectorPartitionContext {
        private VectorDeserializeRow vectorDeserializeRow;
        private DeserializeRead deserializeRead;
        private int readerColumnCount;

        private VectorDeserializePartitionContext(PartitionDesc partDesc) {
            super(partDesc);
        }

        public VectorDeserializeRow getVectorDeserializeRow() {
            return this.vectorDeserializeRow;
        }

        DeserializeRead getDeserializeRead() {
            return this.deserializeRead;
        }

        @Override
        public int getReaderDataColumnCount() {
            return this.readerColumnCount;
        }

        @Override
        public void init(Configuration hconf) throws SerDeException, HiveException {
            VectorPartitionDesc vectorPartDesc = this.partDesc.getVectorPartitionDesc();
            TypeInfo[] dataTypeInfos = vectorPartDesc.getDataTypeInfos();
            Preconditions.checkState((VectorMapOperator.this.dataColumnsToIncludeTruncated != null ? 1 : 0) != 0);
            TypeInfo[] minimalDataTypeInfos = VectorMapOperator.this.dataColumnsToIncludeTruncated.length < dataTypeInfos.length ? Arrays.copyOf(dataTypeInfos, VectorMapOperator.this.dataColumnsToIncludeTruncated.length) : dataTypeInfos;
            this.readerColumnCount = minimalDataTypeInfos.length;
            switch (vectorPartDesc.getVectorDeserializeType()) {
                case LAZY_SIMPLE: {
                    LazySerDeParameters simpleSerdeParams = new LazySerDeParameters(hconf, this.partDesc.getTableDesc().getProperties(), LazySimpleSerDe.class.getName());
                    LazySimpleDeserializeRead lazySimpleDeserializeRead = new LazySimpleDeserializeRead(minimalDataTypeInfos, VectorMapOperator.this.batchContext.getRowdataTypePhysicalVariations(), true, simpleSerdeParams);
                    this.vectorDeserializeRow = new VectorDeserializeRow<LazySimpleDeserializeRead>(lazySimpleDeserializeRead);
                    this.vectorDeserializeRow.initConversion(VectorMapOperator.this.tableRowTypeInfos, VectorMapOperator.this.dataColumnsToIncludeTruncated);
                    this.deserializeRead = lazySimpleDeserializeRead;
                    break;
                }
                case LAZY_BINARY: {
                    LazyBinaryDeserializeRead lazyBinaryDeserializeRead = new LazyBinaryDeserializeRead(dataTypeInfos, true);
                    this.vectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(lazyBinaryDeserializeRead);
                    this.vectorDeserializeRow.initConversion(VectorMapOperator.this.tableRowTypeInfos, VectorMapOperator.this.dataColumnsToIncludeTruncated);
                    this.deserializeRead = lazyBinaryDeserializeRead;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected vector deserialize row type " + vectorPartDesc.getVectorDeserializeType().name());
                }
            }
        }
    }

    protected class RowDeserializePartitionContext
    extends VectorPartitionContext {
        private Deserializer partDeserializer;
        private StructObjectInspector partRawRowObjectInspector;
        private VectorAssignRow vectorAssign;
        private int readerColumnCount;

        private RowDeserializePartitionContext(PartitionDesc partDesc) {
            super(partDesc);
        }

        public Deserializer getPartDeserializer() {
            return this.partDeserializer;
        }

        public StructObjectInspector getPartRawRowObjectInspector() {
            return this.partRawRowObjectInspector;
        }

        public VectorAssignRow getVectorAssign() {
            return this.vectorAssign;
        }

        @Override
        public int getReaderDataColumnCount() {
            return this.readerColumnCount;
        }

        @Override
        public void init(Configuration hconf) throws Exception {
            VectorPartitionDesc vectorPartDesc = this.partDesc.getVectorPartitionDesc();
            this.partDeserializer = this.partDesc.getDeserializer(hconf);
            this.partRawRowObjectInspector = this.partDeserializer instanceof OrcSerde ? (StructObjectInspector)OrcStruct.createObjectInspector(VectorMapOperator.this.tableStructTypeInfo) : (StructObjectInspector)this.partDeserializer.getObjectInspector();
            TypeInfo[] dataTypeInfos = vectorPartDesc.getDataTypeInfos();
            this.vectorAssign = new VectorAssignRow();
            this.readerColumnCount = this.vectorAssign.initConversion(dataTypeInfos, VectorMapOperator.this.tableRowTypeInfos, VectorMapOperator.this.dataColumnsToIncludeTruncated);
        }
    }

    protected abstract class VectorPartitionContext {
        protected final PartitionDesc partDesc;
        String tableName;
        String partName;

        private VectorPartitionContext(PartitionDesc partDesc) {
            this.partDesc = partDesc;
            TableDesc td = partDesc.getTableDesc();
            Properties overlayedProps = SerDeUtils.createOverlayedProperties((Properties)td.getProperties(), (Properties)partDesc.getProperties());
            LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
            this.tableName = String.valueOf(overlayedProps.getProperty("name"));
            this.partName = String.valueOf(partSpec);
        }

        public PartitionDesc getPartDesc() {
            return this.partDesc;
        }

        public abstract void init(Configuration var1) throws SerDeException, Exception;

        public abstract int getReaderDataColumnCount();
    }
}

