/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezConfigurationFactory;
import org.apache.hadoop.hive.ql.exec.tez.TezRuntimeContext;
import org.apache.hadoop.hive.ql.exec.tez.TezRuntimeException;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.UserPoolMapping;
import org.apache.hadoop.hive.ql.exec.tez.Utils;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManagerFederation;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hive.common.util.Ref;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezTask
extends Task<TezWork> {
    private static final String CLASS_NAME = TezTask.class.getName();
    private static final String JOB_ID_TEMPLATE = "job_%s%d_%s";
    private static final String ICEBERG_PROPERTY_PREFIX = "iceberg.mr.";
    private static final String ICEBERG_SERIALIZED_TABLE_PREFIX = "iceberg.mr.serialized.table.";
    private static Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private static final String TEZ_MEMORY_RESERVE_FRACTION = "tez.task.scale.memory.reserve-fraction";
    private final TezRuntimeContext runtimeContext = new TezRuntimeContext();
    private final DagUtils utils;
    private final Object dagClientLock = new Object();
    private volatile boolean isShutdown = false;
    private DAGClient dagClient = null;
    Map<BaseWork, Vertex> workToVertex = new HashMap<BaseWork, Vertex>();
    Map<BaseWork, JobConf> workToConf = new HashMap<BaseWork, JobConf>();

    public TezTask() {
        this(DagUtils.getInstance());
    }

    public TezTask(DagUtils utils) {
        this.utils = utils;
    }

    public TezCounters getTezCounters() {
        return this.runtimeContext.getCounters();
    }

    public void setTezCounters(TezCounters counters) {
        this.runtimeContext.setCounters(counters);
    }

    public TezRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public String getExternalHandle() {
        return this.jobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() {
        int rc;
        block64: {
            rc = 1;
            boolean cleanContext = false;
            Context ctx = null;
            Ref sessionRef = Ref.from(null);
            String queryId = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
            TezJobMonitor monitor = null;
            try {
                TezSessionState tezSessionState;
                Object ss;
                TezSessionState tezSessionState2;
                ctx = this.context;
                if (ctx == null) {
                    ctx = new Context((Configuration)this.conf);
                    cleanContext = true;
                    WmContext wmContext = new WmContext(System.currentTimeMillis(), queryId);
                    ctx.setWmContext(wmContext);
                }
                if ((tezSessionState2 = (sessionRef.value = ((SessionState)(ss = SessionState.get())).getTezSession())) != null && !tezSessionState2.isOpen()) {
                    LOG.warn("The session: " + tezSessionState2 + " has not been opened");
                }
                String userName = this.getUserNameForGroups((SessionState)ss);
                List groups = null;
                if (userName == null) {
                    userName = "anonymous";
                } else {
                    try {
                        groups = UserGroupInformation.createRemoteUser((String)userName).getGroups();
                    }
                    catch (Exception ex) {
                        LOG.warn("Cannot obtain groups for " + userName, (Throwable)ex);
                    }
                }
                UserPoolMapping.MappingInput mi = new UserPoolMapping.MappingInput(userName, groups, ((SessionState)ss).getHiveVariables().get("wmpool"), ((SessionState)ss).getHiveVariables().get("wmapp"));
                WmContext wmContext = ctx.getWmContext();
                String executionMode = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE);
                this.runtimeContext.setExecutionMode(executionMode);
                JobConf jobConf = this.utils.createConfiguration(this.conf, false);
                HiveConfUtil.updateJobCredentialProviders((Configuration)jobConf);
                String[] allNonConfFiles = ((TezWork)this.work).configureJobConfAndExtractJars(jobConf);
                Path scratchDir = this.utils.createTezDir(ctx.getMRScratchDir(), (Configuration)this.conf);
                CallerContext callerContext = CallerContext.create((String)"HIVE", (String)String.format("%s_User:%s", this.queryPlan.getQueryId(), userName), (String)"HIVE_QUERY_ID", (String)this.queryPlan.getQueryStr());
                this.perfLogger.perfLogBegin(CLASS_NAME, "TezGetSession");
                sessionRef.value = WorkloadManagerFederation.getSession((TezSessionState)sessionRef.value, this.conf, mi, ((TezWork)this.getWork()).getLlapMode(), wmContext);
                TezSessionState object = sessionRef.value;
                this.perfLogger.perfLogEnd(CLASS_NAME, "TezGetSession");
                try {
                    ((SessionState)ss).setTezSession(object);
                    LOG.info("Subscribed to counters: {} for queryId: {}", wmContext.getSubscribedCounters(), (Object)wmContext.getQueryId());
                    this.ensureSessionHasResources(object, allNonConfFiles);
                    List<LocalResource> allNonAppResources = object.getLocalizedResources();
                    this.logResources(allNonAppResources);
                    Map<String, LocalResource> allResources = DagUtils.createTezLrMap(object.getAppJarLr(), allNonAppResources);
                    DAG dag = this.build(jobConf, (TezWork)this.work, scratchDir, ctx, allResources);
                    dag.setCallerContext(callerContext);
                    if (this.isShutdown) {
                        throw new HiveException("Operation cancelled");
                    }
                    DAGClient dagClient = this.submit(dag, (Ref<TezSessionState>)sessionRef);
                    tezSessionState = (TezSessionState)sessionRef.value;
                    boolean wasShutdown = false;
                    Object object2 = this.dagClientLock;
                    synchronized (object2) {
                        assert (this.dagClient == null);
                        wasShutdown = this.isShutdown;
                        if (!wasShutdown) {
                            this.dagClient = dagClient;
                        }
                    }
                    if (wasShutdown) {
                        this.closeDagClientOnCancellation(dagClient);
                        throw new HiveException("Operation cancelled");
                    }
                    String dagId = this.dagClient.getDagIdentifierString();
                    String appId = this.dagClient.getSessionIdentifierString();
                    LOG.info("HS2 Host: [{}], Query ID: [{}], Dag ID: [{}], DAG App ID: [{}], DAG App address: [{}]", new Object[]{ServerUtils.hostname(), queryId, dagId, appId, tezSessionState.getSession().getAmHost()});
                    LogUtils.putToMDC((String)"dagId", (String)dagId);
                    this.jobID = dagId;
                    this.runtimeContext.setDagId(dagId);
                    this.runtimeContext.setSessionId(tezSessionState.getSessionId());
                    this.runtimeContext.setApplicationId(appId);
                    monitor = new TezJobMonitor(tezSessionState, ((TezWork)this.work).getAllWork(), dagClient, this.conf, dag, ctx, this.runtimeContext.counters, this.perfLogger);
                    this.runtimeContext.setMonitor(monitor);
                    rc = monitor.monitorExecution();
                    if (rc != 0) {
                        this.setException((Throwable)((Object)new TezRuntimeException(dagId, monitor.getDiagnostics())));
                    }
                    try {
                        TezCounters mergedCounters;
                        EnumSet<StatusGetOpts> statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
                        DAGStatus dagStatus = dagClient.getDAGStatus(statusGetOpts);
                        this.setStatusMessage(dagStatus.getState().name());
                        TezCounters dagCounters = dagStatus.getDAGCounters();
                        this.runtimeContext.counters = mergedCounters = this.runtimeContext.counters == null ? dagCounters : Utils.mergeTezCounters(dagCounters, this.runtimeContext.counters);
                    }
                    catch (Exception err) {
                        LOG.warn("Failed to get counters. Ignoring, summary info will be incomplete.", (Throwable)err);
                        this.runtimeContext.counters = null;
                    }
                    if (rc == 0) {
                        this.collectCommitInformation((TezWork)this.work);
                    }
                    wmContext = ctx.getWmContext();
                }
                catch (Throwable throwable) {
                    wmContext = ctx.getWmContext();
                    try {
                        if (sessionRef.value != null) {
                            ((TezSessionState)sessionRef.value).returnToSessionManager();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to return session: {} to pool", (Object)object, (Object)e);
                        throw e;
                    }
                    if (!this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("none") && wmContext != null) {
                        if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("json")) {
                            wmContext.printJson(this.console);
                        } else if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("text")) {
                            wmContext.print(this.console);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (sessionRef.value != null) {
                        ((TezSessionState)sessionRef.value).returnToSessionManager();
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to return session: {} to pool", (Object)tezSessionState, (Object)e);
                    throw e;
                }
                if (!this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("none") && wmContext != null) {
                    if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("json")) {
                        wmContext.printJson(this.console);
                    } else if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("text")) {
                        wmContext.print(this.console);
                    }
                }
                if (LOG.isInfoEnabled() && this.runtimeContext.counters != null && (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_EXEC_SUMMARY) || Utilities.isPerfOrAboveLogging(this.conf))) {
                    for (CounterGroup group : this.runtimeContext.counters) {
                        monitor.logger().printInfo(group.getDisplayName() + ":");
                        for (TezCounter counter : group) {
                            monitor.logger().printInfo("   " + counter.getDisplayName() + ": " + counter.getValue());
                        }
                    }
                }
                this.updateNumRows();
                Utilities.clearWork((Configuration)this.conf);
            }
            catch (Exception e) {
                LOG.error("Failed to execute tez graph.", (Throwable)e);
                this.setException(e);
                break block64;
            }
            finally {
                Utilities.clearWork((Configuration)this.conf);
                for (BaseWork baseWork : ((TezWork)this.work).getAllWork()) {
                    JobConf workCfg = this.workToConf.get(baseWork);
                    if (workCfg == null) continue;
                    Utilities.clearWorkMapForConf((Configuration)workCfg);
                }
                if (cleanContext) {
                    try {
                        ctx.clear();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to clean up after tez job", (Throwable)e);
                    }
                }
                DAGClient dagClient = null;
                Object object = this.dagClientLock;
                synchronized (object) {
                    dagClient = this.dagClient;
                    this.dagClient = null;
                }
                if (dagClient != null) {
                    rc = this.close((TezWork)this.work, rc, dagClient);
                }
                if (monitor != null) {
                    monitor.logger().endSummary();
                }
            }
            for (BaseWork baseWork : ((TezWork)this.work).getAllWork()) {
                JobConf workCfg = this.workToConf.get(baseWork);
                if (workCfg == null) continue;
                Utilities.clearWorkMapForConf((Configuration)workCfg);
            }
            if (cleanContext) {
                try {
                    ctx.clear();
                }
                catch (Exception e) {
                    LOG.warn("Failed to clean up after tez job", (Throwable)e);
                }
            }
            DAGClient dagClient = null;
            Object object = this.dagClientLock;
            synchronized (object) {
                dagClient = this.dagClient;
                this.dagClient = null;
            }
            if (dagClient != null) {
                rc = this.close((TezWork)this.work, rc, dagClient);
            }
            if (monitor != null) {
                monitor.logger().endSummary();
            }
        }
        return rc;
    }

    private void collectCommitInformation(TezWork work) throws IOException, TezException {
        for (BaseWork w : work.getAllWork()) {
            JobConf jobConf = this.workToConf.get(w);
            Vertex vertex = this.workToVertex.get(w);
            boolean hasIcebergCommitter = Optional.ofNullable(jobConf).map(JobConf::getOutputCommitter).map(Object::getClass).map(Class::getName).filter(name -> name.endsWith("HiveIcebergNoJobCommitter")).isPresent();
            if (!hasIcebergCommitter || vertex.getDataSinks().isEmpty()) continue;
            VertexStatus status = this.dagClient.getVertexStatus(vertex.getName(), EnumSet.of(StatusGetOpts.GET_COUNTERS));
            String[] jobIdParts = status.getId().split("_");
            int vertexId = Integer.parseInt(jobIdParts[jobIdParts.length - 1]);
            String jobId = String.format(JOB_ID_TEMPLATE, jobIdParts[1], vertexId, jobIdParts[2]);
            ArrayList<String> tables = new ArrayList<String>();
            HashMap<String, String> icebergProperties = new HashMap<String, String>();
            for (Map.Entry entry : jobConf) {
                if (((String)entry.getKey()).startsWith(ICEBERG_SERIALIZED_TABLE_PREFIX)) {
                    tables.add(((String)entry.getKey()).substring(ICEBERG_SERIALIZED_TABLE_PREFIX.length()));
                    continue;
                }
                if (!((String)entry.getKey()).startsWith(ICEBERG_PROPERTY_PREFIX)) continue;
                icebergProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
            tables.forEach(table -> SessionStateUtil.addCommitInfo((Configuration)jobConf, table, jobId, status.getProgress().getSucceededTaskCount(), icebergProperties));
        }
    }

    private void updateNumRows() {
        TezCounter counter;
        if (this.runtimeContext.counters != null && (counter = this.runtimeContext.counters.findCounter(this.conf.getVar(HiveConf.ConfVars.HIVE_COUNTER_GROUP), "TOTAL_TABLE_ROWS_WRITTEN")) != null) {
            this.queryState.setNumModifiedRows(counter.getValue());
        }
    }

    private String getUserNameForGroups(SessionState ss) {
        String userName;
        if (ss.getAuthenticator() != null && (userName = ss.getAuthenticator().getUserName()) != null) {
            return userName;
        }
        return ss.getUserName();
    }

    private void closeDagClientOnCancellation(DAGClient dagClient) {
        try {
            dagClient.tryKillDAG();
            LOG.info("Waiting for Tez task to shut down: " + this);
            dagClient.waitForCompletion();
        }
        catch (Exception ex) {
            LOG.warn("Failed to shut down TezTask" + this, (Throwable)ex);
        }
        TezTask.closeDagClientWithoutEx(dagClient);
    }

    private void logResources(List<LocalResource> additionalLr) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        if (additionalLr == null || additionalLr.size() == 0) {
            LOG.debug("No local resources to process (other than hive-exec)");
        } else {
            for (LocalResource lr : additionalLr) {
                LOG.debug("Adding local resource: " + lr.getResource());
            }
        }
    }

    @VisibleForTesting
    void ensureSessionHasResources(TezSessionState session, String[] nonConfResources) throws Exception {
        TezClient client = session.getSession();
        if (client == null) {
            LOG.info("Tez session hasn't been created yet. Opening session");
            session.open(nonConfResources);
        } else {
            LOG.info("Session is already open");
            session.ensureLocalResources((Configuration)this.conf, nonConfResources);
        }
    }

    void checkOutputSpec(BaseWork work, JobConf jc) throws IOException {
        for (Operator<?> op : work.getAllOperators()) {
            if (!(op instanceof FileSinkOperator)) continue;
            ((FileSinkOperator)op).checkOutputSpecs(null, jc);
        }
    }

    DAG build(JobConf conf, TezWork tezWork, Path scratchDir, Context ctx, Map<String, LocalResource> vertexResources) throws Exception {
        this.perfLogger.perfLogBegin(CLASS_NAME, "TezBuildDag");
        List<BaseWork> topologicalWorkList = tezWork.getAllWork();
        Collections.reverse(topologicalWorkList);
        String dagName = this.utils.createDagName((Configuration)conf, this.queryPlan);
        LOG.info("Dag name: {}", (Object)dagName);
        DAG dag = DAG.create((String)dagName);
        JSONObject json = new JSONObject(new LinkedHashMap()).put("context", (Object)"Hive").put("description", (Object)ctx.getCmd());
        String dagInfo = json.toString();
        String queryId = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        dag.setConf(HiveConf.ConfVars.HIVE_QUERY_ID.varname, queryId);
        LOG.debug("DagInfo: {}", (Object)dagInfo);
        TezConfigurationFactory.addProgrammaticallyAddedTezOptsToDagConf(dag.getDagConf(), conf);
        dag.setDAGInfo(dagInfo);
        dag.setCredentials(conf.getCredentials());
        TezTask.setAccessControlsForCurrentUser(dag, this.queryPlan.getQueryId(), (Configuration)conf);
        for (BaseWork workUnit : topologicalWorkList) {
            this.perfLogger.perfLogBegin(CLASS_NAME, "TezCreateVertex." + workUnit.getName());
            if (workUnit instanceof UnionWork) {
                LinkedList<BaseWork> unionWorkItems = new LinkedList<BaseWork>();
                LinkedList<BaseWork> children = new LinkedList<BaseWork>();
                for (BaseWork v : tezWork.getChildren(workUnit)) {
                    TezEdgeProperty.EdgeType type = tezWork.getEdgeProperty(workUnit, v).getEdgeType();
                    if (type == TezEdgeProperty.EdgeType.CONTAINS) {
                        unionWorkItems.add(v);
                        continue;
                    }
                    children.add(v);
                }
                JobConf parentConf = this.workToConf.get(unionWorkItems.get(0));
                this.checkOutputSpec(workUnit, parentConf);
                Vertex[] vertexArray = new Vertex[unionWorkItems.size()];
                int i = 0;
                for (BaseWork v : unionWorkItems) {
                    vertexArray[i++] = this.workToVertex.get(v);
                }
                VertexGroup group = dag.createVertexGroup(workUnit.getName(), vertexArray);
                for (BaseWork v : children) {
                    GroupInputEdge e = this.utils.createEdge(group, parentConf, this.workToVertex.get(v), tezWork.getEdgeProperty(workUnit, v), v, tezWork);
                    dag.addEdge(e);
                }
                continue;
            }
            JobConf wxConf = this.utils.initializeVertexConf(conf, ctx, workUnit);
            this.checkOutputSpec(workUnit, wxConf);
            Vertex wx = this.utils.createVertex(wxConf, workUnit, scratchDir, tezWork, vertexResources);
            if (tezWork.getChildren(workUnit).size() > 1) {
                String tezRuntimeSortMb = wxConf.get("tez.runtime.io.sort.mb");
                int originalValue = 0;
                originalValue = tezRuntimeSortMb == null ? 100 : Integer.valueOf(tezRuntimeSortMb);
                int newValue = originalValue / tezWork.getChildren(workUnit).size();
                wxConf.set("tez.runtime.io.sort.mb", Integer.toString(newValue));
                LOG.info("Modified tez.runtime.io.sort.mb to " + newValue);
            }
            if (workUnit.getReservedMemoryMB() > 0) {
                double frac = DagUtils.adjustMemoryReserveFraction(workUnit.getReservedMemoryMB(), this.conf);
                LOG.info("Setting tez.task.scale.memory.reserve-fraction to " + frac);
                wx.setConf(TEZ_MEMORY_RESERVE_FRACTION, Double.toString(frac));
            }
            dag.addVertex(wx);
            this.utils.addCredentials(workUnit, dag, conf);
            this.perfLogger.perfLogEnd(CLASS_NAME, "TezCreateVertex." + workUnit.getName());
            this.workToVertex.put(workUnit, wx);
            this.workToConf.put(workUnit, wxConf);
            for (BaseWork v : tezWork.getChildren(workUnit)) {
                assert (this.workToVertex.containsKey(v));
                Edge e = null;
                TezEdgeProperty edgeProp = tezWork.getEdgeProperty(workUnit, v);
                e = this.utils.createEdge(wxConf, wx, this.workToVertex.get(v), edgeProp, v, tezWork);
                dag.addEdge(e);
            }
        }
        Utilities.clearWorkMap((Configuration)conf);
        this.perfLogger.perfLogEnd(CLASS_NAME, "TezBuildDag");
        return dag;
    }

    private static void setAccessControlsForCurrentUser(DAG dag, String queryId, Configuration conf) throws IOException {
        String user = SessionState.getUserFromAuthenticator();
        UserGroupInformation loginUserUgi = UserGroupInformation.getLoginUser();
        String loginUser = loginUserUgi == null ? null : loginUserUgi.getShortUserName();
        boolean addHs2User = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_HS2_USER_ACCESS);
        String viewStr = Utilities.getAclStringWithHiveModification(conf, "tez.am.view-acls", addHs2User, user, loginUser);
        String modifyStr = Utilities.getAclStringWithHiveModification(conf, "tez.am.modify-acls", addHs2User, user, loginUser);
        LOG.debug("Setting Tez DAG access for queryId={} with viewAclString={}, modifyStr={}", new Object[]{queryId, viewStr, modifyStr});
        DAGAccessControls ac = new DAGAccessControls(viewStr, modifyStr);
        dag.setAccessControls(ac);
    }

    private TezSessionState getNewTezSessionOnError(TezSessionState oldSession) throws Exception {
        TezSessionState newSession = oldSession.reopen();
        this.console.printInfo("Session re-established.");
        return newSession;
    }

    DAGClient submit(DAG dag, Ref<TezSessionState> sessionStateRef) throws Exception {
        this.perfLogger.perfLogBegin(CLASS_NAME, "TezSubmitDag");
        DAGClient dagClient = null;
        TezSessionState sessionState = (TezSessionState)sessionStateRef.value;
        try {
            try {
                dagClient = this.submitInternal(dag, sessionState);
            }
            catch (SessionNotRunning nr) {
                this.console.printInfo("Tez session was closed. Reopening...");
                sessionState = this.getNewTezSessionOnError(sessionState);
                sessionStateRef.value = sessionState;
                this.console.printInfo("Session re-established.");
                dagClient = this.submitInternal(dag, sessionState);
            }
        }
        catch (Exception e) {
            if (this.isShutdown) {
                this.sessionDestroyOrReturnToPool(sessionStateRef, sessionState);
                throw e;
            }
            try {
                this.console.printInfo("Dag submit failed due to " + e.getMessage() + " stack trace: " + Arrays.toString(e.getStackTrace()) + " retrying...");
                sessionState = this.getNewTezSessionOnError(sessionState);
                sessionStateRef.value = sessionState;
                dagClient = this.submitInternal(dag, sessionState);
            }
            catch (Exception retryException) {
                this.sessionDestroyOrReturnToPool(sessionStateRef, sessionState);
                throw retryException;
            }
        }
        this.perfLogger.perfLogEnd(CLASS_NAME, "TezSubmitDag");
        return new SyncDagClient(dagClient);
    }

    private DAGClient submitInternal(DAG dag, TezSessionState sessionState) throws TezException, IOException {
        this.runtimeContext.init(sessionState);
        return sessionState.getSession().submitDAG(dag);
    }

    private void sessionDestroyOrReturnToPool(Ref<TezSessionState> sessionStateRef, TezSessionState sessionState) throws Exception {
        sessionStateRef.value = null;
        if (sessionState.isDefault() && sessionState instanceof TezSessionPoolSession) {
            sessionState.returnToSessionManager();
        } else {
            sessionState.destroy();
        }
    }

    @VisibleForTesting
    int close(TezWork work, int rc, DAGClient dagClient) {
        block6: {
            try {
                List<BaseWork> ws = work.getAllWork();
                for (BaseWork w : ws) {
                    if (w instanceof MergeJoinWork) {
                        w = ((MergeJoinWork)w).getMainWork();
                    }
                    for (Operator<?> op : w.getAllOperators()) {
                        op.jobClose((Configuration)this.conf, rc == 0);
                    }
                }
            }
            catch (Exception e) {
                if (rc != 0) break block6;
                rc = 3;
                String mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }
        if (dagClient != null) {
            TezTask.closeDagClientWithoutEx(dagClient);
        }
        return rc;
    }

    private static void closeDagClientWithoutEx(DAGClient dagClient) {
        try {
            dagClient.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close DagClient", (Throwable)e);
        }
    }

    @Override
    public void updateTaskMetrics(Metrics metrics) {
        metrics.incrementCounter("hive_tez_tasks");
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    public String getName() {
        return "TEZ";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    @Override
    public Collection<MapWork> getMapWork() {
        LinkedList<MapWork> result = new LinkedList<MapWork>();
        TezWork work = (TezWork)this.getWork();
        for (BaseWork w : work.getAllWorkUnsorted()) {
            if (!(w instanceof MapWork)) continue;
            List<BaseWork> parents = work.getParents(w);
            boolean candidate = true;
            for (BaseWork parent : parents) {
                if (parent instanceof UnionWork) continue;
                candidate = false;
            }
            if (!candidate) continue;
            result.add((MapWork)w);
        }
        return result;
    }

    @Override
    public Operator<? extends OperatorDesc> getReducer(MapWork mapWork) {
        List<BaseWork> children = ((TezWork)this.getWork()).getChildren(mapWork);
        if (children.size() != 1) {
            return null;
        }
        if (!(children.get(0) instanceof ReduceWork)) {
            return null;
        }
        return ((ReduceWork)children.get(0)).getReducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        DAGClient dagClient = null;
        Object object = this.dagClientLock;
        synchronized (object) {
            this.isShutdown = true;
            dagClient = this.dagClient;
        }
        LOG.info("Shutting down Tez task " + this + " " + (dagClient == null ? " before submit" : ""));
        if (dagClient == null) {
            return;
        }
        this.closeDagClientOnCancellation(dagClient);
    }

    public class SyncDagClient
    extends DAGClient {
        private final DAGClient dagClient;

        public SyncDagClient(DAGClient dagClient) {
            this.dagClient = dagClient;
        }

        public void close() throws IOException {
            this.dagClient.close();
        }

        public String getDagIdentifierString() {
            return this.dagClient.getDagIdentifierString();
        }

        public String getSessionIdentifierString() {
            return this.dagClient.getSessionIdentifierString();
        }

        public String getExecutionContext() {
            return this.dagClient.getExecutionContext();
        }

        @InterfaceAudience.Private
        protected ApplicationReport getApplicationReportInternal() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions) throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getDAGStatus(statusOptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getDAGStatus(statusOptions, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getVertexStatus(vertexName, statusOptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tryKillDAG() throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                this.dagClient.tryKillDAG();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus waitForCompletion() throws IOException, TezException, InterruptedException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.waitForCompletion();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus waitForCompletionWithStatusUpdates(@Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.waitForCompletionWithStatusUpdates(statusGetOpts);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getWebUIAddress() throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getWebUIAddress();
            }
        }
    }
}

