/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.show;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.show.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1215})
public class ShowCreateTableAnalyzer
extends BaseSemanticAnalyzer {
    public ShowCreateTableAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        Map.Entry<String, String> tableIdentifier = ShowCreateTableAnalyzer.getDbTableNamePair((ASTNode)root.getChild(0));
        if (tableIdentifier.getValue().contains(".")) {
            throw new SemanticException("The SHOW CREATE TABLE command is not supported for metadata tables.");
        }
        Table table = this.getTable(tableIdentifier.getKey(), tableIdentifier.getValue(), true);
        this.inputs.add(new ReadEntity(table));
        ShowCreateTableDesc desc = new ShowCreateTableDesc(table.getDbName(), table.getTableName(), this.ctx.getResFile().toString(), StringUtils.isBlank((CharSequence)tableIdentifier.getKey()));
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("createtab_stmt#string"));
    }
}

