/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.SimpleProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.TestProcedureEvents;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureSchedulerConcurrency {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureSchedulerConcurrency.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureEvents.class);
    private SimpleProcedureScheduler procSched;

    @Before
    public void setUp() throws IOException {
        this.procSched = new SimpleProcedureScheduler();
        this.procSched.start();
    }

    @After
    public void tearDown() throws IOException {
        this.procSched.stop();
    }

    @Test
    public void testConcurrentWaitWake() throws Exception {
        this.testConcurrentWaitWake(false);
    }

    @Test
    public void testConcurrentWaitWakeBatch() throws Exception {
        this.testConcurrentWaitWake(true);
    }

    private void testConcurrentWaitWake(final boolean useWakeBatch) throws Exception {
        int i;
        int WAIT_THRESHOLD = 2500;
        int NPROCS = 20;
        int NRUNS = 500;
        SimpleProcedureScheduler sched = this.procSched;
        for (long i2 = 0L; i2 < 20L; ++i2) {
            sched.addBack((Procedure)new TestProcedureWithEvent(i2));
        }
        Thread[] threads = new Thread[4];
        AtomicInteger waitCount = new AtomicInteger(0);
        final AtomicInteger wakeCount = new AtomicInteger(0);
        final ConcurrentSkipListSet waitQueue = new ConcurrentSkipListSet();
        threads[0] = new Thread((ProcedureScheduler)sched){
            final /* synthetic */ ProcedureScheduler val$sched;
            {
                this.val$sched = procedureScheduler;
            }

            @Override
            public void run() {
                long lastUpdate = 0L;
                while (true) {
                    int oldWakeCount = wakeCount.get();
                    if (useWakeBatch) {
                        ProcedureEvent[] ev = new ProcedureEvent[waitQueue.size()];
                        for (int i = 0; i < ev.length; ++i) {
                            ev[i] = ((TestProcedureWithEvent)((Object)waitQueue.pollFirst())).getEvent();
                            LOG.debug("WAKE BATCH " + ev[i] + " total=" + wakeCount.get());
                        }
                        ProcedureEvent.wakeEvents((AbstractProcedureScheduler)((AbstractProcedureScheduler)this.val$sched), (ProcedureEvent[])ev);
                        wakeCount.addAndGet(ev.length);
                    } else {
                        int size = waitQueue.size();
                        while (size-- > 0) {
                            ProcedureEvent ev = ((TestProcedureWithEvent)((Object)waitQueue.pollFirst())).getEvent();
                            ev.wake((AbstractProcedureScheduler)TestProcedureSchedulerConcurrency.this.procSched);
                            LOG.debug("WAKE " + ev + " total=" + wakeCount.get());
                            wakeCount.incrementAndGet();
                        }
                    }
                    if (wakeCount.get() != oldWakeCount) {
                        lastUpdate = EnvironmentEdgeManager.currentTime();
                    } else if (wakeCount.get() >= 500 && EnvironmentEdgeManager.currentTime() - lastUpdate > 2500L) break;
                    Threads.sleepWithoutInterrupt((long)25L);
                }
            }
        };
        for (i = 1; i < threads.length; ++i) {
            threads[i] = new Thread((ProcedureScheduler)sched, waitQueue, waitCount){
                final /* synthetic */ ProcedureScheduler val$sched;
                final /* synthetic */ ConcurrentSkipListSet val$waitQueue;
                final /* synthetic */ AtomicInteger val$waitCount;
                {
                    this.val$sched = procedureScheduler;
                    this.val$waitQueue = concurrentSkipListSet;
                    this.val$waitCount = atomicInteger;
                }

                @Override
                public void run() {
                    while (true) {
                        TestProcedureWithEvent proc;
                        if ((proc = (TestProcedureWithEvent)this.val$sched.poll()) == null) {
                            continue;
                        }
                        proc.getEvent().suspend();
                        this.val$waitQueue.add(proc);
                        proc.getEvent().suspendIfNotReady((Procedure)proc);
                        LOG.debug("WAIT " + proc.getEvent());
                        if (this.val$waitCount.incrementAndGet() >= 500) break;
                    }
                }
            };
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        sched.clear();
    }

    public static class TestProcedureWithEvent
    extends ProcedureTestingUtility.NoopProcedure<Void> {
        private final ProcedureEvent event;

        public TestProcedureWithEvent(long procId) {
            this.setProcId(procId);
            this.event = new ProcedureEvent((Object)("test-event procId=" + procId));
        }

        public ProcedureEvent getEvent() {
            return this.event;
        }
    }
}

