/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.backoff;

import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseServerExceptionPauseManager {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseServerExceptionPauseManager.class);
    private final long pauseNs;
    private final long pauseNsForServerOverloaded;
    private final long timeoutNs;

    public HBaseServerExceptionPauseManager(long pauseNs, long pauseNsForServerOverloaded, long timeoutNs) {
        this.pauseNs = pauseNs;
        this.pauseNsForServerOverloaded = pauseNsForServerOverloaded;
        this.timeoutNs = timeoutNs;
    }

    public OptionalLong getPauseNsFromException(Throwable error, int tries, long startNs) {
        long expectedSleepNs;
        long remainingTimeNs = this.remainingTimeNs(startNs) - ConnectionUtils.SLEEP_DELTA_NS;
        if (error instanceof RpcThrottlingException) {
            RpcThrottlingException rpcThrottlingException = (RpcThrottlingException)error;
            expectedSleepNs = TimeUnit.MILLISECONDS.toNanos(rpcThrottlingException.getWaitInterval());
            if (expectedSleepNs > remainingTimeNs && remainingTimeNs > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RpcThrottlingException suggested pause of {}ns which would exceed the timeout. We should throw instead.", (Object)expectedSleepNs, (Object)rpcThrottlingException);
                }
                return OptionalLong.empty();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sleeping for {}ns after catching RpcThrottlingException", (Object)expectedSleepNs, (Object)rpcThrottlingException);
            }
        } else {
            expectedSleepNs = HBaseServerException.isServerOverloaded(error) ? this.pauseNsForServerOverloaded : this.pauseNs;
            expectedSleepNs = ConnectionUtils.getPauseTime(expectedSleepNs, tries - 1);
        }
        if (this.timeoutNs > 0L) {
            if (remainingTimeNs <= 0L) {
                return OptionalLong.empty();
            }
            expectedSleepNs = Math.min(remainingTimeNs, expectedSleepNs);
        }
        return OptionalLong.of(expectedSleepNs);
    }

    public long remainingTimeNs(long startNs) {
        return this.timeoutNs - (System.nanoTime() - startNs);
    }
}

