/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinationManager;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureMemberRpcs;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKProcedureCoordinationManager
implements ProcedureCoordinationManager {
    ZKWatcher watcher;

    public ZKProcedureCoordinationManager(Server server) {
        this.watcher = server.getZooKeeper();
    }

    @Override
    public ProcedureCoordinatorRpcs getProcedureCoordinatorRpcs(String procType, String coordNode) {
        return new ZKProcedureCoordinator(this.watcher, procType, coordNode);
    }

    @Override
    public ProcedureMemberRpcs getProcedureMemberRpcs(String procType) throws KeeperException {
        return new ZKProcedureMemberRpcs(this.watcher, procType);
    }
}

