/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.el.ExpressionFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.JspSourceImports;
import org.apache.jasper.runtime.PageContextImpl;
import org.apache.tomcat.InstanceManager;

public final class hbck_jsp
extends HttpJspBase
implements JspSourceDependent,
JspSourceImports {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Map<String, Long> _jspx_dependants;
    private static final Set<String> _jspx_imports_packages;
    private static final Set<String> _jspx_imports_classes;
    private volatile ExpressionFactory _el_expressionfactory;
    private volatile InstanceManager _jsp_instancemanager;

    private static String formatServerName(HMaster master, ServerManager serverManager, ServerName serverName) {
        if (serverName == null) {
            return "null";
        }
        String sn = serverName.toString();
        if (serverManager.isServerOnline(serverName)) {
            int infoPort = master.getRegionServerInfoPort(serverName);
            if (infoPort > 0) {
                return "<a href=//" + serverName.getHostname() + ":" + infoPort + "/rs-status>" + sn + "</a>";
            }
            return "<b>" + sn + "</b>";
        }
        if (serverManager.isServerDead(serverName)) {
            return "<i>" + sn + "</i>";
        }
        return sn;
    }

    public Map<String, Long> getDependants() {
        return _jspx_dependants;
    }

    public Set<String> getPackageImports() {
        return _jspx_imports_packages;
    }

    public Set<String> getClassImports() {
        return _jspx_imports_classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionFactory _jsp_getExpressionFactory() {
        if (this._el_expressionfactory == null) {
            hbck_jsp hbck_jsp2 = this;
            synchronized (hbck_jsp2) {
                if (this._el_expressionfactory == null) {
                    this._el_expressionfactory = _jspxFactory.getJspApplicationContext(this.getServletConfig().getServletContext()).getExpressionFactory();
                }
            }
        }
        return this._el_expressionfactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceManager _jsp_getInstanceManager() {
        if (this._jsp_instancemanager == null) {
            hbck_jsp hbck_jsp2 = this;
            synchronized (hbck_jsp2) {
                if (this._jsp_instancemanager == null) {
                    this._jsp_instancemanager = InstanceManagerFactory.getInstanceManager((ServletConfig)this.getServletConfig());
                }
            }
        }
        return this._jsp_instancemanager;
    }

    public void _jspInit() {
    }

    public void _jspDestroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block50: {
            if (!DispatcherType.ERROR.equals((Object)request.getDispatcherType())) {
                String _jspx_method = request.getMethod();
                if ("OPTIONS".equals(_jspx_method)) {
                    response.setHeader("Allow", "GET, HEAD, POST, OPTIONS");
                    return;
                }
                if (!("GET".equals(_jspx_method) || "POST".equals(_jspx_method) || "HEAD".equals(_jspx_method))) {
                    response.setHeader("Allow", "GET, HEAD, POST, OPTIONS");
                    response.sendError(405, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
                    return;
                }
            }
            HttpSession session = null;
            JspWriter out = null;
            hbck_jsp page = this;
            JspWriter _jspx_out = null;
            PageContext _jspx_page_context = null;
            try {
                HbckChore hbckChore;
                PageContext pageContext;
                response.setContentType("text/html;charset=UTF-8");
                _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                ServletContext application = pageContext.getServletContext();
                ServletConfig config = pageContext.getServletConfig();
                session = pageContext.getSession();
                _jspx_out = out = pageContext.getOut();
                out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
                String cacheParameterValue = request.getParameter("cache");
                HMaster master = (HMaster)this.getServletContext().getAttribute("master");
                pageContext.setAttribute("pageTitle", (Object)("HBase Master HBCK Report: " + master.getServerName()));
                if (!Boolean.parseBoolean(cacheParameterValue)) {
                    try {
                        master.getMasterRpcServices().runHbckChore(null, null);
                    }
                    catch (ServiceException se) {
                        out.write("Failed generating a new hbck_chore report; using cache; try again or run hbck_chore_run in the shell: " + se.getMessage() + "\n");
                    }
                    try {
                        master.getMasterRpcServices().runCatalogScan(null, null);
                    }
                    catch (ServiceException se) {
                        out.write("Failed generating a new catalogjanitor report; using cache; try again or run catalogjanitor_run in the shell: " + se.getMessage() + "\n");
                    }
                }
                HbckReport hbckReport = (hbckChore = master.getHbckChore()) == null ? null : hbckChore.getLastReport();
                String hbckReportStartTime = Optional.ofNullable(hbckReport).map(HbckReport::getCheckingStartTimestamp).map(start -> ZonedDateTime.ofInstant(start, ZoneId.systemDefault())).map(zdt -> zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).orElse(null);
                String hbckReportEndTime = Optional.ofNullable(hbckReport).map(HbckReport::getCheckingEndTimestamp).map(start -> ZonedDateTime.ofInstant(start, ZoneId.systemDefault())).map(zdt -> zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).orElse(null);
                CatalogJanitor cj = master.getCatalogJanitor();
                CatalogJanitorReport cjReport = cj == null ? null : cj.getLastReport();
                ServerManager serverManager = master.getServerManager();
                out.write(10);
                String _jspx_temp0_url = "header.jsp";
                String _jspx_temp0_requestEncoding = request.getCharacterEncoding();
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)(_jspx_temp0_url + (_jspx_temp0_url.indexOf(63) > 0 ? (char)'&' : '?') + JspRuntimeLibrary.URLEncode((String)"pageTitle", (String)_jspx_temp0_requestEncoding) + "=" + JspRuntimeLibrary.URLEncode((String)((String)PageContextImpl.proprietaryEvaluate((String)"${pageTitle}", String.class, (PageContext)_jspx_page_context, null)), (String)_jspx_temp0_requestEncoding)), (JspWriter)out, (boolean)false);
                out.write("\n\n<div class=\"container-fluid content\">\n  ");
                if (!master.isInitialized()) {
                    out.write("\n  <div class=\"row top_header\">\n    <div class=\"page-header\">\n      <h1>Master is not initialized</h1>\n    </div>\n  </div>\n  ");
                    JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                    out.write(10);
                    out.write(32);
                    out.write(32);
                } else {
                    out.write("\n\n  <div class=\"row top_header\">\n    <div class=\"page-header\">\n      <p><span>This page displays two reports: the <em>HBCK Chore Report</em> and\n        the <em>CatalogJanitor Consistency Issues</em> report. Only report titles\n        show if there are no problems to list. Note some conditions are\n        <strong>transitory</strong> as regions migrate. Reports are generated\n        when you invoke this page unless you add <em>?cache=true</em> to the URL. Then\n        we display the reports cached from the last time the reports were run.\n        Reports are run by Chores that are hosted by the Master on a cadence.\n        You can also run them on demand from the hbase shell: invoke <em>catalogjanitor_run</em>\n        and/or <em>hbck_chore_run</em>. \n        ServerNames will be links if server is live, italic if dead, and plain if unknown.</span></p>\n    </div>\n  </div>\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h1>HBCK Chore Report</h1>\n      <p>\n        ");
                    if (hbckChore == null) {
                        out.write("\n          <span>HBCK chore has not yet initialized. Try again later.</span>\n        ");
                    } else if (hbckChore.isDisabled()) {
                        out.write("\n          <span>HBCK chore is currently disabled. Set hbase.master.hbck.chore.interval > 0 in the config & do a rolling-restart to enable it.</span>\n        ");
                    } else if (hbckReport == null) {
                        out.write("\n          <span>No Report created.</span>\n        ");
                    } else if (hbckReportStartTime != null && hbckReportEndTime == null) {
                        out.write("\n          <span>Checking started at ");
                        out.print(hbckReportStartTime);
                        out.write(". Please wait for checking to generate a new sub-report.</span>\n        ");
                    } else {
                        out.write("\n          <span>Checking started at ");
                        out.print(hbckReportStartTime);
                        out.write(" and generated catalogJanitorReport at ");
                        out.print(hbckReportEndTime);
                        out.write(".</span>\n        ");
                    }
                    out.write("\n      </p>\n    </div>\n  </div>\n\n  ");
                    if (hbckReport != null && hbckReport.getInconsistentRegions().size() > 0) {
                        out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Inconsistent Regions</h2>\n    </div>\n  </div>\n      <p>\n        <span>\n        There are three cases: 1. Master thought this region opened, but no regionserver reported it (Fix: use assign\n        command); 2. Master thought this region opened on Server1, but regionserver reported Server2 (Fix:\n        need to check the server still exists. If not, schedule <em>ServerCrashProcedure</em> for it. If exists,\n        restart Server2 and Server1):\n        3. More than one regionserver reports opened this region (Fix: restart the RegionServers).\n        Note: the reported online regionservers may be not be up-to-date when there are regions in transition.\n        </span>\n      </p>\n\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Region Name</th>\n      <th>Location in META</th>\n      <th>Reported Online RegionServers</th>\n    </tr>\n    ");
                        for (Map.Entry<String, Pair<ServerName, List<ServerName>>> entry : hbckReport.getInconsistentRegions().entrySet()) {
                            out.write("\n    <tr>\n      <td>");
                            out.print(entry.getKey());
                            out.write("</td>\n      <td>");
                            out.print(hbck_jsp.formatServerName(master, serverManager, (ServerName)entry.getValue().getFirst()));
                            out.write("</td>\n      <td>");
                            out.print(((List)entry.getValue().getSecond()).stream().map(s -> hbck_jsp.formatServerName(master, serverManager, s)).collect(Collectors.joining(", ")));
                            out.write("</td>\n    </tr>\n    ");
                        }
                        out.write("\n    <p>");
                        out.print(hbckReport.getInconsistentRegions().size());
                        out.write(" region(s) in set.</p>\n  </table>\n  ");
                    }
                    out.write("\n\n  ");
                    if (hbckReport != null && hbckReport.getOrphanRegionsOnRS().size() > 0) {
                        out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Orphan Regions on RegionServer</h2>\n    </div>\n  </div>\n\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Region Name</th>\n      <th>Reported Online RegionServer</th>\n    </tr>\n    ");
                        for (Map.Entry<String, Pair<ServerName, List<ServerName>>> entry : hbckReport.getOrphanRegionsOnRS().entrySet()) {
                            out.write("\n    <tr>\n      <td>");
                            out.print(entry.getKey());
                            out.write("</td>\n      <td>");
                            out.print(hbck_jsp.formatServerName(master, serverManager, (ServerName)entry.getValue()));
                            out.write("</td>\n    </tr>\n    ");
                        }
                        out.write("\n    <p>");
                        out.print(hbckReport.getOrphanRegionsOnRS().size());
                        out.write(" region(s) in set.</p>\n  </table>\n  ");
                    }
                    out.write("\n\n  ");
                    if (hbckReport != null && hbckReport.getOrphanRegionsOnFS().size() > 0) {
                        out.write("\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Orphan Regions on FileSystem</h2>\n    </div>\n  </div>\n      <p>\n        <span>\n          The below are Regions we've lost account of. To be safe, run bulk load of any data found under these Region orphan directories to have the\n          cluster re-adopt data.\n          First make sure <em>hbase:meta</em> is in a healthy state, that there are no holes, overlaps or inconsistencies (else bulk load may fail);\n          run <em>hbck2 fixMeta</em>. Once this is done, per Region below, run a bulk\n          load -- <em>$ hbase completebulkload REGION_DIR_PATH TABLE_NAME</em> -- and then delete the desiccated directory content (HFiles are removed upon\n          successful load; all that is left are empty directories and occasionally a seqid marking file).\n        </span>\n      </p>\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Region Encoded Name</th>\n      <th>FileSystem Path</th>\n    </tr>\n    ");
                        for (Map.Entry<String, Pair<ServerName, List<ServerName>>> entry : hbckReport.getOrphanRegionsOnFS().entrySet()) {
                            out.write("\n    <tr>\n      <td>");
                            out.print(entry.getKey());
                            out.write("</td>\n      <td>");
                            out.print(entry.getValue());
                            out.write("</td>\n    </tr>\n    ");
                        }
                        out.write("\n\n    <p>");
                        out.print(hbckReport.getOrphanRegionsOnFS().size());
                        out.write(" region(s) in set.</p>\n  </table>\n  ");
                    }
                    out.write("\n\n  ");
                    Instant nowInstant = Instant.ofEpochMilli(EnvironmentEdgeManager.currentTime());
                    ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(nowInstant, ZoneId.systemDefault());
                    String iso8601Now = zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    String cjReportTime = Optional.ofNullable(cjReport).map(CatalogJanitorReport::getCreateTime).map(Instant::ofEpochMilli).map(start -> ZonedDateTime.ofInstant(start, ZoneId.systemDefault())).map(zdt -> zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).orElse(null);
                    out.write("\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>CatalogJanitor <em>hbase:meta</em> Consistency Issues</h1>\n      <p>\n        ");
                    if (cjReport != null) {
                        out.write("\n          <span>Report created: ");
                        out.print(cjReportTime);
                        out.write(" (now=");
                        out.print(iso8601Now);
                        out.write(").</span></p>\n        ");
                    } else {
                        out.write("\n          <span>No catalogJanitorReport created.</span>\n        ");
                    }
                    out.write("\n    </div>\n  </div>\n  ");
                    if (cjReport != null && !cjReport.isEmpty()) {
                        out.write("\n      ");
                        if (!cjReport.getHoles().isEmpty()) {
                            out.write("\n          <div class=\"row inner_header\">\n            <div class=\"page-header\">\n              <h2>Holes</h2>\n            </div>\n          </div>\n          <table class=\"table table-striped\">\n            <tr>\n              <th>RegionInfo</th>\n              <th>RegionInfo</th>\n            </tr>\n            ");
                            for (Pair<RegionInfo, RegionInfo> pair : cjReport.getHoles()) {
                                out.write("\n            <tr>\n              <td><span title=\"");
                                out.print(pair.getFirst());
                                out.write(34);
                                out.write(62);
                                out.print(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                                out.write("</span></td>\n              <td><span title=\"");
                                out.print(pair.getSecond());
                                out.write(34);
                                out.write(62);
                                out.print(((RegionInfo)pair.getSecond()).getRegionNameAsString());
                                out.write("</span></td>\n            </tr>\n            ");
                            }
                            out.write("\n\n            <p>");
                            out.print(cjReport.getHoles().size());
                            out.write(" hole(s).</p>\n          </table>\n      ");
                        }
                        out.write("\n      ");
                        if (!cjReport.getOverlaps().isEmpty()) {
                            out.write("\n            <div class=\"row inner_header\">\n              <div class=\"page-header\">\n                <h2>Overlaps</h2>\n                <p>\n                  <span>\n                    Regions highlighted in <font color=\"blue\">blue</font> are recently merged regions, HBase is still doing cleanup for them. Overlaps involving these regions cannot be fixed by <em>hbck2 fixMeta</em> at this moment.\n                    Please wait some time, run <i>catalogjanitor_run</i> in hbase shell, refresh \u2018HBCK Report\u2019 page, make sure these regions are not highlighted to start the fix.\n                  </span>\n                </p>\n              </div>\n            </div>\n            <table class=\"table table-striped\">\n              <tr>\n                <th>RegionInfo</th>\n                <th>Other RegionInfo</th>\n              </tr>\n              ");
                            for (Pair<RegionInfo, RegionInfo> pair : cjReport.getOverlaps()) {
                                out.write("\n              <tr>\n                ");
                                if (cjReport.getMergedRegions().containsKey(pair.getFirst())) {
                                    out.write("\n                  <td><span style=\"color:blue;\" title=\"");
                                    out.print(pair.getFirst());
                                    out.write(34);
                                    out.write(62);
                                    out.print(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                                    out.write("</span></td>\n                ");
                                } else {
                                    out.write("\n                  <td><span title=\"");
                                    out.print(pair.getFirst());
                                    out.write(34);
                                    out.write(62);
                                    out.print(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                                    out.write("</span></td>\n                ");
                                }
                                out.write("\n                ");
                                if (cjReport.getMergedRegions().containsKey(pair.getSecond())) {
                                    out.write("\n                  <td><span style=\"color:blue;\" title=\"");
                                    out.print(pair.getSecond());
                                    out.write(34);
                                    out.write(62);
                                    out.print(((RegionInfo)pair.getSecond()).getRegionNameAsString());
                                    out.write("</span></td>\n                ");
                                } else {
                                    out.write("\n                  <td><span title=\"");
                                    out.print(pair.getSecond());
                                    out.write(34);
                                    out.write(62);
                                    out.print(((RegionInfo)pair.getSecond()).getRegionNameAsString());
                                    out.write("</span></td>\n                ");
                                }
                                out.write("\n              </tr>\n              ");
                            }
                            out.write("\n\n              <p>");
                            out.print(cjReport.getOverlaps().size());
                            out.write(" overlap(s).</p>\n            </table>\n      ");
                        }
                        out.write("\n      ");
                        if (!cjReport.getUnknownServers().isEmpty()) {
                            out.write("\n            <div class=\"row inner_header\">\n              <div class=\"page-header\">\n                <h2>Unknown Servers</h2>\n              </div>\n            </div>\n            <p>\n              <span>The below are servers mentioned in the hbase:meta table that are no longer 'live' or known 'dead'.\n                The server likely belongs to an older cluster epoch since replaced by a new instance because of a restart/crash.\n                To clear 'Unknown Servers', run 'hbck2 scheduleRecoveries UNKNOWN_SERVERNAME'. This will schedule a ServerCrashProcedure.\n                It will clear out 'Unknown Server' references and schedule reassigns of any Regions that were associated with this host.\n                But first!, be sure the referenced Region is not currently stuck looping trying to OPEN. Does it show as a Region-In-Transition on the\n                Master home page? Is it mentioned in the 'Procedures and Locks' Procedures list? If so, perhaps it stuck in a loop\n                trying to OPEN but unable to because of a missing reference or file.\n");
                            out.write("                Read the Master log looking for the most recent\n                mentions of the associated Region name. Try and address any such complaint first. If successful, a side-effect\n                should be the clean up of the 'Unknown Servers' list. It may take a while. OPENs are retried forever but the interval\n                between retries grows. The 'Unknown Server' may be cleared because it is just the last RegionServer the Region was\n                successfully opened on; on the next open, the 'Unknown Server' will be purged.\n              </span>\n            </p>\n            <table class=\"table table-striped\">\n              <tr>\n                <th>RegionInfo</th>\n                <th>ServerName</th>\n              </tr>\n              ");
                            for (Pair<RegionInfo, RegionInfo> pair : cjReport.getUnknownServers()) {
                                out.write("\n              <tr>\n                <td><span title=\"");
                                out.print(pair.getFirst());
                                out.write(34);
                                out.write(62);
                                out.print(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                                out.write("</span></td>\n                <td>");
                                out.print(pair.getSecond());
                                out.write("</td>\n              </tr>\n              ");
                            }
                            out.write("\n\n              <p>");
                            out.print(cjReport.getUnknownServers().size());
                            out.write(" unknown servers(s).</p>\n            </table>\n      ");
                        }
                        out.write("\n      ");
                        if (!cjReport.getEmptyRegionInfo().isEmpty()) {
                            out.write("\n            <div class=\"row inner_header\">\n              <div class=\"page-header\">\n                <h2>Empty <em>info:regioninfo</em></h2>\n              </div>\n            </div>\n            <table class=\"table table-striped\">\n              <tr>\n                <th>Row</th>\n              </tr>\n              ");
                            for (byte[] byArray : cjReport.getEmptyRegionInfo()) {
                                out.write("\n              <tr>\n                <td>");
                                out.print(Bytes.toStringBinary((byte[])byArray));
                                out.write("</td>\n              </tr>\n              ");
                            }
                            out.write("\n\n              <p>");
                            out.print(cjReport.getEmptyRegionInfo().size());
                            out.write(" emptyRegionInfo(s).</p>\n            </table>\n      ");
                        }
                        out.write(10);
                        out.write(32);
                        out.write(32);
                    }
                    out.write("\n\n  ");
                }
                out.write("\n</div>\n\n");
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"footer.jsp", (JspWriter)out, (boolean)false);
                out.write(10);
                out.write(10);
                out.write(10);
            }
            catch (Throwable t) {
                try {
                    if (t instanceof SkipPageException) break block50;
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        try {
                            if (response.isCommitted()) {
                                out.flush();
                            } else {
                                out.clearBuffer();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                    throw new ServletException(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }

    static {
        _jspx_imports_packages = new LinkedHashSet<String>(4);
        _jspx_imports_packages.add("javax.servlet");
        _jspx_imports_packages.add("javax.servlet.http");
        _jspx_imports_packages.add("javax.servlet.jsp");
        _jspx_imports_classes = new LinkedHashSet<String>(27);
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.janitor.CatalogJanitor");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport");
        _jspx_imports_classes.add("java.time.ZonedDateTime");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.hbck.HbckReport");
        _jspx_imports_classes.add("java.time.Instant");
        _jspx_imports_classes.add("java.util.stream.Collectors");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.ServerManager");
        _jspx_imports_classes.add("java.time.ZoneId");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.hbck.HbckChore");
        _jspx_imports_classes.add("java.util.List");
        _jspx_imports_classes.add("java.util.Map");
        _jspx_imports_classes.add("java.time.format.DateTimeFormatter");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.util.EnvironmentEdgeManager");
        _jspx_imports_classes.add("org.apache.hadoop.fs.Path");
        _jspx_imports_classes.add("java.util.Optional");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionInfo");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.master.HMaster");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.ServerName");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.util.Bytes");
        _jspx_imports_classes.add("org.apache.hadoop.hbase.util.Pair");
    }
}

