/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.InstanceVariableCompiler;
import org.jruby.ir.targets.JVM;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class NormalInstanceVariableCompiler
implements InstanceVariableCompiler {
    private final IRBytecodeAdapter compiler;

    public NormalInstanceVariableCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void putField(String name2) {
        this.compiler.adapter.dup2();
        this.compiler.adapter.pop();
        this.cacheVariableAccessor(name2, true);
        this.compiler.invokeIRHelper("setVariableWithAccessor", CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class, VariableAccessor.class));
    }

    @Override
    public void getField(String name2) {
        this.compiler.adapter.dup();
        this.cacheVariableAccessor(name2, false);
        this.compiler.loadContext();
        this.compiler.adapter.ldc(name2);
        this.compiler.invokeIRHelper("getVariableWithAccessor", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, VariableAccessor.class, ThreadContext.class, String.class));
    }

    private void cacheVariableAccessor(String name2, boolean write2) {
        String incomingSig = CodegenUtils.sig(VariableAccessor.class, CodegenUtils.params(JVM.OBJECT));
        String methodName = (write2 ? "ivarSet" : "ivarGet") + this.compiler.getClassData().cacheFieldCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.compiler.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        this.compiler.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(VariableAccessor.class), null, null).visitEnd();
        String className = this.compiler.getClassData().clsName;
        adapter2.getstatic(className, methodName, CodegenUtils.ci(VariableAccessor.class));
        adapter2.dup();
        Label get2 = new Label();
        adapter2.ifnull(get2);
        adapter2.dup();
        adapter2.aload(0);
        adapter2.invokevirtual(CodegenUtils.p(VariableAccessor.class), "verify", CodegenUtils.sig(Boolean.TYPE, Object.class));
        adapter2.iffalse(get2);
        adapter2.areturn();
        adapter2.label(get2);
        adapter2.pop();
        adapter2.aload(0);
        adapter2.ldc(name2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), write2 ? "getVariableAccessorForWrite" : "getVariableAccessorForRead", CodegenUtils.sig(VariableAccessor.class, IRubyObject.class, String.class));
        adapter2.dup();
        adapter2.putstatic(className, methodName, CodegenUtils.ci(VariableAccessor.class));
        adapter2.areturn();
        adapter2.end();
        this.compiler.adapter.invokestatic(className, methodName, incomingSig);
    }
}

