/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRestoreConstants;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.BulkLoad;
import org.apache.hadoop.hbase.backup.impl.ExclusiveOperationException;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.BackupProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class BackupSystemTable
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BackupSystemTable.class);
    private TableName tableName;
    private TableName bulkLoadTableName;
    static final byte[] SESSIONS_FAMILY = Bytes.toBytes((String)"session");
    static final byte[] META_FAMILY = Bytes.toBytes((String)"meta");
    static final byte[] BULK_LOAD_FAMILY = Bytes.toBytes((String)"bulk");
    private final Connection connection;
    private static final String BACKUP_INFO_PREFIX = "session:";
    private static final String START_CODE_ROW = "startcode:";
    private static final byte[] ACTIVE_SESSION_ROW = Bytes.toBytes((String)"activesession:");
    private static final byte[] ACTIVE_SESSION_COL = Bytes.toBytes((String)"c");
    private static final byte[] ACTIVE_SESSION_YES = Bytes.toBytes((String)"yes");
    private static final byte[] ACTIVE_SESSION_NO = Bytes.toBytes((String)"no");
    private static final String INCR_BACKUP_SET = "incrbackupset:";
    private static final String TABLE_RS_LOG_MAP_PREFIX = "trslm:";
    private static final String RS_LOG_TS_PREFIX = "rslogts:";
    private static final String BULK_LOAD_PREFIX = "bulk:";
    private static final byte[] BULK_LOAD_PREFIX_BYTES = Bytes.toBytes((String)"bulk:");
    private static final byte[] DELETE_OP_ROW = Bytes.toBytes((String)"delete_op_row");
    private static final byte[] MERGE_OP_ROW = Bytes.toBytes((String)"merge_op_row");
    static final byte[] TBL_COL = Bytes.toBytes((String)"tbl");
    static final byte[] FAM_COL = Bytes.toBytes((String)"fam");
    static final byte[] PATH_COL = Bytes.toBytes((String)"path");
    private static final String SET_KEY_PREFIX = "backupset:";
    private static final String BLK_LD_DELIM = ":";
    private static final byte[] EMPTY_VALUE = new byte[0];
    private static final String NULL = "\u0000";

    public BackupSystemTable(Connection conn) throws IOException {
        this.connection = conn;
        Configuration conf = this.connection.getConfiguration();
        this.tableName = BackupSystemTable.getTableName(conf);
        this.bulkLoadTableName = BackupSystemTable.getTableNameForBulkLoadedData(conf);
        this.checkSystemTable();
    }

    private void checkSystemTable() throws IOException {
        try (Admin admin = this.connection.getAdmin();){
            this.verifyNamespaceExists(admin);
            Configuration conf = this.connection.getConfiguration();
            if (!admin.tableExists(this.tableName)) {
                TableDescriptor backupHTD = BackupSystemTable.getSystemTableDescriptor(conf);
                this.createSystemTable(admin, backupHTD);
            }
            BackupSystemTable.ensureTableEnabled(admin, this.tableName);
            if (!admin.tableExists(this.bulkLoadTableName)) {
                TableDescriptor blHTD = BackupSystemTable.getSystemTableForBulkLoadedDataDescriptor(conf);
                this.createSystemTable(admin, blHTD);
            }
            BackupSystemTable.ensureTableEnabled(admin, this.bulkLoadTableName);
            this.waitForSystemTable(admin, this.tableName);
            this.waitForSystemTable(admin, this.bulkLoadTableName);
        }
    }

    private void createSystemTable(Admin admin, TableDescriptor descriptor) throws IOException {
        try {
            admin.createTable(descriptor);
        }
        catch (TableExistsException e) {
            LOG.debug("Table {} already exists, ignoring", (Object)descriptor.getTableName(), (Object)e);
        }
    }

    private void verifyNamespaceExists(Admin admin) throws IOException {
        String namespaceName = this.tableName.getNamespaceAsString();
        NamespaceDescriptor ns = NamespaceDescriptor.create((String)namespaceName).build();
        NamespaceDescriptor[] list = admin.listNamespaceDescriptors();
        boolean exists = false;
        for (NamespaceDescriptor nsd : list) {
            if (!nsd.getName().equals(ns.getName())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            try {
                admin.createNamespace(ns);
            }
            catch (NamespaceExistException e) {
                LOG.debug("Namespace {} already exists, ignoring", (Object)ns.getName(), (Object)e);
            }
        }
    }

    private void waitForSystemTable(Admin admin, TableName tableName) throws IOException {
        if (admin.tableExists(tableName) && admin.isTableAvailable(tableName)) {
            return;
        }
        long TIMEOUT = 60000L;
        long startTime = EnvironmentEdgeManager.currentTime();
        LOG.debug("Backup table {} is not present and available, waiting for it to become so", (Object)tableName);
        while (!admin.tableExists(tableName) || !admin.isTableAvailable(tableName)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
            if (EnvironmentEdgeManager.currentTime() - startTime <= TIMEOUT) continue;
            throw new IOException("Failed to create backup system table " + tableName + " after " + TIMEOUT + "ms");
        }
        LOG.debug("Backup table {} exists and available", (Object)tableName);
    }

    @Override
    public void close() {
    }

    public void updateBackupInfo(BackupInfo info) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("update backup status in backup system table for: " + info.getBackupId() + " set status=" + (Object)((Object)info.getState()));
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Put put = this.createPutForBackupInfo(info);
            table.put(put);
        }
    }

    /*
     * Exception decompiling
     */
    Map<byte[], String> readBulkLoadedFiles(String backupId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteBackupInfo(String backupId) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete backup status in backup system table for " + backupId);
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Delete del = this.createDeleteForBackupInfo(backupId);
            table.delete(del);
        }
    }

    public void registerBulkLoad(TableName tableName, byte[] region, Map<byte[], List<Path>> cfToHfilePath) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing bulk load descriptor to backup {} with {} entries", (Object)tableName, (Object)cfToHfilePath.size());
        }
        try (BufferedMutator bufferedMutator = this.connection.getBufferedMutator(this.bulkLoadTableName);){
            List<Put> puts = BackupSystemTable.createPutForBulkLoad(tableName, region, cfToHfilePath);
            bufferedMutator.mutate(puts);
            LOG.debug("Written {} rows for bulk load of table {}", (Object)puts.size(), (Object)tableName);
        }
    }

    public void deleteBulkLoadedRows(List<byte[]> rows) throws IOException {
        try (BufferedMutator bufferedMutator = this.connection.getBufferedMutator(this.bulkLoadTableName);){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (byte[] row : rows) {
                Delete del = new Delete(row);
                deletes.add(del);
                LOG.debug("Deleting bulk load entry with key: {}", (Object)Bytes.toString((byte[])row));
            }
            bufferedMutator.mutate(deletes);
            LOG.debug("Deleted {} bulk load entries.", (Object)rows.size());
        }
    }

    public List<BulkLoad> readBulkloadRows() throws IOException {
        Scan scan = BackupSystemTable.createScanForOrigBulkLoadedFiles(null);
        return this.processBulkLoadRowScan(scan);
    }

    public List<BulkLoad> readBulkloadRows(Collection<TableName> tableList) throws IOException {
        ArrayList<BulkLoad> result = new ArrayList<BulkLoad>();
        for (TableName table : tableList) {
            Scan scan = BackupSystemTable.createScanForOrigBulkLoadedFiles(table);
            result.addAll(this.processBulkLoadRowScan(scan));
        }
        return result;
    }

    private List<BulkLoad> processBulkLoadRowScan(Scan scan) throws IOException {
        ArrayList<BulkLoad> result = new ArrayList<BulkLoad>();
        try (Table bulkLoadTable = this.connection.getTable(this.bulkLoadTableName);
             ResultScanner scanner = bulkLoadTable.getScanner(scan);){
            Result res;
            while ((res = scanner.next()) != null) {
                res.advance();
                TableName table = null;
                String fam = null;
                String path = null;
                String region = null;
                byte[] row = null;
                for (Cell cell : res.listCells()) {
                    row = CellUtil.cloneRow((Cell)cell);
                    String rowStr = Bytes.toString((byte[])row);
                    region = BackupSystemTable.getRegionNameFromOrigBulkLoadRow(rowStr);
                    if (CellUtil.compareQualifiers((Cell)cell, (byte[])TBL_COL, (int)0, (int)TBL_COL.length) == 0) {
                        table = TableName.valueOf((byte[])CellUtil.cloneValue((Cell)cell));
                        continue;
                    }
                    if (CellUtil.compareQualifiers((Cell)cell, (byte[])FAM_COL, (int)0, (int)FAM_COL.length) == 0) {
                        fam = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
                        continue;
                    }
                    if (CellUtil.compareQualifiers((Cell)cell, (byte[])PATH_COL, (int)0, (int)PATH_COL.length) != 0) continue;
                    path = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
                }
                result.add(new BulkLoad(table, region, fam, path, row));
                LOG.debug("Found bulk load entry for table {}, family {}: {}", new Object[]{table, fam, path});
            }
        }
        return result;
    }

    public BackupInfo readBackupInfo(String backupId) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read backup status from backup system table for: " + backupId);
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Get get = this.createGetForBackupInfo(backupId);
            Result res = table.get(get);
            if (res.isEmpty()) {
                BackupInfo backupInfo = null;
                return backupInfo;
            }
            BackupInfo backupInfo = this.resultToBackupInfo(res);
            return backupInfo;
        }
    }

    public String readBackupStartCode(String backupRoot) throws IOException {
        LOG.trace("read backup start code from backup system table");
        try (Table table = this.connection.getTable(this.tableName);){
            Get get = this.createGetForStartCode(backupRoot);
            Result res = table.get(get);
            if (res.isEmpty()) {
                String string = null;
                return string;
            }
            Cell cell = (Cell)res.listCells().get(0);
            byte[] val = CellUtil.cloneValue((Cell)cell);
            if (val.length == 0) {
                String string = null;
                return string;
            }
            String string = new String(val, StandardCharsets.UTF_8);
            return string;
        }
    }

    public void writeBackupStartCode(Long startCode, String backupRoot) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write backup start code to backup system table " + startCode);
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Put put = this.createPutForStartCode(startCode.toString(), backupRoot);
            table.put(put);
        }
    }

    public void startBackupExclusiveOperation() throws IOException {
        LOG.debug("Start new backup exclusive operation");
        try (Table table = this.connection.getTable(this.tableName);){
            Put put = this.createPutForStartBackupSession();
            if (!table.checkAndMutate(ACTIVE_SESSION_ROW, SESSIONS_FAMILY).qualifier(ACTIVE_SESSION_COL).ifNotExists().thenPut(put) && !table.checkAndMutate(ACTIVE_SESSION_ROW, SESSIONS_FAMILY).qualifier(ACTIVE_SESSION_COL).ifEquals(ACTIVE_SESSION_NO).thenPut(put)) {
                throw new ExclusiveOperationException();
            }
        }
    }

    private Put createPutForStartBackupSession() {
        Put put = new Put(ACTIVE_SESSION_ROW);
        put.addColumn(SESSIONS_FAMILY, ACTIVE_SESSION_COL, ACTIVE_SESSION_YES);
        return put;
    }

    public void finishBackupExclusiveOperation() throws IOException {
        LOG.debug("Finish backup exclusive operation");
        try (Table table = this.connection.getTable(this.tableName);){
            Put put = this.createPutForStopBackupSession();
            if (!table.checkAndMutate(ACTIVE_SESSION_ROW, SESSIONS_FAMILY).qualifier(ACTIVE_SESSION_COL).ifEquals(ACTIVE_SESSION_YES).thenPut(put)) {
                throw new IOException("There is no active backup exclusive operation");
            }
        }
    }

    private Put createPutForStopBackupSession() {
        Put put = new Put(ACTIVE_SESSION_ROW);
        put.addColumn(SESSIONS_FAMILY, ACTIVE_SESSION_COL, ACTIVE_SESSION_NO);
        return put;
    }

    /*
     * Exception decompiling
     */
    public HashMap<String, Long> readRegionServerLastLogRollResult(String backupRoot) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeRegionServerLastLogRollResult(String server, Long ts, String backupRoot) throws IOException {
        LOG.trace("write region server last roll log result to backup system table");
        try (Table table = this.connection.getTable(this.tableName);){
            Put put = this.createPutForRegionServerLastLogRollResult(server, ts, backupRoot);
            table.put(put);
        }
    }

    public ArrayList<BackupInfo> getBackupHistory(boolean onlyCompleted) throws IOException {
        LOG.trace("get backup history from backup system table");
        BackupInfo.BackupState state = onlyCompleted ? BackupInfo.BackupState.COMPLETE : BackupInfo.BackupState.ANY;
        ArrayList<BackupInfo> list = this.getBackupInfos(state);
        return BackupUtils.sortHistoryListDesc(list);
    }

    public List<BackupInfo> getBackupHistory() throws IOException {
        return this.getBackupHistory(false);
    }

    public List<BackupInfo> getHistory(int n) throws IOException {
        List<BackupInfo> history = this.getBackupHistory();
        if (n == -1 || history.size() <= n) {
            return history;
        }
        return Collections.unmodifiableList(history.subList(0, n));
    }

    public List<BackupInfo> getBackupHistory(int n, BackupInfo.Filter ... filters) throws IOException {
        if (filters.length == 0) {
            return this.getHistory(n);
        }
        List<BackupInfo> history = this.getBackupHistory();
        ArrayList<BackupInfo> result = new ArrayList<BackupInfo>();
        for (BackupInfo bi : history) {
            if (n >= 0 && result.size() == n) break;
            boolean passed = true;
            for (int i = 0; i < filters.length; ++i) {
                if (filters[i].apply(bi)) continue;
                passed = false;
                break;
            }
            if (!passed) continue;
            result.add(bi);
        }
        return result;
    }

    public Set<TableName> getTablesIncludedInBackups() throws IOException {
        HashSet<TableName> names = new HashSet<TableName>();
        ArrayList<BackupInfo> infos = this.getBackupHistory(true);
        for (BackupInfo info : infos) {
            if (info.getType() != BackupType.FULL) continue;
            names.addAll(info.getTableNames());
        }
        return names;
    }

    public List<BackupInfo> getBackupHistory(String backupRoot) throws IOException {
        ArrayList<BackupInfo> history = this.getBackupHistory(false);
        Iterator<BackupInfo> iterator = history.iterator();
        while (iterator.hasNext()) {
            BackupInfo info = iterator.next();
            if (backupRoot.equals(info.getBackupRootDir())) continue;
            iterator.remove();
        }
        return history;
    }

    public List<BackupInfo> getBackupHistoryForTable(TableName name) throws IOException {
        List<BackupInfo> history = this.getBackupHistory();
        ArrayList<BackupInfo> tableHistory = new ArrayList<BackupInfo>();
        for (BackupInfo info : history) {
            List<TableName> tables = info.getTableNames();
            if (!tables.contains(name)) continue;
            tableHistory.add(info);
        }
        return tableHistory;
    }

    public Map<TableName, List<BackupInfo>> getBackupHistoryForTableSet(Set<TableName> set, String backupRoot) throws IOException {
        List<BackupInfo> history = this.getBackupHistory(backupRoot);
        HashMap<TableName, List<BackupInfo>> tableHistoryMap = new HashMap<TableName, List<BackupInfo>>();
        for (BackupInfo info : history) {
            List<TableName> tables = info.getTableNames();
            for (TableName tableName : tables) {
                if (!set.contains(tableName)) continue;
                List list = tableHistoryMap.computeIfAbsent(tableName, k -> new ArrayList());
                list.add(info);
            }
        }
        return tableHistoryMap;
    }

    /*
     * Exception decompiling
     */
    public ArrayList<BackupInfo> getBackupInfos(BackupInfo.BackupState state) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeRegionServerLogTimestamp(Set<TableName> tables, Map<String, Long> newTimestamps, String backupRoot) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write RS log time stamps to backup system table for tables [" + StringUtils.join(tables, (String)",") + "]");
        }
        ArrayList<Put> puts = new ArrayList<Put>();
        for (TableName table : tables) {
            byte[] smapData = this.toTableServerTimestampProto(table, newTimestamps).toByteArray();
            Put put = this.createPutForWriteRegionServerLogTimestamp(table, smapData, backupRoot);
            puts.add(put);
        }
        try (BufferedMutator bufferedMutator = this.connection.getBufferedMutator(this.tableName);){
            bufferedMutator.mutate(puts);
        }
    }

    /*
     * Exception decompiling
     */
    public Map<TableName, Map<String, Long>> readLogTimestampMap(String backupRoot) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BackupProtos.TableServerTimestamp toTableServerTimestampProto(TableName table, Map<String, Long> map) {
        BackupProtos.TableServerTimestamp.Builder tstBuilder = BackupProtos.TableServerTimestamp.newBuilder();
        tstBuilder.setTableName(ProtobufUtil.toProtoTableName((TableName)table));
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            BackupProtos.ServerTimestamp.Builder builder = BackupProtos.ServerTimestamp.newBuilder();
            HBaseProtos.ServerName.Builder snBuilder = HBaseProtos.ServerName.newBuilder();
            ServerName sn = ServerName.parseServerName((String)entry.getKey());
            snBuilder.setHostName(sn.getHostname());
            snBuilder.setPort(sn.getPort());
            builder.setServerName(snBuilder.build());
            builder.setTimestamp(entry.getValue().longValue());
            tstBuilder.addServerTimestamp(builder.build());
        }
        return tstBuilder.build();
    }

    private HashMap<String, Long> fromTableServerTimestampProto(BackupProtos.TableServerTimestamp proto) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        List list = proto.getServerTimestampList();
        for (BackupProtos.ServerTimestamp st : list) {
            ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)st.getServerName());
            map.put(sn.getHostname() + BLK_LD_DELIM + sn.getPort(), st.getTimestamp());
        }
        return map;
    }

    public Set<TableName> getIncrementalBackupTableSet(String backupRoot) throws IOException {
        LOG.trace("get incremental backup table set from backup system table");
        TreeSet<TableName> set = new TreeSet<TableName>();
        try (Table table = this.connection.getTable(this.tableName);){
            Get get = this.createGetForIncrBackupTableSet(backupRoot);
            Result res = table.get(get);
            if (res.isEmpty()) {
                TreeSet<TableName> treeSet = set;
                return treeSet;
            }
            List cells = res.listCells();
            for (Cell cell : cells) {
                set.add(TableName.valueOf((byte[])CellUtil.cloneQualifier((Cell)cell)));
            }
            TreeSet<TableName> treeSet = set;
            return treeSet;
        }
    }

    public void addIncrementalBackupTableSet(Set<TableName> tables, String backupRoot) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add incremental backup table set to backup system table. ROOT=" + backupRoot + " tables [" + StringUtils.join(tables, (String)" ") + "]");
        }
        if (LOG.isDebugEnabled()) {
            tables.forEach(table -> LOG.debug(Objects.toString(table)));
        }
        try (Table table2 = this.connection.getTable(this.tableName);){
            Put put = this.createPutForIncrBackupTableSet(tables, backupRoot);
            table2.put(put);
        }
    }

    public void deleteIncrementalBackupTableSet(String backupRoot) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delete incremental backup table set to backup system table. ROOT=" + backupRoot);
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Delete delete = this.createDeleteForIncrBackupTableSet(backupRoot);
            table.delete(delete);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean hasBackupSessions() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<String> listBackupSets() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<TableName> describeBackupSet(String name) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(" Backup set describe: " + name);
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Get get = this.createGetForBackupSet(name);
            Result res = table.get(get);
            if (res.isEmpty()) {
                List<TableName> list = null;
                return list;
            }
            res.advance();
            String[] tables = this.cellValueToBackupSet(res.current());
            List<TableName> list = Arrays.asList(tables).stream().map(item -> TableName.valueOf((String)item)).collect(Collectors.toList());
            return list;
        }
    }

    public void addToBackupSet(String name, String[] newTables) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Backup set add: " + name + " tables [" + StringUtils.join((Object[])newTables, (String)" ") + "]");
        }
        String[] union = null;
        try (Table table = this.connection.getTable(this.tableName);){
            Get get = this.createGetForBackupSet(name);
            Result res = table.get(get);
            if (res.isEmpty()) {
                union = newTables;
            } else {
                res.advance();
                String[] tables = this.cellValueToBackupSet(res.current());
                union = this.merge(tables, newTables);
            }
            Put put = this.createPutForBackupSet(name, union);
            table.put(put);
        }
    }

    public void removeFromBackupSet(String name, String[] toRemove) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(" Backup set remove from : " + name + " tables [" + StringUtils.join((Object[])toRemove, (String)" ") + "]");
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Get get = this.createGetForBackupSet(name);
            Result res = table.get(get);
            if (res.isEmpty()) {
                LOG.warn("Backup set '" + name + "' not found.");
                return;
            }
            res.advance();
            String[] tables = this.cellValueToBackupSet(res.current());
            String[] disjoint = this.disjoin(tables, toRemove);
            if (disjoint.length > 0 && disjoint.length != tables.length) {
                Put put = this.createPutForBackupSet(name, disjoint);
                table.put(put);
            } else if (disjoint.length == tables.length) {
                LOG.warn("Backup set '" + name + "' does not contain tables [" + StringUtils.join((Object[])toRemove, (String)" ") + "]");
            } else {
                LOG.info("Backup set '" + name + "' is empty. Deleting.");
                this.deleteBackupSet(name);
            }
        }
    }

    private String[] merge(String[] existingTables, String[] newTables) {
        HashSet<String> tables = new HashSet<String>(Arrays.asList(existingTables));
        tables.addAll(Arrays.asList(newTables));
        return tables.toArray(new String[0]);
    }

    private String[] disjoin(String[] existingTables, String[] toRemove) {
        HashSet<String> tables = new HashSet<String>(Arrays.asList(existingTables));
        Arrays.asList(toRemove).forEach(table -> tables.remove(table));
        return tables.toArray(new String[0]);
    }

    public void deleteBackupSet(String name) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(" Backup set delete: " + name);
        }
        try (Table table = this.connection.getTable(this.tableName);){
            Delete del = this.createDeleteForBackupSet(name);
            table.delete(del);
        }
    }

    public static TableDescriptor getSystemTableDescriptor(Configuration conf) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)BackupSystemTable.getTableName(conf));
        ColumnFamilyDescriptorBuilder colBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])SESSIONS_FAMILY);
        colBuilder.setMaxVersions(1);
        Configuration config = HBaseConfiguration.create();
        int ttl = config.getInt("hbase.backup.system.ttl", Integer.MAX_VALUE);
        colBuilder.setTimeToLive(ttl);
        ColumnFamilyDescriptor colSessionsDesc = colBuilder.build();
        builder.setColumnFamily(colSessionsDesc);
        colBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])META_FAMILY);
        colBuilder.setTimeToLive(ttl);
        builder.setColumnFamily(colBuilder.build());
        return builder.build();
    }

    public static TableName getTableName(Configuration conf) {
        String name = conf.get("hbase.backup.system.table.name", BackupRestoreConstants.BACKUP_SYSTEM_TABLE_NAME_DEFAULT);
        return TableName.valueOf((String)name);
    }

    public static String getTableNameAsString(Configuration conf) {
        return BackupSystemTable.getTableName(conf).getNameAsString();
    }

    public static String getSnapshotName(Configuration conf) {
        return "snapshot_" + BackupSystemTable.getTableNameAsString(conf).replace(BLK_LD_DELIM, "_");
    }

    public static TableDescriptor getSystemTableForBulkLoadedDataDescriptor(Configuration conf) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)BackupSystemTable.getTableNameForBulkLoadedData(conf));
        ColumnFamilyDescriptorBuilder colBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])SESSIONS_FAMILY);
        colBuilder.setMaxVersions(1);
        Configuration config = HBaseConfiguration.create();
        int ttl = config.getInt("hbase.backup.system.ttl", Integer.MAX_VALUE);
        colBuilder.setTimeToLive(ttl);
        ColumnFamilyDescriptor colSessionsDesc = colBuilder.build();
        builder.setColumnFamily(colSessionsDesc);
        colBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])META_FAMILY);
        colBuilder.setTimeToLive(ttl);
        builder.setColumnFamily(colBuilder.build());
        return builder.build();
    }

    public static TableName getTableNameForBulkLoadedData(Configuration conf) {
        String name = conf.get("hbase.backup.system.table.name", BackupRestoreConstants.BACKUP_SYSTEM_TABLE_NAME_DEFAULT) + "_bulk";
        return TableName.valueOf((String)name);
    }

    private Put createPutForBackupInfo(BackupInfo context) throws IOException {
        Put put = new Put(BackupSystemTable.rowkey(BACKUP_INFO_PREFIX, context.getBackupId()));
        put.addColumn(SESSIONS_FAMILY, Bytes.toBytes((String)"context"), context.toByteArray());
        return put;
    }

    private Get createGetForBackupInfo(String backupId) throws IOException {
        Get get = new Get(BackupSystemTable.rowkey(BACKUP_INFO_PREFIX, backupId));
        get.addFamily(SESSIONS_FAMILY);
        get.readVersions(1);
        return get;
    }

    private Delete createDeleteForBackupInfo(String backupId) {
        Delete del = new Delete(BackupSystemTable.rowkey(BACKUP_INFO_PREFIX, backupId));
        del.addFamily(SESSIONS_FAMILY);
        return del;
    }

    private BackupInfo resultToBackupInfo(Result res) throws IOException {
        res.advance();
        Cell cell = res.current();
        return this.cellToBackupInfo(cell);
    }

    private Get createGetForStartCode(String rootPath) throws IOException {
        Get get = new Get(BackupSystemTable.rowkey(START_CODE_ROW, rootPath));
        get.addFamily(META_FAMILY);
        get.readVersions(1);
        return get;
    }

    private Put createPutForStartCode(String startCode, String rootPath) {
        Put put = new Put(BackupSystemTable.rowkey(START_CODE_ROW, rootPath));
        put.addColumn(META_FAMILY, Bytes.toBytes((String)"startcode"), Bytes.toBytes((String)startCode));
        return put;
    }

    private Get createGetForIncrBackupTableSet(String backupRoot) throws IOException {
        Get get = new Get(BackupSystemTable.rowkey(INCR_BACKUP_SET, backupRoot));
        get.addFamily(META_FAMILY);
        get.readVersions(1);
        return get;
    }

    private Put createPutForIncrBackupTableSet(Set<TableName> tables, String backupRoot) {
        Put put = new Put(BackupSystemTable.rowkey(INCR_BACKUP_SET, backupRoot));
        for (TableName table : tables) {
            put.addColumn(META_FAMILY, Bytes.toBytes((String)table.getNameAsString()), EMPTY_VALUE);
        }
        return put;
    }

    private Delete createDeleteForIncrBackupTableSet(String backupRoot) {
        Delete delete = new Delete(BackupSystemTable.rowkey(INCR_BACKUP_SET, backupRoot));
        delete.addFamily(META_FAMILY);
        return delete;
    }

    private Scan createScanForBackupHistory() {
        Scan scan = new Scan();
        byte[] startRow = Bytes.toBytes((String)BACKUP_INFO_PREFIX);
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.withStartRow(startRow);
        scan.withStopRow(stopRow);
        scan.addFamily(SESSIONS_FAMILY);
        scan.readVersions(1);
        return scan;
    }

    private BackupInfo cellToBackupInfo(Cell current) throws IOException {
        byte[] data = CellUtil.cloneValue((Cell)current);
        return BackupInfo.fromByteArray(data);
    }

    private Put createPutForWriteRegionServerLogTimestamp(TableName table, byte[] smap, String backupRoot) {
        Put put = new Put(BackupSystemTable.rowkey(TABLE_RS_LOG_MAP_PREFIX, backupRoot, NULL, table.getNameAsString()));
        put.addColumn(META_FAMILY, Bytes.toBytes((String)"log-roll-map"), smap);
        return put;
    }

    private Scan createScanForReadLogTimestampMap(String backupRoot) {
        Scan scan = new Scan();
        scan.setStartStopRowForPrefixScan(BackupSystemTable.rowkey(TABLE_RS_LOG_MAP_PREFIX, backupRoot, NULL));
        scan.addFamily(META_FAMILY);
        return scan;
    }

    private String getTableNameForReadLogTimestampMap(byte[] cloneRow) {
        String s = Bytes.toString((byte[])cloneRow);
        int index = s.lastIndexOf(NULL);
        return s.substring(index + 1);
    }

    private Put createPutForRegionServerLastLogRollResult(String server, Long timestamp, String backupRoot) {
        Put put = new Put(BackupSystemTable.rowkey(RS_LOG_TS_PREFIX, backupRoot, NULL, server));
        put.addColumn(META_FAMILY, Bytes.toBytes((String)"rs-log-ts"), Bytes.toBytes((long)timestamp));
        return put;
    }

    private Scan createScanForReadRegionServerLastLogRollResult(String backupRoot) {
        Scan scan = new Scan();
        scan.setStartStopRowForPrefixScan(BackupSystemTable.rowkey(RS_LOG_TS_PREFIX, backupRoot, NULL));
        scan.addFamily(META_FAMILY);
        scan.readVersions(1);
        return scan;
    }

    private String getServerNameForReadRegionServerLastLogRollResult(byte[] row) {
        String s = Bytes.toString((byte[])row);
        int index = s.lastIndexOf(NULL);
        return s.substring(index + 1);
    }

    private static List<Put> createPutForBulkLoad(TableName table, byte[] region, Map<byte[], List<Path>> columnFamilyToHFilePaths) {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (Map.Entry<byte[], List<Path>> entry : columnFamilyToHFilePaths.entrySet()) {
            for (Path path : entry.getValue()) {
                String file = path.toString();
                int lastSlash = file.lastIndexOf("/");
                String filename = file.substring(lastSlash + 1);
                Put put = new Put(BackupSystemTable.rowkey(BULK_LOAD_PREFIX, table.toString(), BLK_LD_DELIM, Bytes.toString((byte[])region), BLK_LD_DELIM, filename));
                put.addColumn(META_FAMILY, TBL_COL, table.getName());
                put.addColumn(META_FAMILY, FAM_COL, entry.getKey());
                put.addColumn(META_FAMILY, PATH_COL, Bytes.toBytes((String)file));
                puts.add(put);
                LOG.debug("Done writing bulk path {} for {} {}", new Object[]{file, table, Bytes.toString((byte[])region)});
            }
        }
        return puts;
    }

    public static void snapshot(Connection conn) throws IOException {
        try (Admin admin = conn.getAdmin();){
            Configuration conf = conn.getConfiguration();
            admin.snapshot(BackupSystemTable.getSnapshotName(conf), BackupSystemTable.getTableName(conf));
        }
    }

    public static void restoreFromSnapshot(Connection conn) throws IOException {
        Configuration conf = conn.getConfiguration();
        LOG.debug("Restoring " + BackupSystemTable.getTableNameAsString(conf) + " from snapshot");
        try (Admin admin = conn.getAdmin();){
            String snapshotName = BackupSystemTable.getSnapshotName(conf);
            if (BackupSystemTable.snapshotExists(admin, snapshotName)) {
                admin.disableTable(BackupSystemTable.getTableName(conf));
                admin.restoreSnapshot(snapshotName);
                admin.enableTable(BackupSystemTable.getTableName(conf));
                LOG.debug("Done restoring backup system table");
            } else {
                LOG.warn("Could not restore backup system table. Snapshot " + snapshotName + " does not exists.");
            }
        }
    }

    private static boolean snapshotExists(Admin admin, String snapshotName) throws IOException {
        List list = admin.listSnapshots();
        for (SnapshotDescription desc : list) {
            if (!desc.getName().equals(snapshotName)) continue;
            return true;
        }
        return false;
    }

    public static boolean snapshotExists(Connection conn) throws IOException {
        return BackupSystemTable.snapshotExists(conn.getAdmin(), BackupSystemTable.getSnapshotName(conn.getConfiguration()));
    }

    public static void deleteSnapshot(Connection conn) throws IOException {
        Configuration conf = conn.getConfiguration();
        LOG.debug("Deleting " + BackupSystemTable.getSnapshotName(conf) + " from the system");
        try (Admin admin = conn.getAdmin();){
            String snapshotName = BackupSystemTable.getSnapshotName(conf);
            if (BackupSystemTable.snapshotExists(admin, snapshotName)) {
                admin.deleteSnapshot(snapshotName);
                LOG.debug("Done deleting backup system table snapshot");
            } else {
                LOG.error("Snapshot " + snapshotName + " does not exists");
            }
        }
    }

    private Put createPutForDeleteOperation(String[] backupIdList) {
        byte[] value = Bytes.toBytes((String)StringUtils.join((Object[])backupIdList, (String)","));
        Put put = new Put(DELETE_OP_ROW);
        put.addColumn(META_FAMILY, FAM_COL, value);
        return put;
    }

    private Delete createDeleteForBackupDeleteOperation() {
        Delete delete = new Delete(DELETE_OP_ROW);
        delete.addFamily(META_FAMILY);
        return delete;
    }

    private Get createGetForDeleteOperation() {
        Get get = new Get(DELETE_OP_ROW);
        get.addFamily(META_FAMILY);
        return get;
    }

    public void startDeleteOperation(String[] backupIdList) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Start delete operation for backups: " + StringUtils.join((Object[])backupIdList));
        }
        Put put = this.createPutForDeleteOperation(backupIdList);
        try (Table table = this.connection.getTable(this.tableName);){
            table.put(put);
        }
    }

    public void finishDeleteOperation() throws IOException {
        LOG.trace("Finsih delete operation for backup ids");
        Delete delete = this.createDeleteForBackupDeleteOperation();
        try (Table table = this.connection.getTable(this.tableName);){
            table.delete(delete);
        }
    }

    public String[] getListOfBackupIdsFromDeleteOperation() throws IOException {
        LOG.trace("Get delete operation for backup ids");
        Get get = this.createGetForDeleteOperation();
        try (Table table = this.connection.getTable(this.tableName);){
            Result res = table.get(get);
            if (res.isEmpty()) {
                String[] stringArray = null;
                return stringArray;
            }
            Cell cell = (Cell)res.listCells().get(0);
            byte[] val = CellUtil.cloneValue((Cell)cell);
            if (val.length == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = (String[])Splitter.on((char)',').splitToStream((CharSequence)new String(val, StandardCharsets.UTF_8)).toArray(String[]::new);
            return stringArray;
        }
    }

    private Put createPutForMergeOperation(String[] backupIdList) {
        byte[] value = Bytes.toBytes((String)StringUtils.join((Object[])backupIdList, (String)","));
        Put put = new Put(MERGE_OP_ROW);
        put.addColumn(META_FAMILY, FAM_COL, value);
        return put;
    }

    public boolean isMergeInProgress() throws IOException {
        Get get = new Get(MERGE_OP_ROW);
        try (Table table = this.connection.getTable(this.tableName);){
            Result res = table.get(get);
            boolean bl = !res.isEmpty();
            return bl;
        }
    }

    private Put createPutForUpdateTablesForMerge(List<TableName> tables) {
        byte[] value = Bytes.toBytes((String)StringUtils.join(tables, (String)","));
        Put put = new Put(MERGE_OP_ROW);
        put.addColumn(META_FAMILY, PATH_COL, value);
        return put;
    }

    private Delete createDeleteForBackupMergeOperation() {
        Delete delete = new Delete(MERGE_OP_ROW);
        delete.addFamily(META_FAMILY);
        return delete;
    }

    private Get createGetForMergeOperation() {
        Get get = new Get(MERGE_OP_ROW);
        get.addFamily(META_FAMILY);
        return get;
    }

    public void startMergeOperation(String[] backupIdList) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Start merge operation for backups: " + StringUtils.join((Object[])backupIdList));
        }
        Put put = this.createPutForMergeOperation(backupIdList);
        try (Table table = this.connection.getTable(this.tableName);){
            table.put(put);
        }
    }

    public void updateProcessedTablesForMerge(List<TableName> tables) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Update tables for merge : " + StringUtils.join(tables, (String)","));
        }
        Put put = this.createPutForUpdateTablesForMerge(tables);
        try (Table table = this.connection.getTable(this.tableName);){
            table.put(put);
        }
    }

    public void finishMergeOperation() throws IOException {
        LOG.trace("Finish merge operation for backup ids");
        Delete delete = this.createDeleteForBackupMergeOperation();
        try (Table table = this.connection.getTable(this.tableName);){
            table.delete(delete);
        }
    }

    public String[] getListOfBackupIdsFromMergeOperation() throws IOException {
        LOG.trace("Get backup ids for merge operation");
        Get get = this.createGetForMergeOperation();
        try (Table table = this.connection.getTable(this.tableName);){
            Result res = table.get(get);
            if (res.isEmpty()) {
                String[] stringArray = null;
                return stringArray;
            }
            Cell cell = (Cell)res.listCells().get(0);
            byte[] val = CellUtil.cloneValue((Cell)cell);
            if (val.length == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = (String[])Splitter.on((char)',').splitToStream((CharSequence)new String(val, StandardCharsets.UTF_8)).toArray(String[]::new);
            return stringArray;
        }
    }

    static Scan createScanForOrigBulkLoadedFiles(@Nullable TableName table) {
        Scan scan = new Scan();
        byte[] startRow = table == null ? BULK_LOAD_PREFIX_BYTES : BackupSystemTable.rowkey(BULK_LOAD_PREFIX, table.toString(), BLK_LD_DELIM);
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.withStartRow(startRow);
        scan.withStopRow(stopRow);
        scan.addFamily(META_FAMILY);
        scan.readVersions(1);
        return scan;
    }

    static String getTableNameFromOrigBulkLoadRow(String rowStr) {
        return (String)Iterators.get(Splitter.onPattern((String)BLK_LD_DELIM).split((CharSequence)rowStr).iterator(), (int)1);
    }

    static String getRegionNameFromOrigBulkLoadRow(String rowStr) {
        List parts = Splitter.onPattern((String)BLK_LD_DELIM).splitToList((CharSequence)rowStr);
        Iterator i = parts.iterator();
        int idx = 3;
        if (parts.size() == 4) {
            idx = 2;
        }
        String region = (String)Iterators.get(i, (int)idx);
        LOG.debug("bulk row string " + rowStr + " region " + region);
        return region;
    }

    static Scan createScanForBulkLoadedFiles(String backupId) {
        Scan scan = new Scan();
        byte[] startRow = backupId == null ? BULK_LOAD_PREFIX_BYTES : BackupSystemTable.rowkey(BULK_LOAD_PREFIX, backupId + BLK_LD_DELIM);
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.withStartRow(startRow);
        scan.withStopRow(stopRow);
        scan.addFamily(META_FAMILY);
        scan.readVersions(1);
        return scan;
    }

    private Scan createScanForBackupSetList() {
        Scan scan = new Scan();
        byte[] startRow = Bytes.toBytes((String)SET_KEY_PREFIX);
        byte[] stopRow = Arrays.copyOf(startRow, startRow.length);
        stopRow[stopRow.length - 1] = (byte)(stopRow[stopRow.length - 1] + 1);
        scan.withStartRow(startRow);
        scan.withStopRow(stopRow);
        scan.addFamily(META_FAMILY);
        return scan;
    }

    private Get createGetForBackupSet(String name) {
        Get get = new Get(BackupSystemTable.rowkey(SET_KEY_PREFIX, name));
        get.addFamily(META_FAMILY);
        return get;
    }

    private Delete createDeleteForBackupSet(String name) {
        Delete del = new Delete(BackupSystemTable.rowkey(SET_KEY_PREFIX, name));
        del.addFamily(META_FAMILY);
        return del;
    }

    private Put createPutForBackupSet(String name, String[] tables) {
        Put put = new Put(BackupSystemTable.rowkey(SET_KEY_PREFIX, name));
        byte[] value = this.convertToByteArray(tables);
        put.addColumn(META_FAMILY, Bytes.toBytes((String)"tables"), value);
        return put;
    }

    private byte[] convertToByteArray(String[] tables) {
        return Bytes.toBytes((String)StringUtils.join((Object[])tables, (String)","));
    }

    private String[] cellValueToBackupSet(Cell current) {
        byte[] data = CellUtil.cloneValue((Cell)current);
        if (!ArrayUtils.isEmpty((byte[])data)) {
            return Bytes.toString((byte[])data).split(",");
        }
        return new String[0];
    }

    private String cellKeyToBackupSetName(Cell current) {
        byte[] data = CellUtil.cloneRow((Cell)current);
        return Bytes.toString((byte[])data).substring(SET_KEY_PREFIX.length());
    }

    private static byte[] rowkey(String s, String ... other) {
        StringBuilder sb = new StringBuilder(s);
        for (String ss : other) {
            sb.append(ss);
        }
        return Bytes.toBytes((String)sb.toString());
    }

    private static void ensureTableEnabled(Admin admin, TableName tableName) throws IOException {
        if (!admin.isTableEnabled(tableName)) {
            try {
                admin.enableTable(tableName);
            }
            catch (TableNotDisabledException ignored) {
                LOG.info("Table {} is not disabled, ignoring enable request", (Object)tableName);
            }
        }
    }

    static class WALItem {
        String backupId;
        String walFile;
        String backupRoot;

        WALItem(String backupId, String walFile, String backupRoot) {
            this.backupId = backupId;
            this.walFile = walFile;
            this.backupRoot = backupRoot;
        }

        public String getBackupId() {
            return this.backupId;
        }

        public String getWalFile() {
            return this.walFile;
        }

        public String getBackupRoot() {
            return this.backupRoot;
        }

        public String toString() {
            return "/" + this.backupRoot + "/" + this.backupId + "/" + this.walFile;
        }
    }
}

