/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandles;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.HBaseHostnameVerifier;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestHelpers;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.net.InetAddresses;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHBaseHostnameVerifier {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseHostnameVerifier.class);
    private static CertificateCreator certificateCreator;
    private HBaseHostnameVerifier impl;

    @BeforeClass
    public static void setupClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        X500NameBuilder caNameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        caNameBuilder.addRDN(BCStyle.CN, MethodHandles.lookup().lookupClass().getCanonicalName() + " Root CA");
        KeyPair keyPair = X509TestHelpers.generateKeyPair(X509KeyType.EC);
        X509Certificate caCert = X509TestHelpers.newSelfSignedCACert(caNameBuilder.build(), keyPair);
        certificateCreator = new CertificateCreator(keyPair, caCert);
    }

    @Before
    public void setup() {
        this.impl = new HBaseHostnameVerifier();
    }

    @Test
    public void testVerify() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(certificateCreator.newCert("CN=foo.com", new String[0]));
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=\u82b1\u5b50.co.jp", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=foo.com", "bar.com"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=foo.com", "bar.com", "\u82b1\u5b50.co.jp"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=", "foo.com"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=foo.com, CN=bar.com, CN=\u82b1\u5b50.co.jp", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=*.foo.com", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.impl.verify("www.foo.com", x509);
        this.impl.verify("\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=*.co.jp", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.co.jp", x509);
        this.impl.verify("foo.co.jp", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=*.foo.com", "*.bar.com", "*.\u82b1\u5b50.co.jp"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "www.foo.com", x509);
        this.exceptionPlease(this.impl, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.impl.verify("www.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.bar.com", x509);
        this.exceptionPlease(this.impl, "a.b.bar.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=repository.infonotary.com", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("repository.infonotary.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=*.google.com", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.google.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=*.google.com", new String[0]));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.Google.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=dummy-value.com", "1.1.1.1"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("1.1.1.1", x509);
        this.exceptionPlease(this.impl, "1.1.1.2", x509);
        this.exceptionPlease(this.impl, "2001:0db8:85a3:0000:0000:8a2e:0370:1111", x509);
        this.exceptionPlease(this.impl, "dummy-value.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=dummy-value.com", "2001:0db8:85a3:0000:0000:8a2e:0370:7334"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("2001:0db8:85a3:0000:0000:8a2e:0370:7334", x509);
        this.exceptionPlease(this.impl, "1.1.1.2", x509);
        this.exceptionPlease(this.impl, "2001:0db8:85a3:0000:0000:8a2e:0370:1111", x509);
        this.exceptionPlease(this.impl, "dummy-value.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=dummy-value.com", "2001:0db8:85a3:0000:0000:8a2e:0370:7334"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("2001:0db8:85a3:0000:0000:8a2e:0370:7334", x509);
        this.impl.verify("[2001:0db8:85a3:0000:0000:8a2e:0370:7334]", x509);
        this.exceptionPlease(this.impl, "1.1.1.2", x509);
        this.exceptionPlease(this.impl, "2001:0db8:85a3:0000:0000:8a2e:0370:1111", x509);
        this.exceptionPlease(this.impl, "dummy-value.com", x509);
        in = new ByteArrayInputStream(certificateCreator.newCert("CN=www.company.com", "email:email@example.com"));
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("www.company.com", x509);
    }

    private void exceptionPlease(HBaseHostnameVerifier hv, String host, X509Certificate x509) {
        try {
            hv.verify(host, x509);
            Assert.fail((String)("HostnameVerifier shouldn't allow [" + host + "]"));
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private static class CertificateCreator {
        private final KeyPair caCertPair;
        private final X509Certificate caCert;

        public CertificateCreator(KeyPair caCertPair, X509Certificate caCert) {
            this.caCertPair = caCertPair;
            this.caCert = caCert;
        }

        public byte[] newCert(String cn, String ... subjectAltName) throws Exception {
            return X509TestHelpers.newCert(this.caCert, this.caCertPair, cn == null ? null : new X500Name(cn), this.caCertPair.getPublic(), this.parseSubjectAltNames(subjectAltName)).getEncoded();
        }

        private GeneralNames parseSubjectAltNames(String ... subjectAltName) {
            if (subjectAltName == null || subjectAltName.length == 0) {
                return null;
            }
            GeneralName[] names = new GeneralName[subjectAltName.length];
            for (int i = 0; i < subjectAltName.length; ++i) {
                String current = subjectAltName[i];
                int type = InetAddresses.isInetAddress((String)current) ? 7 : (current.startsWith("email:") ? 1 : 2);
                names[i] = new GeneralName(type, subjectAltName[i]);
            }
            return new GeneralNames(names);
        }
    }
}

