/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.HBaseInterClusterReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestHBaseInterClusterReplicationEndpointFilterEdits {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseInterClusterReplicationEndpointFilterEdits.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static HBaseInterClusterReplicationEndpoint endpoint;
    private static final TableName TABLE1;
    private static final TableName TABLE2;
    private static final byte[] FAMILY;
    private static final byte[] NON_EXISTING_FAMILY;
    private static final byte[] QUALIFIER;
    private static final byte[] ROW;
    private static final byte[] VALUE;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster();
        ReplicationPeer replicationPeer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        ReplicationPeerConfig rpc = (ReplicationPeerConfig)Mockito.mock(ReplicationPeerConfig.class);
        Mockito.when((Object)rpc.isSerial()).thenReturn((Object)false);
        Mockito.when((Object)replicationPeer.getPeerConfig()).thenReturn((Object)rpc);
        ReplicationEndpoint.Context context = new ReplicationEndpoint.Context(UTIL.getConfiguration(), UTIL.getConfiguration(), null, null, null, replicationPeer, null, null, null);
        endpoint = new HBaseInterClusterReplicationEndpoint();
        endpoint.init(context);
        UTIL.createTable(TABLE1, FAMILY);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFilterNotExistColumnFamilyEdits() {
        ArrayList<ArrayList> entryList = new ArrayList<ArrayList>();
        KeyValue c1 = new KeyValue(ROW, NON_EXISTING_FAMILY, QUALIFIER, EnvironmentEdgeManager.currentTime(), KeyValue.Type.Put, VALUE);
        WAL.Entry e1 = new WAL.Entry(new WALKeyImpl(new byte[32], TABLE1, EnvironmentEdgeManager.currentTime()), new WALEdit().add((Cell)c1));
        entryList.add(Lists.newArrayList((Object[])new WAL.Entry[]{e1}));
        KeyValue c2 = new KeyValue(ROW, FAMILY, QUALIFIER, EnvironmentEdgeManager.currentTime(), KeyValue.Type.Put, VALUE);
        WAL.Entry e2 = new WAL.Entry(new WALKeyImpl(new byte[32], TABLE1, EnvironmentEdgeManager.currentTime()), new WALEdit().add((Cell)c2));
        entryList.add(Lists.newArrayList((Object[])new WAL.Entry[]{e2, e1}));
        List filtered = endpoint.filterNotExistColumnFamilyEdits(entryList);
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertEquals((long)1L, (long)((WAL.Entry)((List)filtered.get(0)).get(0)).getEdit().getCells().size());
        Cell cell = (Cell)((WAL.Entry)((List)filtered.get(0)).get(0)).getEdit().getCells().get(0);
        Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)cell, (byte[])FAMILY));
    }

    @Test
    public void testFilterNotExistTableEdits() {
        ArrayList<ArrayList> entryList = new ArrayList<ArrayList>();
        KeyValue c1 = new KeyValue(ROW, FAMILY, QUALIFIER, EnvironmentEdgeManager.currentTime(), KeyValue.Type.Put, VALUE);
        WAL.Entry e1 = new WAL.Entry(new WALKeyImpl(new byte[32], TABLE2, EnvironmentEdgeManager.currentTime()), new WALEdit().add((Cell)c1));
        entryList.add(Lists.newArrayList((Object[])new WAL.Entry[]{e1}));
        KeyValue c2 = new KeyValue(ROW, FAMILY, QUALIFIER, EnvironmentEdgeManager.currentTime(), KeyValue.Type.Put, VALUE);
        WAL.Entry e2 = new WAL.Entry(new WALKeyImpl(new byte[32], TABLE1, EnvironmentEdgeManager.currentTime()), new WALEdit().add((Cell)c2));
        entryList.add(Lists.newArrayList((Object[])new WAL.Entry[]{e2}));
        List filtered = endpoint.filterNotExistTableEdits(entryList);
        Assert.assertEquals((long)1L, (long)filtered.size());
        WAL.Entry entry = (WAL.Entry)((List)filtered.get(0)).get(0);
        Assert.assertEquals((long)1L, (long)entry.getEdit().getCells().size());
        Assert.assertEquals((Object)TABLE1, (Object)entry.getKey().getTableName());
    }

    static {
        TABLE1 = TableName.valueOf((String)"T1");
        TABLE2 = TableName.valueOf((String)"T2");
        FAMILY = Bytes.toBytes((String)"CF");
        NON_EXISTING_FAMILY = Bytes.toBytes((String)"NECF");
        QUALIFIER = Bytes.toBytes((String)"Q");
        ROW = Bytes.toBytes((String)"r");
        VALUE = Bytes.toBytes((String)"v");
    }
}

