/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractTestScanCursor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestResultScannerCursor
extends AbstractTestScanCursor {
    protected abstract ResultScanner getScanner(Scan var1) throws Exception;

    @Test
    public void testHeartbeatWithSparseFilter() throws Exception {
        try (ResultScanner scanner = this.getScanner(this.createScanWithSparseFilter());){
            Result r;
            int num = 0;
            while ((r = scanner.next()) != null) {
                if (num < (NUM_ROWS - 1) * NUM_FAMILIES * NUM_QUALIFIERS) {
                    Assert.assertTrue((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getCursor().getRow());
                } else {
                    Assert.assertFalse((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getRow());
                }
                ++num;
            }
        }
    }

    @Test
    public void testHeartbeatWithSparseFilterReversed() throws Exception {
        try (ResultScanner scanner = this.getScanner(this.createReversedScanWithSparseFilter());){
            Result r;
            int num = 0;
            while ((r = scanner.next()) != null) {
                if (num < (NUM_ROWS - 1) * NUM_FAMILIES * NUM_QUALIFIERS) {
                    Assert.assertTrue((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[NUM_ROWS - 1 - num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getCursor().getRow());
                } else {
                    Assert.assertFalse((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[0], (byte[])r.getRow());
                }
                ++num;
            }
        }
    }

    @Test
    public void testSizeLimit() throws IOException {
        try (ResultScanner scanner = TEST_UTIL.getConnection().getTable(TABLE_NAME).getScanner(this.createScanWithSizeLimit());){
            Result r;
            int num = 0;
            while ((r = scanner.next()) != null) {
                if (num % (NUM_FAMILIES * NUM_QUALIFIERS) != NUM_FAMILIES * NUM_QUALIFIERS - 1) {
                    Assert.assertTrue((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getCursor().getRow());
                } else {
                    Assert.assertFalse((boolean)r.isCursor());
                    Assert.assertArrayEquals((byte[])ROWS[num / NUM_FAMILIES / NUM_QUALIFIERS], (byte[])r.getRow());
                }
                ++num;
            }
        }
    }
}

