/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import javax.validation.constraints.Null;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestTableOutputFormat {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableOutputFormat.class);
    private static final HBaseTestingUtility util = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TEST_TABLE");
    private static final byte[] columnFamily = Bytes.toBytes((String)"f");
    private static Configuration conf;
    private static RecordWriter<Null, Mutation> writer;
    private static TaskAttemptContext context;
    private static TableOutputFormat<Null> tableOutputFormat;

    @BeforeClass
    public static void setUp() throws Exception {
        util.startMiniCluster();
        util.createTable(TABLE_NAME, columnFamily);
        conf = new Configuration(util.getConfiguration());
        context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        tableOutputFormat = new TableOutputFormat();
        conf.set("hbase.mapred.outputtable", "TEST_TABLE");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        util.shutdownMiniCluster();
    }

    @After
    public void close() throws IOException, InterruptedException {
        if (writer != null && context != null) {
            writer.close(context);
        }
    }

    @Test
    public void testTableOutputFormatWhenWalIsOFFForPut() throws IOException, InterruptedException {
        conf.setBoolean("hbase.mapreduce.tableoutputformat.write.wal", false);
        tableOutputFormat.setConf(conf);
        writer = tableOutputFormat.getRecordWriter(context);
        Put put = new Put("row1".getBytes());
        put.addColumn(columnFamily, Bytes.toBytes((String)"aa"), Bytes.toBytes((String)"value"));
        Assert.assertEquals((String)"Durability of the mutation should be USE_DEFAULT", (Object)Durability.USE_DEFAULT, (Object)put.getDurability());
        writer.write(null, (Object)put);
        Assert.assertEquals((String)"Durability of the mutation should be SKIP_WAL", (Object)Durability.SKIP_WAL, (Object)put.getDurability());
    }

    @Test
    public void testTableOutputFormatWhenWalIsOFFForDelete() throws IOException, InterruptedException {
        conf.setBoolean("hbase.mapreduce.tableoutputformat.write.wal", false);
        tableOutputFormat.setConf(conf);
        writer = tableOutputFormat.getRecordWriter(context);
        Delete delete = new Delete("row2".getBytes());
        delete.addColumn(columnFamily, Bytes.toBytes((String)"aa"));
        Assert.assertEquals((String)"Durability of the mutation should be USE_DEFAULT", (Object)Durability.USE_DEFAULT, (Object)delete.getDurability());
        writer.write(null, (Object)delete);
        Assert.assertEquals((String)"Durability of the mutation should be SKIP_WAL", (Object)Durability.SKIP_WAL, (Object)delete.getDurability());
    }
}

