/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReaderContext {
    private final Path filePath;
    private final FSDataInputStreamWrapper fsdis;
    private final long fileSize;
    private final HFileSystem hfs;
    private final boolean primaryReplicaReader;
    private final ReaderType type;
    private final boolean preadAllBytes;

    public ReaderContext(Path filePath, FSDataInputStreamWrapper fsdis, long fileSize, HFileSystem hfs, boolean primaryReplicaReader, ReaderType type) {
        this.filePath = filePath;
        this.fsdis = fsdis;
        this.fileSize = fileSize;
        this.hfs = hfs;
        this.primaryReplicaReader = primaryReplicaReader;
        this.type = type;
        this.preadAllBytes = hfs.getConf().getBoolean("hfile.pread.all.bytes.enabled", false);
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public FSDataInputStreamWrapper getInputStreamWrapper() {
        return this.fsdis;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public HFileSystem getFileSystem() {
        return this.hfs;
    }

    public boolean isPrimaryReplicaReader() {
        return this.primaryReplicaReader;
    }

    public ReaderType getReaderType() {
        return this.type;
    }

    public boolean isPreadAllBytes() {
        return this.preadAllBytes;
    }

    @InterfaceAudience.Private
    public static enum ReaderType {
        PREAD,
        STREAM;

    }
}

