/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import org.testng.IInvokedMethod;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.invokers.TestNgMethodUtils;

public class InvokedMethod
implements IInvokedMethod {
    private final long m_date;
    private final ITestResult m_testResult;

    public InvokedMethod(long date, ITestResult testResult) {
        this.m_date = date;
        this.m_testResult = testResult;
    }

    @Override
    public boolean isTestMethod() {
        return this.m_testResult.getMethod().isTest();
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.m_testResult.getMethod());
        for (Object p : this.m_testResult.getParameters()) {
            result.append(p).append(" ");
        }
        Object instance = this.m_testResult.getInstance();
        result.append(" ").append(instance != null ? Integer.valueOf(instance.hashCode()) : " <static>");
        return result.toString();
    }

    @Override
    public boolean isConfigurationMethod() {
        return TestNgMethodUtils.isConfigurationMethod(this.m_testResult.getMethod());
    }

    @Override
    public ITestNGMethod getTestMethod() {
        return this.m_testResult.getMethod();
    }

    @Override
    public long getDate() {
        return this.m_date;
    }

    @Override
    public ITestResult getTestResult() {
        return this.m_testResult;
    }
}

