/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;

public class TableMetaData
implements TableMetaDataView {
    private final String quotedTablePath;
    private final List<String> keyColumnNames;
    private final Map<String, ColumnMetaData> columnMetaDataMap;
    private final String identifierQuoteString;

    public TableMetaData(String catalogName, String schemaName, String tableName, List<String> keyColumnNames, String quoteString, Map<String, ColumnMetaData> columnMetaDataMap) {
        if (quoteString == null) {
            quoteString = "";
        }
        this.quotedTablePath = TableMetaData.createQuotedTablePath(catalogName, schemaName, tableName, quoteString);
        this.keyColumnNames = keyColumnNames;
        this.columnMetaDataMap = columnMetaDataMap;
        this.identifierQuoteString = quoteString;
    }

    private static String createQuotedTablePath(String catalogName, String schemaName, String tableName, String quote) {
        StringBuilder builder = new StringBuilder();
        TableMetaData.appendPrefix(builder, catalogName, quote);
        TableMetaData.appendPrefix(builder, schemaName, quote);
        builder.append(quote).append(tableName).append(quote);
        return builder.toString();
    }

    private static void appendPrefix(StringBuilder builder, String prefix, String quote) {
        if (prefix != null && !prefix.isEmpty()) {
            builder.append(quote).append(prefix).append(quote).append('.');
        }
    }

    @Override
    public String getQuotedTablePath() {
        return this.quotedTablePath;
    }

    @Override
    public List<String> getKeyColumnNames() {
        return this.keyColumnNames;
    }

    @Override
    public JDBCType getColumnDataType(String columnName) {
        ColumnMetaData columnMetaData = this.columnMetaDataMap.get(columnName);
        if (columnMetaData == null) {
            return JDBCType.NULL;
        }
        return columnMetaData.getType();
    }

    @Override
    public boolean isColumnNullable(String columnName) {
        ColumnMetaData columnMetaData = this.columnMetaDataMap.get(columnName);
        if (columnMetaData == null) {
            return true;
        }
        return columnMetaData.isNullable();
    }

    @Override
    public Set<String> getColumnNames() {
        return this.columnMetaDataMap.keySet();
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public static class ColumnMetaData {
        private final JDBCType type;
        private final boolean nullable;

        public ColumnMetaData(JDBCType type, boolean nullable) {
            this.type = type;
            this.nullable = nullable;
        }

        public JDBCType getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }
    }
}

