/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Collections;
import java.util.Map;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneEventListener;
import org.apache.geode.cache.lucene.internal.LuceneEventSubstitutionFilter;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.LuceneRegionListener;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.PartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.cache.lucene.internal.xml.LuceneIndexCreation;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public abstract class LuceneIndexImpl
implements InternalLuceneIndex {
    protected static final Logger logger = LogService.getLogger();
    protected final String indexName;
    protected final String regionPath;
    protected final InternalCache cache;
    protected final LuceneIndexStats indexStats;
    protected Map<String, Analyzer> fieldAnalyzers;
    protected String[] searchableFieldNames;
    protected RepositoryManager repositoryManager;
    protected Analyzer analyzer;
    protected LuceneSerializer luceneSerializer;
    protected LocalRegion dataRegion;

    protected LuceneIndexImpl(String indexName, String regionPath, InternalCache cache) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.cache = cache;
        String statsName = indexName + "-" + regionPath;
        this.indexStats = new LuceneIndexStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    protected LocalRegion assignDataRegion() {
        return (LocalRegion)this.cache.getRegion(this.regionPath);
    }

    protected LocalRegion getDataRegion() {
        return this.dataRegion;
    }

    protected boolean withPersistence() {
        RegionAttributes ra = this.dataRegion.getAttributes();
        DataPolicy dp = ra.getDataPolicy();
        boolean withPersistence = dp.withPersistence();
        return withPersistence;
    }

    protected void setSearchableFields(String[] fields) {
        this.searchableFieldNames = fields;
    }

    @Override
    public String[] getFieldNames() {
        return this.searchableFieldNames;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer == null ? new StandardAnalyzer() : analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public LuceneSerializer getLuceneSerializer() {
        return this.luceneSerializer;
    }

    public void setLuceneSerializer(LuceneSerializer serializer) {
        this.luceneSerializer = serializer;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    public void setFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers == null ? null : Collections.unmodifiableMap(fieldAnalyzers);
    }

    @Override
    public LuceneIndexStats getIndexStats() {
        return this.indexStats;
    }

    @Override
    public void initialize() {
        this.dataRegion = this.assignDataRegion();
        this.createLuceneListenersAndFileChunkRegions((PartitionedRepositoryManager)this.repositoryManager);
        this.addExtension(this.dataRegion);
    }

    protected void setupRepositoryManager(LuceneSerializer luceneSerializer) {
        this.repositoryManager = this.createRepositoryManager(luceneSerializer);
    }

    protected abstract RepositoryManager createRepositoryManager(LuceneSerializer var1);

    protected abstract void createLuceneListenersAndFileChunkRegions(PartitionedRepositoryManager var1);

    protected AsyncEventQueue createAEQ(Region dataRegion) {
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.getName(), this.regionPath);
        return this.createAEQ(this.createAEQFactory(dataRegion.getAttributes()), aeqId);
    }

    protected AsyncEventQueue createAEQ(RegionAttributes attributes, String aeqId) {
        if (attributes.getPartitionAttributes() != null && attributes.getPartitionAttributes().getLocalMaxMemory() == 0) {
            return null;
        }
        return this.createAEQ(this.createAEQFactory(attributes), aeqId);
    }

    private AsyncEventQueue createAEQ(AsyncEventQueueFactoryImpl factory, String aeqId) {
        LuceneEventListener listener = new LuceneEventListener(this.cache, this.repositoryManager);
        factory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)new LuceneEventSubstitutionFilter());
        AsyncEventQueue indexQueue = factory.create(aeqId, (AsyncEventListener)listener);
        return indexQueue;
    }

    private AsyncEventQueueFactoryImpl createAEQFactory(RegionAttributes attributes) {
        AsyncEventQueueFactoryImpl factory = (AsyncEventQueueFactoryImpl)this.cache.createAsyncEventQueueFactory();
        factory.setParallel(attributes.getPartitionAttributes() != null);
        factory.setMaximumQueueMemory(1000);
        factory.setDispatcherThreads(10);
        factory.setBatchSize(1000);
        factory.setIsMetaQueue(true);
        if (attributes.getDataPolicy().withPersistence()) {
            factory.setPersistent(true);
        }
        factory.setDiskStoreName(attributes.getDiskStoreName());
        factory.setDiskSynchronous(true);
        factory.setForwardExpirationDestroy(true);
        return factory;
    }

    protected void addExtension(LocalRegion dataRegion) {
        LuceneIndexCreation creation = new LuceneIndexCreation();
        creation.setName(this.getName());
        creation.addFieldNames(this.getFieldNames());
        creation.setRegion((Region)dataRegion);
        creation.setFieldAnalyzers(this.getFieldAnalyzers());
        creation.setLuceneSerializer(this.getLuceneSerializer());
        dataRegion.getExtensionPoint().addExtension((Extension)creation);
    }

    @Override
    public void destroy(boolean initiator) {
        Extension extensionToDelete = null;
        for (Extension extension : this.getDataRegion().getExtensionPoint().getExtensions()) {
            LuceneIndexCreation index = (LuceneIndexCreation)extension;
            if (!index.getName().equals(this.indexName)) continue;
            extensionToDelete = extension;
            break;
        }
        if (extensionToDelete != null) {
            this.getDataRegion().getExtensionPoint().removeExtension(extensionToDelete);
        }
        this.destroyAsyncEventQueue(initiator);
        this.repositoryManager.close();
        RegionListener listenerToRemove = this.getRegionListener();
        if (listenerToRemove != null) {
            this.cache.removeRegionListener(listenerToRemove);
        }
        this.dataRegion.removeCacheServiceProfile(LuceneIndexCreationProfile.generateId(this.indexName, this.regionPath));
    }

    private RegionListener getRegionListener() {
        LuceneRegionListener rl = null;
        for (RegionListener listener : this.cache.getRegionListeners()) {
            LuceneRegionListener lrl;
            if (!(listener instanceof LuceneRegionListener) || !(lrl = (LuceneRegionListener)listener).getRegionPath().equals(this.regionPath) || !lrl.getIndexName().equals(this.indexName)) continue;
            rl = lrl;
            break;
        }
        return rl;
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionAttributes<K, V> attributes) {
        InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true);
        try {
            return this.cache.createVMRegion(regionName, attributes, ira);
        }
        catch (Exception e) {
            InternalGemFireError ige = new InternalGemFireError("unexpected exception", (Throwable)e);
            throw ige;
        }
    }

    private void destroyAsyncEventQueue(boolean initiator) {
        LocalRegion region;
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
        AsyncEventQueueImpl aeq = (AsyncEventQueueImpl)this.cache.getAsyncEventQueue(aeqId);
        if (aeq != null) {
            aeq.stop();
        }
        if (!(region = this.getDataRegion()).isDestroyed()) {
            region.getAttributesMutator().removeAsyncEventQueueId(aeqId);
        }
        if (aeq != null) {
            aeq.destroy(initiator);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroyed aeqId=" + aeqId);
        }
    }
}

