/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.KeyWrapper;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ResponseStatus;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.AbstractCommand;
import org.apache.geode.memcached.GemFireMemcachedServer;

public class GetCommand
extends AbstractCommand {
    private static final String VALUE = "VALUE";
    private static final String W_SPACE = " ";
    private static final String RN = "\r\n";
    @Immutable
    private static final byte[] RN_BUF = GetCommand.toEncodedArray("\r\n");
    @Immutable
    private static final byte[] END_BUF = GetCommand.toEncodedArray(Reply.END.toString());
    private static final ThreadLocal<CharBuffer> lineBuffer = new ThreadLocal();
    private static final int REPLY_BUFFER_CAPACITY = Integer.getInteger("replyBufferCapacity", 146988);
    private static final ThreadLocal<ByteBuffer> replyBuffer = new ThreadLocal();
    private static final int EXTRAS_LENGTH = 4;

    private static final byte[] toEncodedArray(String string) {
        ByteBuffer buffer = asciiCharset.encode(string);
        buffer.rewind();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request, cache);
        }
        return this.processBinaryCommand(request.getRequest(), request, cache, request.getResponse());
    }

    protected ByteBuffer processBinaryCommand(ByteBuffer buffer, RequestReader request, Cache cache, ByteBuffer response) {
        Region<Object, ValueWrapper> r = GetCommand.getMemcachedRegion(cache);
        KeyWrapper key = this.getKey(buffer, 24);
        ValueWrapper val = null;
        try {
            val = r.get(key);
        }
        catch (Exception e) {
            return this.handleBinaryException(key, request, response, "get", e);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("get:key:" + key + " val:" + val);
        }
        if (val == null) {
            if (this.isQuiet()) {
                return null;
            }
            response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
        } else {
            byte[] realValue = val.getValue();
            int responseLength = 24 + realValue.length + 4 + (this.sendKeysInResponse() ? key.getKey().length : 0);
            if (response.capacity() < responseLength) {
                response = request.getResponse(responseLength);
            }
            response.limit(responseLength);
            response.putShort(6, ResponseStatus.NO_ERROR.asShort());
            if (this.sendKeysInResponse()) {
                response.putShort(2, (short)key.getKey().length);
            }
            response.put(4, (byte)4);
            response.putInt(8, 4 + realValue.length + (this.sendKeysInResponse() ? key.getKey().length : 0));
            response.putLong(16, val.getVersion());
            response.position(24);
            response.putInt(val.getFlags());
            if (this.sendKeysInResponse()) {
                response.put(key.getKey());
            }
            response.put(realValue);
            response.flip();
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }

    protected boolean sendKeysInResponse() {
        return false;
    }

    private ByteBuffer processAsciiCommand(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(W_SPACE);
        boolean isGets = firstLineElements[0].equals("gets");
        HashSet<String> keys = new HashSet<String>();
        for (int i = 1; i < firstLineElements.length; ++i) {
            keys.add(this.stripNewline(firstLineElements[i]));
        }
        Region<Object, ValueWrapper> r = GetCommand.getMemcachedRegion(cache);
        Map<Object, ValueWrapper> results = r.getAll(keys);
        return this.composeReply(results, isGets);
    }

    @SuppressWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="findbugs complains that v is null while putting into buffer, but it is not")
    private ByteBuffer composeReply(Map<Object, ValueWrapper> results, boolean isGets) {
        Iterator<Map.Entry<Object, ValueWrapper>> it = results.entrySet().iterator();
        ByteBuffer buffer = this.getReplyBuffer();
        while (it.hasNext()) {
            ValueWrapper valWrapper;
            Map.Entry<Object, ValueWrapper> e = it.next();
            if (this.getLogger().fineEnabled()) {
                this.getLogger().fine("get compose reply:" + e);
            }
            if ((valWrapper = e.getValue()) == null) continue;
            byte[] v = valWrapper.getValue();
            CharBuffer reply = this.getLineBuffer();
            reply.put(VALUE).put(W_SPACE);
            reply.put(e.getKey().toString()).put(W_SPACE);
            reply.put(Integer.toString(valWrapper.getFlags())).put(W_SPACE);
            String valBytes = v == null ? Integer.toString(0) : Integer.toString(v.length);
            reply.put(valBytes);
            if (isGets) {
                reply.put(W_SPACE);
                reply.put(Long.toString(valWrapper.getVersion()));
            }
            reply.put(RN);
            reply.flip();
            this.getAsciiEncoder().encode(reply, buffer, false);
            buffer.put(v);
            buffer.put(RN_BUF);
        }
        buffer.put(END_BUF);
        buffer.flip();
        return buffer;
    }

    private ByteBuffer getReplyBuffer() {
        ByteBuffer retVal = replyBuffer.get();
        if (retVal == null) {
            retVal = ByteBuffer.allocate(REPLY_BUFFER_CAPACITY);
            replyBuffer.set(retVal);
        }
        retVal.clear();
        return retVal;
    }

    private CharBuffer getLineBuffer() {
        CharBuffer retVal = lineBuffer.get();
        if (retVal == null) {
            retVal = CharBuffer.allocate(1024);
            lineBuffer.set(retVal);
        }
        retVal.clear();
        return retVal;
    }
}

