/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.tcpserver.HostAddress;
import org.apache.geode.internal.DistributionLocator;
import org.apache.geode.internal.inet.LocalHostUtil;

public abstract class Locator {
    protected File logFile;
    protected InetAddress bindAddress;
    protected HostAddress hostAddress;
    protected String hostnameForClients;

    @Deprecated
    public static Locator startLocator(int port, File logFile) throws IOException {
        return Locator.startLocator(port, logFile, false, null, null, true, true, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, Properties distributedSystemProperties) throws IOException {
        return Locator.startLocator(port, logFile, null, distributedSystemProperties, true, true, null);
    }

    @Deprecated
    public static Locator startLocator(int port, File logFile, InetAddress bindAddress) throws IOException {
        HostAddress hostAddress = bindAddress == null ? null : new HostAddress(bindAddress);
        return Locator.startLocator(port, logFile, false, hostAddress, null, true, true, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, InetAddress bindAddress, Properties dsProperties) throws IOException {
        HostAddress hostAddress = bindAddress == null ? null : new HostAddress(bindAddress);
        return Locator.startLocator(port, logFile, hostAddress, dsProperties, true, true, null);
    }

    @Deprecated
    public static Locator startLocatorAndDS(int port, File logFile, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        HostAddress hostAddress = bindAddress == null ? null : new HostAddress(bindAddress);
        return Locator.startLocator(port, logFile, hostAddress, dsProperties, true, true, hostnameForClients);
    }

    private static Locator startLocator(int port, File logFile, HostAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, null, null, bindAddress, true, dsProperties, hostnameForClients);
    }

    @Deprecated
    private static Locator startLocator(int port, File logFile, boolean startDistributedSystem, HostAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, null, null, bindAddress, startDistributedSystem, dsProperties, hostnameForClients);
    }

    @Deprecated
    public static List<Locator> getLocators() {
        Locator result = Locator.getLocator();
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    public static Locator getLocator() {
        return InternalLocator.getLocator();
    }

    @Deprecated
    public static boolean hasLocators() {
        return Locator.hasLocator();
    }

    public static boolean hasLocator() {
        return InternalLocator.hasLocator();
    }

    public abstract Integer getPort();

    public abstract DistributedSystem getDistributedSystem();

    public File getLogFile() {
        return this.logFile;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public String getHostnameForClients() {
        String result = this.hostnameForClients;
        if (result != null && result.equals("")) {
            result = null;
        }
        return result;
    }

    public abstract boolean isPeerLocator();

    public abstract boolean isServerLocator();

    public abstract void stop();

    public String toString() {
        return String.format("Distribution Locator on %s", this.asString());
    }

    public String asString() {
        String bindAddressString = null;
        if (this.hostAddress == null) {
            try {
                bindAddressString = LocalHostUtil.getLocalHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            bindAddressString = this.hostAddress.getHostName();
        }
        StringBuilder locatorString = new StringBuilder(String.valueOf(bindAddressString));
        Integer port = this.getPort();
        if (port != null && port > 0) {
            locatorString.append('[').append(this.getPort()).append(']');
        }
        return locatorString.toString();
    }

    @Deprecated
    public static void main(String[] args) {
        DistributionLocator.main(args);
    }
}

