/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.util;

import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.PartitionResolver;

public class StringPrefixPartitionResolver
implements PartitionResolver<String, Object> {
    public static final String DEFAULT_DELIMITER = "|";

    @Override
    public Object getRoutingObject(EntryOperation<String, Object> opDetails) {
        String delimiter;
        String key = opDetails.getKey();
        int idx = key.indexOf(delimiter = this.getDelimiter());
        if (idx == -1) {
            throw new IllegalArgumentException("The key \"" + key + "\" does not contains the \"" + delimiter + "\" delimiter.");
        }
        return key.substring(0, idx);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    private String getDelimiter() {
        return DEFAULT_DELIMITER;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringPrefixPartitionResolver)) {
            return false;
        }
        StringPrefixPartitionResolver other = (StringPrefixPartitionResolver)o;
        return other.getName().equals(this.getName()) && other.getDelimiter().equals(this.getDelimiter());
    }

    @Override
    public void close() {
    }
}

