/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.queue;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.flink.agents.runtime.queue.Lock;

public final class Locks {
    private Locks() {
    }

    public static Lock spinLock() {
        return new YieldingSpinLock();
    }

    private static final class YieldingSpinLock
    extends RhsPadding
    implements Lock {
        private static final AtomicLongFieldUpdater<Value> UPDATER = AtomicLongFieldUpdater.newUpdater(Value.class, "state");

        private YieldingSpinLock() {
        }

        @Override
        public void lockUninterruptibly() {
            while (!UPDATER.compareAndSet(this, 0L, 1L)) {
                Thread.yield();
            }
        }

        @Override
        public void unlock() {
            UPDATER.lazySet(this, 0L);
        }
    }

    private static class RhsPadding
    extends Value {
        protected long p9;
        protected long p10;
        protected long p11;
        protected long p12;
        protected long p13;
        protected long p14;
        protected long p15;

        private RhsPadding() {
        }
    }

    private static class Value
    extends LhsPadding {
        protected volatile long state;

        private Value() {
        }
    }

    private static class LhsPadding {
        protected long p1;
        protected long p2;
        protected long p3;
        protected long p4;
        protected long p5;
        protected long p6;
        protected long p7;

        private LhsPadding() {
        }
    }
}

