/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.eventlog;

import java.io.IOException;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.EventContext;
import org.apache.flink.agents.runtime.eventlog.EventLogRecord;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class EventLogRecordJsonDeserializer
extends JsonDeserializer<EventLogRecord> {
    @Override
    public EventLogRecord deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode contextNode = rootNode.get("context");
        if (contextNode == null) {
            throw new IOException("Missing 'context' field in EventLogRecord JSON");
        }
        EventContext eventContext = mapper.treeToValue((TreeNode)contextNode, EventContext.class);
        if (eventContext == null) {
            throw new IOException("Failed to deserialize EventContext");
        }
        JsonNode eventNode = rootNode.get("event");
        if (eventNode == null) {
            throw new IOException("Missing 'event' field in EventLogRecord JSON");
        }
        Event event = this.deserializeEvent(mapper, eventNode, eventContext.getEventType());
        return new EventLogRecord(eventContext, event);
    }

    private Event deserializeEvent(ObjectMapper mapper, JsonNode eventNode, String eventType) throws IOException {
        try {
            Class<?> eventClass = Class.forName(eventType);
            if (!Event.class.isAssignableFrom(eventClass)) {
                throw new IOException(String.format("Class '%s' is not a subclass of Event", eventType));
            }
            Class<?> concreteEventClass = eventClass;
            return (Event)mapper.treeToValue((TreeNode)eventNode, concreteEventClass);
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to deserialize event of type '%s'", eventType), e);
        }
    }
}

