/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.tools;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.flink.agents.api.annotation.Tool;
import org.apache.flink.agents.api.tools.ToolMetadata;
import org.apache.flink.agents.plan.tools.SchemaUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;

public class ToolMetadataFactory {
    public static ToolMetadata fromStaticMethod(Method method) throws JsonProcessingException {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Only static methods are supported");
        }
        Tool toolAnnotation = method.getAnnotation(Tool.class);
        if (toolAnnotation == null) {
            throw new IllegalArgumentException("Method must be annotated with @Tool");
        }
        String name = method.getName();
        String description = toolAnnotation.description();
        String schema = SchemaUtils.generateSchema(method);
        return new ToolMetadata(name, description, schema);
    }
}

