/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.ollama4j.models.chat.OllamaChatMessageRole;
import io.github.ollama4j.models.chat.OllamaChatToolCalls;
import io.github.ollama4j.utils.FileToBase64Serializer;
import io.github.ollama4j.utils.Utils;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OllamaChatMessage {
    @NonNull
    private OllamaChatMessageRole role;
    @NonNull
    private String content;
    private String thinking;
    @JsonProperty(value="tool_calls")
    private List<OllamaChatToolCalls> toolCalls;
    @JsonSerialize(using=FileToBase64Serializer.class)
    private List<byte[]> images;

    public String toString() {
        try {
            return Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    @Generated
    public OllamaChatMessageRole getRole() {
        return this.role;
    }

    @NonNull
    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getThinking() {
        return this.thinking;
    }

    @Generated
    public List<OllamaChatToolCalls> getToolCalls() {
        return this.toolCalls;
    }

    @Generated
    public List<byte[]> getImages() {
        return this.images;
    }

    @Generated
    public void setRole(@NonNull OllamaChatMessageRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    @Generated
    public void setContent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    @Generated
    public void setThinking(String thinking) {
        this.thinking = thinking;
    }

    @JsonProperty(value="tool_calls")
    @Generated
    public void setToolCalls(List<OllamaChatToolCalls> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @Generated
    public void setImages(List<byte[]> images) {
        this.images = images;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaChatMessage)) {
            return false;
        }
        OllamaChatMessage other = (OllamaChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OllamaChatMessageRole this$role = this.getRole();
        OllamaChatMessageRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$thinking = this.getThinking();
        String other$thinking = other.getThinking();
        if (this$thinking == null ? other$thinking != null : !this$thinking.equals(other$thinking)) {
            return false;
        }
        List<OllamaChatToolCalls> this$toolCalls = this.getToolCalls();
        List<OllamaChatToolCalls> other$toolCalls = other.getToolCalls();
        if (this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls)) {
            return false;
        }
        List<byte[]> this$images = this.getImages();
        List<byte[]> other$images = other.getImages();
        return !(this$images == null ? other$images != null : !((Object)this$images).equals(other$images));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OllamaChatMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OllamaChatMessageRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $thinking = this.getThinking();
        result = result * 59 + ($thinking == null ? 43 : $thinking.hashCode());
        List<OllamaChatToolCalls> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        List<byte[]> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        return result;
    }

    @Generated
    public OllamaChatMessage(@NonNull OllamaChatMessageRole role, @NonNull String content, String thinking, List<OllamaChatToolCalls> toolCalls, List<byte[]> images) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.thinking = thinking;
        this.toolCalls = toolCalls;
        this.images = images;
    }

    @Generated
    public OllamaChatMessage(@NonNull OllamaChatMessageRole role, @NonNull String content) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
    }

    @Generated
    public OllamaChatMessage() {
    }
}

