/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials.authenticator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.config.PrivateKeyJWTClientAuthnMethodConfig;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(OidcAuthenticator.class);
    private static final Collection<ClientAuthenticationMethod> SUPPORTED_METHODS = Arrays.asList(ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.PRIVATE_KEY_JWT, ClientAuthenticationMethod.NONE);
    protected OidcConfiguration configuration;
    protected OidcClient client;
    private ClientAuthentication clientAuthentication;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OidcAuthenticator(OidcConfiguration configuration, OidcClient client) {
        ClientAuthenticationMethod chosenMethod;
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
        ClientID _clientID = new ClientID(configuration.getClientId());
        if (configuration.getSecret() == null) return;
        List serverSupportedAuthMethods = configuration.findProviderMetadata().getTokenEndpointAuthMethods();
        ClientAuthenticationMethod preferredMethod = OidcAuthenticator.getPreferredAuthenticationMethod(configuration);
        if (CommonHelper.isNotEmpty((Collection)serverSupportedAuthMethods)) {
            if (preferredMethod != null) {
                if (!serverSupportedAuthMethods.contains(preferredMethod)) throw new TechnicalException("Preferred authentication method (" + preferredMethod + ") not supported by provider according to provider metadata (" + serverSupportedAuthMethods + ").");
                chosenMethod = preferredMethod;
            } else {
                chosenMethod = OidcAuthenticator.firstSupportedMethod(serverSupportedAuthMethods, configuration.getSupportedClientAuthenticationMethods());
            }
        } else {
            chosenMethod = preferredMethod != null ? preferredMethod : ClientAuthenticationMethod.getDefault();
            logger.info("Provider metadata does not provide Token endpoint authentication methods. Using: {}", (Object)chosenMethod);
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)chosenMethod)) {
            Secret _secret = new Secret(configuration.getSecret());
            this.clientAuthentication = new ClientSecretPost(_clientID, _secret);
            return;
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)chosenMethod)) {
            Secret _secret = new Secret(configuration.getSecret());
            this.clientAuthentication = new ClientSecretBasic(_clientID, _secret);
            return;
        }
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)chosenMethod)) throw new TechnicalException("Unsupported client authentication method: " + chosenMethod);
        PrivateKeyJWTClientAuthnMethodConfig privateKeyJwtConfig = configuration.getPrivateKeyJWTClientAuthnMethodConfig();
        CommonHelper.assertNotNull((String)"privateKeyJwtConfig", (Object)privateKeyJwtConfig);
        JWSAlgorithm jwsAlgo = privateKeyJwtConfig.getJwsAlgorithm();
        CommonHelper.assertNotNull((String)"privateKeyJwtConfig.getJwsAlgorithm()", (Object)jwsAlgo);
        PrivateKey privateKey = privateKeyJwtConfig.getPrivateKey();
        CommonHelper.assertNotNull((String)"privateKeyJwtConfig.getPrivateKey()", (Object)privateKey);
        String keyID = privateKeyJwtConfig.getKeyID();
        try {
            this.clientAuthentication = new PrivateKeyJWT(_clientID, configuration.findProviderMetadata().getTokenEndpointURI(), jwsAlgo, privateKey, keyID, null);
            return;
        }
        catch (JOSEException e) {
            throw new TechnicalException("Cannot instantiate private key JWT client authentication method", (Throwable)e);
        }
    }

    private static ClientAuthenticationMethod getPreferredAuthenticationMethod(OidcConfiguration config) {
        ClientAuthenticationMethod configurationMethod = config.getClientAuthenticationMethod();
        if (configurationMethod == null) {
            return null;
        }
        if (!SUPPORTED_METHODS.contains(configurationMethod)) {
            throw new TechnicalException("Configured authentication method (" + configurationMethod + ") is not supported.");
        }
        return configurationMethod;
    }

    private static ClientAuthenticationMethod firstSupportedMethod(List<ClientAuthenticationMethod> serverSupportedAuthMethods, Set<ClientAuthenticationMethod> clientSupportedAuthMethods) {
        Collection<ClientAuthenticationMethod> supportedMethods = clientSupportedAuthMethods != null ? clientSupportedAuthMethods : SUPPORTED_METHODS;
        Optional<ClientAuthenticationMethod> firstSupported = serverSupportedAuthMethods.stream().filter(supportedMethods::contains).findFirst();
        if (firstSupported.isPresent()) {
            return firstSupported.get();
        }
        throw new TechnicalException("None of the Token endpoint provider metadata authentication methods are supported: " + serverSupportedAuthMethods);
    }

    public void validate(Credentials cred, WebContext context, SessionStore sessionStore) {
        OidcCredentials credentials = (OidcCredentials)cred;
        AuthorizationCode code = credentials.getCode();
        if (code != null) {
            try {
                String computedCallbackUrl = this.client.computeFinalCallbackUrl(context);
                CodeVerifier verifier = this.configuration.getValueRetriever().retrieve(this.client.getCodeVerifierSessionAttributeName(), this.client, context, sessionStore).orElse(null);
                TokenRequest request = this.createTokenRequest((AuthorizationGrant)new AuthorizationCodeGrant(code, new URI(computedCallbackUrl), verifier));
                this.executeTokenRequest(request, credentials);
            }
            catch (ParseException | IOException | URISyntaxException e) {
                throw new TechnicalException(e);
            }
        }
    }

    public void refresh(OidcCredentials credentials) {
        RefreshToken refreshToken = credentials.getRefreshToken();
        if (refreshToken != null) {
            try {
                TokenRequest request = this.createTokenRequest((AuthorizationGrant)new RefreshTokenGrant(refreshToken));
                this.executeTokenRequest(request, credentials);
            }
            catch (ParseException | IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    protected TokenRequest createTokenRequest(AuthorizationGrant grant) {
        if (this.clientAuthentication != null) {
            return new TokenRequest(this.configuration.findProviderMetadata().getTokenEndpointURI(), this.clientAuthentication, grant);
        }
        return new TokenRequest(this.configuration.findProviderMetadata().getTokenEndpointURI(), new ClientID(this.configuration.getClientId()), grant);
    }

    private void executeTokenRequest(TokenRequest request, OidcCredentials credentials) throws IOException, ParseException {
        HTTPRequest tokenHttpRequest = request.toHTTPRequest();
        this.configuration.configureHttpRequest(tokenHttpRequest);
        HTTPResponse httpResponse = tokenHttpRequest.send();
        logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
        TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
        if (response instanceof TokenErrorResponse) {
            ErrorObject errorObject = ((TokenErrorResponse)response).getErrorObject();
            throw new TechnicalException("Bad token response, error=" + errorObject.getCode() + ", description=" + errorObject.getDescription());
        }
        logger.debug("Token response successful");
        OIDCTokenResponse tokenSuccessResponse = (OIDCTokenResponse)response;
        OIDCTokens oidcTokens = tokenSuccessResponse.getOIDCTokens();
        credentials.setAccessToken(oidcTokens.getAccessToken());
        credentials.setRefreshToken(oidcTokens.getRefreshToken());
        if (oidcTokens.getIDToken() != null) {
            credentials.setIdToken(oidcTokens.getIDToken());
        }
    }

    public ClientAuthentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(ClientAuthentication clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }
}

