/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.bloom;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.guice.BloomFilterSerializersModule;
import org.apache.druid.query.aggregation.bloom.BloomFilterAggregatorFactory;
import org.apache.druid.query.filter.BloomKFilter;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class BloomFilterSerde
extends ComplexMetricSerde {
    private static final BloomFilterObjectStrategy STRATEGY = new BloomFilterObjectStrategy();

    public String getTypeName() {
        return "bloom";
    }

    public ComplexMetricExtractor getExtractor() {
        throw new UnsupportedOperationException("Bloom filter aggregators are query-time only");
    }

    public void deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        throw new UnsupportedOperationException("Bloom filter aggregators are query-time only");
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column, IndexSpec indexSpec) {
        throw new UnsupportedOperationException("Bloom filter aggregators are query-time only");
    }

    public ObjectStrategy<BloomKFilter> getObjectStrategy() {
        return STRATEGY;
    }

    private static class BloomFilterObjectStrategy
    implements ObjectStrategy<BloomKFilter> {
        private BloomFilterObjectStrategy() {
        }

        public Class<? extends BloomKFilter> getClazz() {
            return BloomKFilter.class;
        }

        @Nullable
        public BloomKFilter fromByteBuffer(ByteBuffer buffer, int numBytes) {
            try {
                return BloomKFilter.deserialize(buffer, buffer.position());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        public byte[] toBytes(@Nullable BloomKFilter val) {
            try {
                return BloomFilterSerializersModule.bloomKFilterToBytes(val);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int compare(BloomKFilter o1, BloomKFilter o2) {
            return BloomFilterAggregatorFactory.COMPARATOR.compare(o1, o2);
        }
    }
}

