/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBProxyEndpointsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBProxyEndpointsRequestMarshaller
implements Marshaller<Request<DescribeDBProxyEndpointsRequest>, DescribeDBProxyEndpointsRequest> {
    public Request<DescribeDBProxyEndpointsRequest> marshall(DescribeDBProxyEndpointsRequest describeDBProxyEndpointsRequest) {
        if (describeDBProxyEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBProxyEndpointsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBProxyEndpoints");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBProxyEndpointsRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)describeDBProxyEndpointsRequest.getDBProxyName()));
        }
        if (describeDBProxyEndpointsRequest.getDBProxyEndpointName() != null) {
            request.addParameter("DBProxyEndpointName", StringUtils.fromString((String)describeDBProxyEndpointsRequest.getDBProxyEndpointName()));
        }
        if (!describeDBProxyEndpointsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBProxyEndpointsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBProxyEndpointsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBProxyEndpointsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBProxyEndpointsRequest.getMarker()));
        }
        if (describeDBProxyEndpointsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBProxyEndpointsRequest.getMaxRecords()));
        }
        return request;
    }
}

