/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical;

import org.apache.druid.error.NotYetImplemented;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.logical.StageMaker;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.segment.column.RowSignature;

public abstract class LogicalInputSpec {
    public abstract InputSpec toInputSpec(StageMaker var1);

    public abstract RowSignature getRowSignature();

    public static LogicalInputSpec of(LogicalStage inputStage) {
        return new DagStageInputSpec(inputStage);
    }

    public static LogicalInputSpec of(InputSpec inputSpec) {
        return new PhysicalInputSpec(inputSpec);
    }

    static class DagStageInputSpec
    extends LogicalInputSpec {
        private LogicalStage inputStage;

        public DagStageInputSpec(LogicalStage inputStage) {
            this.inputStage = inputStage;
        }

        @Override
        public InputSpec toInputSpec(StageMaker maker) {
            StageDefinitionBuilder stage = maker.buildStage(this.inputStage);
            return new StageInputSpec(stage.getStageNumber());
        }

        public LogicalStage getStage() {
            return this.inputStage;
        }

        @Override
        public RowSignature getRowSignature() {
            return this.inputStage.getLogicalRowSignature();
        }
    }

    static class PhysicalInputSpec
    extends LogicalInputSpec {
        private InputSpec inputSpec;

        public PhysicalInputSpec(InputSpec inputSpec) {
            this.inputSpec = inputSpec;
        }

        @Override
        public InputSpec toInputSpec(StageMaker maker) {
            return this.inputSpec;
        }

        @Override
        public RowSignature getRowSignature() {
            throw NotYetImplemented.ex(null, (String)"Not supported for this type", (Object[])new Object[0]);
        }
    }
}

