/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.calcite.planner.ColumnMappings;

public class QueryDefMSQSpec
extends MSQSpec {
    protected final QueryDefinition queryDef;

    public QueryDefMSQSpec() {
        this.queryDef = null;
    }

    @JsonCreator
    public QueryDefMSQSpec(@JsonProperty(value="queryDef") QueryDefinition queryDef, @JsonProperty(value="columnMappings") ColumnMappings columnMappings, @JsonProperty(value="destination") MSQDestination destination, @JsonProperty(value="assignmentStrategy") WorkerAssignmentStrategy assignmentStrategy, @JsonProperty(value="tuningConfig") MSQTuningConfig tuningConfig) {
        super(columnMappings, destination, assignmentStrategy, tuningConfig);
        this.queryDef = (QueryDefinition)Preconditions.checkNotNull((Object)queryDef, (Object)"queryDef");
    }

    @JsonProperty(value="queryDef")
    public QueryDefinition getQueryDef() {
        return this.queryDef;
    }

    @Override
    public String getId() {
        return this.getContext().getString("queryId");
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        QueryDefMSQSpec that = (QueryDefMSQSpec)o;
        return Objects.equals(this.queryDef, that.queryDef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.queryDef);
    }

    @Override
    public QueryContext getContext() {
        return this.queryDef.getContext();
    }

    public static class Builder {
        private ColumnMappings columnMappings;
        private MSQDestination destination = TaskReportMSQDestination.instance();
        private WorkerAssignmentStrategy assignmentStrategy = WorkerAssignmentStrategy.MAX;
        private MSQTuningConfig tuningConfig;
        private QueryDefinition queryDef;

        public Builder queryDef(QueryDefinition queryDef) {
            this.queryDef = queryDef;
            return this;
        }

        public Builder columnMappings(ColumnMappings columnMappings) {
            this.columnMappings = columnMappings;
            return this;
        }

        public Builder destination(MSQDestination destination) {
            this.destination = destination;
            return this;
        }

        public Builder assignmentStrategy(WorkerAssignmentStrategy assignmentStrategy) {
            this.assignmentStrategy = assignmentStrategy;
            return this;
        }

        public Builder tuningConfig(MSQTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public QueryDefMSQSpec build() {
            if (this.destination == null) {
                this.destination = TaskReportMSQDestination.instance();
            }
            return new QueryDefMSQSpec(this.queryDef, this.columnMappings, this.destination, this.assignmentStrategy, this.tuningConfig);
        }
    }
}

