/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.messages.client.MessageListener;
import org.apache.druid.messages.client.MessageRelay;
import org.apache.druid.messages.client.MessageRelayClient;
import org.apache.druid.messages.client.MessageRelayClientImpl;
import org.apache.druid.messages.client.MessageRelayFactory;
import org.apache.druid.msq.dart.controller.ControllerMessageListener;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.rpc.FixedServiceLocator;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.server.DruidNode;

public class DartMessageRelayFactoryImpl
implements MessageRelayFactory<ControllerMessage> {
    private final String clientHost;
    private final ControllerMessageListener messageListener;
    private final ServiceClientFactory clientFactory;
    private final String basePath;
    private final ObjectMapper smileMapper;

    @Inject
    public DartMessageRelayFactoryImpl(@Self DruidNode selfNode, @EscalatedGlobal ServiceClientFactory clientFactory, @Smile ObjectMapper smileMapper, ControllerMessageListener messageListener) {
        this.clientHost = selfNode.getHostAndPortToUse();
        this.messageListener = messageListener;
        this.clientFactory = clientFactory;
        this.smileMapper = smileMapper;
        this.basePath = "/druid/dart-worker/relay";
    }

    public MessageRelay<ControllerMessage> newRelay(DruidNode clientNode) {
        ServiceLocation location = ServiceLocation.fromDruidNode((DruidNode)clientNode).withBasePath(this.basePath);
        ServiceClient client = this.clientFactory.makeClient(clientNode.getHostAndPortToUse(), (ServiceLocator)new FixedServiceLocator(location), (ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        return new MessageRelay(this.clientHost, clientNode, (MessageRelayClient)new MessageRelayClientImpl(client, this.smileMapper, ControllerMessage.class), (MessageListener)this.messageListener);
    }
}

