/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.google.inject.Inject;
import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.extended.leaderelection.LeaderElector;
import io.kubernetes.client.extended.leaderelection.Lock;
import io.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import java.time.Duration;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.K8sLeaderElector;
import org.apache.druid.k8s.discovery.K8sLeaderElectorFactory;

public class DefaultK8sLeaderElectorFactory
implements K8sLeaderElectorFactory {
    private final ApiClient realK8sClient;
    private final K8sDiscoveryConfig discoveryConfig;

    @Inject
    public DefaultK8sLeaderElectorFactory(ApiClient realK8sClient, K8sDiscoveryConfig discoveryConfig) {
        this.realK8sClient = realK8sClient;
        this.discoveryConfig = discoveryConfig;
    }

    @Override
    public K8sLeaderElector create(String candidateId, String namespace, final String lockResourceName) {
        final Lock lock = this.createLock(candidateId, namespace, lockResourceName, this.realK8sClient);
        LeaderElectionConfig leaderElectionConfig = new LeaderElectionConfig(lock, Duration.ofMillis(this.discoveryConfig.getLeaseDuration().getMillis()), Duration.ofMillis(this.discoveryConfig.getRenewDeadline().getMillis()), Duration.ofMillis(this.discoveryConfig.getRetryPeriod().getMillis()));
        final LeaderElector leaderElector = new LeaderElector(leaderElectionConfig);
        return new K8sLeaderElector(){

            @Override
            public String getCurrentLeader() {
                try {
                    return lock.get().getHolderIdentity();
                }
                catch (ApiException ex) {
                    throw new RE((Throwable)ex, "Failed  to get current leader for [%s]", new Object[]{lockResourceName});
                }
            }

            @Override
            public void run(Runnable startLeadingHook, Runnable stopLeadingHook) {
                leaderElector.run(startLeadingHook, stopLeadingHook);
            }
        };
    }

    private Lock createLock(String candidateId, String namespace, String lockResourceName, ApiClient k8sApiClient) {
        return new ConfigMapLock(namespace, lockResourceName, candidateId, k8sApiClient);
    }
}

