/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsDataSegmentKiller
implements DataSegmentKiller {
    private static final EmittingLogger log = new EmittingLogger(HdfsDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final Configuration config;
    @Nullable
    private final Path storageDirectory;

    @Inject
    public HdfsDataSegmentKiller(@Hdfs Configuration config, HdfsDataSegmentPusherConfig pusherConfig) {
        this.config = config;
        this.storageDirectory = !Strings.isNullOrEmpty((String)pusherConfig.getStorageDirectory()) ? new Path(pusherConfig.getStorageDirectory()) : null;
    }

    private static Path getPath(DataSegment segment) {
        return new Path(String.valueOf(segment.getLoadSpec().get(PATH_KEY)));
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        Path segmentPath = HdfsDataSegmentKiller.getPath(segment);
        log.info("Killing segment[%s] mapped to path[%s]", new Object[]{segment.getId(), segmentPath});
        try (FileSystem fs = segmentPath.getFileSystem(this.config);){
            String filename = segmentPath.getName();
            if (!filename.endsWith(".zip")) {
                throw new SegmentLoadingException("Unknown file type[%s]", new Object[]{segmentPath});
            }
            if (!fs.exists(segmentPath)) {
                log.warn("Segment path [%s] does not exist", new Object[]{segmentPath});
                return;
            }
            String[] zipParts = filename.split("_");
            Path descriptorPath = new Path(segmentPath.getParent(), "descriptor.json");
            if (zipParts.length > 1) {
                Preconditions.checkState((zipParts.length <= 3 && org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)zipParts[0]) && "index.zip".equals(zipParts[zipParts.length - 1]) ? 1 : 0) != 0, (String)"Unexpected segmentPath format [%s]", (Object)segmentPath);
                descriptorPath = new Path(segmentPath.getParent(), StringUtils.format((String)"%s_%sdescriptor.json", (Object[])new Object[]{zipParts[0], zipParts.length == 2 ? "" : zipParts[1] + "_"}));
            }
            if (!fs.delete(segmentPath, false)) {
                throw new SegmentLoadingException("Unable to kill segment, failed to delete [%s]", new Object[]{segmentPath.toString()});
            }
            fs.delete(descriptorPath, false);
            this.removeEmptyParentDirectories(fs, segmentPath, zipParts.length > 1 ? 2 : 3);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Unable to kill segment", new Object[0]);
        }
    }

    public void killAll() throws IOException {
        if (this.storageDirectory == null) {
            throw new ISE("Cannot delete all segment files since druid.storage.storageDirectory is not set.", new Object[0]);
        }
        log.info("Deleting all segment files from hdfs dir [%s].", new Object[]{this.storageDirectory.toUri().toString()});
        FileSystem fs = this.storageDirectory.getFileSystem(this.config);
        fs.delete(this.storageDirectory, true);
    }

    private void removeEmptyParentDirectories(FileSystem fs, Path segmentPath, int depth) {
        Path path = segmentPath;
        try {
            for (int i = 1; i <= depth && fs.listStatus(path = path.getParent()).length == 0 && fs.delete(path, false); ++i) {
            }
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "uncaught exception during segment killer", new Object[0]).emit();
        }
    }
}

