/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceHandle holds opaque resource data for processing by a specific kubelet plugin.")
public class V1alpha2ResourceHandle {
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private String data;
    public static final String SERIALIZED_NAME_DRIVER_NAME = "driverName";
    @SerializedName(value="driverName")
    private String driverName;

    public V1alpha2ResourceHandle data(String data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Data contains the opaque data associated with this ResourceHandle. It is set by the controller component of the resource driver whose name matches the DriverName set in the ResourceClaimStatus this ResourceHandle is embedded in. It is set at allocation time and is intended for processing by the kubelet plugin whose name matches the DriverName set in this ResourceHandle.  The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public V1alpha2ResourceHandle driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DriverName specifies the name of the resource driver whose kubelet plugin should be invoked to process this ResourceHandle's data once it lands on a node. This may differ from the DriverName set in ResourceClaimStatus this ResourceHandle is embedded in.")
    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceHandle v1alpha2ResourceHandle = (V1alpha2ResourceHandle)o;
        return Objects.equals(this.data, v1alpha2ResourceHandle.data) && Objects.equals(this.driverName, v1alpha2ResourceHandle.driverName);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.driverName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceHandle {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

