/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ContainerResizePolicy represents resource resize policy for the container.")
public class V1ContainerResizePolicy {
    public static final String SERIALIZED_NAME_RESOURCE_NAME = "resourceName";
    @SerializedName(value="resourceName")
    private String resourceName;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restartPolicy";
    @SerializedName(value="restartPolicy")
    private String restartPolicy;

    public V1ContainerResizePolicy resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public V1ContainerResizePolicy restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @ApiModelProperty(required=true, value="Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerResizePolicy v1ContainerResizePolicy = (V1ContainerResizePolicy)o;
        return Objects.equals(this.resourceName, v1ContainerResizePolicy.resourceName) && Objects.equals(this.restartPolicy, v1ContainerResizePolicy.restartPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName, this.restartPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerResizePolicy {\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

