/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.authorization.RoleProvider;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUser;
import org.apache.druid.server.security.AuthenticationResult;

@JsonTypeName(value="ldap")
public class LDAPRoleProvider
implements RoleProvider {
    private static final Logger LOG = new Logger(LDAPRoleProvider.class);
    private final BasicAuthorizerCacheManager cacheManager;
    private final String[] groupFilters;

    @JsonCreator
    public LDAPRoleProvider(@JacksonInject BasicAuthorizerCacheManager cacheManager, @JsonProperty(value="groupFilters") String[] groupFilters) {
        this.cacheManager = cacheManager;
        this.groupFilters = groupFilters;
    }

    @Override
    public Set<String> getRoles(String authorizerPrefix, AuthenticationResult authenticationResult) {
        BasicAuthorizerUser user;
        HashSet<String> roleNames = new HashSet<String>();
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = this.cacheManager.getGroupMappingMap(authorizerPrefix);
        if (groupMappingMap == null) {
            throw new IAE("Could not load groupMappingMap for authorizer [%s]", new Object[]{authorizerPrefix});
        }
        Map<String, BasicAuthorizerUser> userMap = this.cacheManager.getUserMap(authorizerPrefix);
        if (userMap == null) {
            throw new IAE("Could not load userMap for authorizer [%s]", new Object[]{authorizerPrefix});
        }
        SearchResult searchResult = Optional.ofNullable(authenticationResult.getContext()).map(contextMap -> contextMap.get("searchResult")).map(p -> {
            if (p instanceof SearchResult) {
                return (SearchResult)p;
            }
            return null;
        }).orElse(null);
        if (searchResult != null) {
            try {
                Set<LdapName> groupNamesFromLdap = this.getGroupsFromLdap(searchResult);
                if (groupNamesFromLdap.isEmpty()) {
                    LOG.debug("User %s is not mapped to any groups", new Object[]{authenticationResult.getIdentity()});
                } else {
                    roleNames.addAll(this.getRoles(groupMappingMap, groupNamesFromLdap));
                }
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Exception in looking up groups for user %s", new Object[]{authenticationResult.getIdentity()});
            }
        }
        if ((user = userMap.get(authenticationResult.getIdentity())) != null) {
            roleNames.addAll(user.getRoles());
        }
        return roleNames;
    }

    @Override
    public Map<String, BasicAuthorizerRole> getRoleMap(String authorizerPrefix) {
        return this.cacheManager.getRoleMap(authorizerPrefix);
    }

    @VisibleForTesting
    public Set<String> getRoles(Map<String, BasicAuthorizerGroupMapping> groupMappingMap, Set<LdapName> groupNamesFromLdap) {
        HashSet<String> roles = new HashSet<String>();
        if (groupMappingMap.size() == 0) {
            return roles;
        }
        for (LdapName groupName : groupNamesFromLdap) {
            for (Map.Entry<String, BasicAuthorizerGroupMapping> groupMappingEntry : groupMappingMap.entrySet()) {
                BasicAuthorizerGroupMapping groupMapping = groupMappingEntry.getValue();
                String mask = groupMapping.getGroupPattern();
                try {
                    LdapName ln;
                    if (mask.startsWith("*,")) {
                        ln = new LdapName(mask.substring(2));
                        if (!groupName.startsWith(ln)) continue;
                        roles.addAll(groupMapping.getRoles());
                        continue;
                    }
                    if (mask.endsWith(",*")) {
                        ln = new LdapName(mask.substring(0, mask.length() - 2));
                        if (!groupName.endsWith(ln)) continue;
                        roles.addAll(groupMapping.getRoles());
                        continue;
                    }
                    ln = new LdapName(mask);
                    if (!groupName.equals(ln)) continue;
                    roles.addAll(groupMapping.getRoles());
                }
                catch (InvalidNameException e) {
                    throw new RuntimeException(String.format(Locale.getDefault(), "Configuration problem - Invalid groupMapping '%s'", mask));
                }
            }
        }
        return roles;
    }

    Set<LdapName> getGroupsFromLdap(SearchResult userResult) throws NamingException {
        TreeSet<LdapName> groups = new TreeSet<LdapName>();
        Attribute memberOf = userResult.getAttributes().get("memberOf");
        if (memberOf == null) {
            LOG.debug("No memberOf attributes", new Object[0]);
            return groups;
        }
        for (int i = 0; i < memberOf.size(); ++i) {
            LdapName ln;
            String memberDn = memberOf.get(i).toString();
            try {
                ln = new LdapName(memberDn);
            }
            catch (InvalidNameException e) {
                LOG.debug("Invalid LDAP name: %s", new Object[]{memberDn});
                continue;
            }
            if (this.groupFilters != null) {
                if (!this.allowedLdapGroup(ln, new TreeSet<String>(Arrays.asList(this.groupFilters)))) continue;
                groups.add(ln);
                continue;
            }
            groups.add(ln);
        }
        return groups;
    }

    boolean allowedLdapGroup(LdapName groupName, Set<String> groupFilters) {
        for (String filter : groupFilters) {
            try {
                LdapName ln;
                if (filter.startsWith("*,")) {
                    ln = new LdapName(filter.substring(2));
                    if (!groupName.startsWith(ln)) continue;
                    return true;
                }
                if (filter.endsWith(",*")) {
                    ln = new LdapName(filter.substring(0, filter.length() - 2));
                    if (!groupName.endsWith(ln)) continue;
                    return true;
                }
                LOG.debug("Attempting exact filter %s", new Object[]{filter});
                ln = new LdapName(filter);
                if (!groupName.equals(ln)) continue;
                return true;
            }
            catch (InvalidNameException e) {
                throw new RE(StringUtils.format((String)"Configuration problem - Invalid groupFilter '%s'", (Object[])new Object[]{filter}), new Object[0]);
            }
        }
        return false;
    }
}

