/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.google.common.collect.Iterators;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.data.input.protobuf.ProtobufConverter;
import org.apache.druid.data.input.protobuf.ProtobufFlattenerMaker;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;

public class ProtobufReader
extends IntermediateRowParsingReader<DynamicMessage> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final ObjectFlattener<Map<String, Object>> recordFlattener;
    private final ProtobufBytesDecoder protobufBytesDecoder;

    ProtobufReader(InputRowSchema inputRowSchema, InputEntity source, ProtobufBytesDecoder protobufBytesDecoder, JSONPathSpec flattenSpec) {
        this.inputRowSchema = inputRowSchema;
        this.recordFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new ProtobufFlattenerMaker(inputRowSchema.getDimensionsSpec().useSchemaDiscovery()));
        this.source = source;
        this.protobufBytesDecoder = protobufBytesDecoder;
    }

    protected CloseableIterator<DynamicMessage> intermediateRowIterator() throws IOException {
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.singletonIterator((Object)this.protobufBytesDecoder.parse(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)this.source.open())))));
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(DynamicMessage intermediateRow) throws ParseException {
        Map<String, Object> plainJava = ProtobufReader.convertMessage(intermediateRow);
        Map record = this.recordFlattener.flatten(plainJava);
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, (Map)record));
    }

    protected List<Map<String, Object>> toMap(DynamicMessage intermediateRow) {
        return Collections.singletonList(ProtobufReader.convertMessage(intermediateRow));
    }

    private static Map<String, Object> convertMessage(Message msg) {
        try {
            return ProtobufConverter.convertMessage(msg);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ParseException(null, (Throwable)e, "Protobuf message could not be parsed", new Object[0]);
        }
    }
}

