/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import org.apache.druid.catalog.sync.CachedMetadataCatalog;
import org.apache.druid.catalog.sync.CatalogClientConfig;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.joda.time.Duration;

@ManageLifecycle
public class CatalogUpdateReceiver {
    private static final EmittingLogger LOG = new EmittingLogger(CatalogUpdateReceiver.class);
    private final CachedMetadataCatalog cachedCatalog;
    private final CatalogClientConfig config;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ScheduledExecutorService exec;

    @Inject
    public CatalogUpdateReceiver(CachedMetadataCatalog cachedCatalog, CatalogClientConfig clientConfig) {
        this.cachedCatalog = cachedCatalog;
        this.config = clientConfig;
        this.exec = Execs.scheduledSingleThreaded((String)"CatalogUpdateReceiver-Exec--%d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            Duration delay = new Duration(this.config.getPollingPeriod());
            long maxDelayFuzz = this.config.getMaxRandomDelay();
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)delay, (Duration)delay, () -> {
                try {
                    long randomDelay = ThreadLocalRandom.current().nextLong(0L, maxDelayFuzz);
                    Thread.sleep(randomDelay);
                    LOG.debug("Scheduled catalog refresh running", new Object[0]);
                    this.resync();
                    LOG.debug("Scheduled catalog refresh is done", new Object[0]);
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, "Error occured while refreshing catalog.", new Object[0]).emit();
                }
            });
            this.lifecycleLock.started();
            LOG.info("Catalog update receiver started", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
        try {
            this.resync();
        }
        catch (Throwable t) {
            LOG.warn(t, "Failed to perform initial catalog synchronization", new Object[0]);
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.info("Catalog update receiver stopped", new Object[0]);
        this.exec.shutdownNow();
        this.lifecycleLock.exitStop();
    }

    private void resync() throws Exception {
        RetryUtils.retry(() -> {
            this.cachedCatalog.resync();
            return true;
        }, e -> true, (int)this.config.getMaxSyncRetries());
    }
}

