/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo.config;

import java.util.Properties;
import org.schemarepo.InMemoryCache;
import org.schemarepo.json.GsonJsonUtil;

public class Config {
    private static final String GLOBAL_PREFIX = "schema-repo.";
    public static final String REPO_CLASS = "schema-repo.class";
    public static final String REPO_CACHE = "schema-repo.cache";
    public static final String VALIDATOR_PREFIX = "schema-repo.validator.";
    public static final String VALIDATION_PREFIX = "schema-repo.validation.";
    public static final String DEFAULT_SUBJECT_VALIDATORS = "schema-repo.validation.default.validators";
    private static final String JETTY_PREFIX = "schema-repo.jetty.";
    public static final String JETTY_HOST = "schema-repo.jetty.host";
    public static final String JETTY_PORT = "schema-repo.jetty.port";
    public static final String JETTY_HEADER_SIZE = "schema-repo.jetty.header.size";
    public static final String JETTY_BUFFER_SIZE = "schema-repo.jetty.buffer.size";
    public static final String JETTY_STOP_AT_SHUTDOWN = "schema-repo.jetty.stop-at-shutdown";
    public static final String JETTY_GRACEFUL_SHUTDOWN = "schema-repo.jetty.graceful-shutdown";
    private static final String LOGGING_PREFIX = "schema-repo.logging.";
    public static final String LOGGING_ROUTE_JUL_TO_SLF4J = "schema-repo.logging.route-jul-to-slf4j";
    private static final String LOCAL_FILE_SYSTEM_PREFIX = "schema-repo.local-file-system.";
    public static final String LOCAL_FILE_SYSTEM_PATH = "schema-repo.local-file-system.path";
    private static final String ZK_PREFIX = "schema-repo.zookeeper.";
    public static final String ZK_ENSEMBLE = "schema-repo.zookeeper.ensemble";
    public static final String ZK_PATH_PREFIX = "schema-repo.zookeeper.path-prefix";
    public static final String ZK_SESSION_TIMEOUT = "schema-repo.zookeeper.session-timeout";
    public static final String ZK_CONNECTION_TIMEOUT = "schema-repo.zookeeper.connection-timeout";
    public static final String ZK_CURATOR_SLEEP_TIME_BETWEEN_RETRIES = "schema-repo.zookeeper.curator.sleep-time-between-retries";
    public static final String ZK_CURATOR_NUMBER_OF_RETRIES = "schema-repo.zookeeper.curator.number-of-retries";
    private static final String CLIENT_PREFIX = "schema-repo.rest-client.";
    public static final String CLIENT_SERVER_URL = "schema-repo.rest-client.server-url";
    public static final String CLIENT_RETURN_NONE_ON_EXCEPTIONS = "schema-repo.rest-client.return-none-on-exceptions";
    private static final String JSON_PREFIX = "schema-repo.json.";
    public static final String JSON_UTIL_IMPLEMENTATION = "schema-repo.json.util-implementation";
    public static final Properties DEFAULTS = new Properties();

    public static String getDefault(String propertyName) {
        return DEFAULTS.getProperty(propertyName);
    }

    public static Integer getIntDefault(String propertyName) {
        return Integer.parseInt(Config.getDefault(propertyName));
    }

    static {
        DEFAULTS.setProperty(REPO_CACHE, InMemoryCache.class.getName());
        DEFAULTS.setProperty(JETTY_HOST, "");
        DEFAULTS.setProperty(JETTY_PORT, "2876");
        DEFAULTS.setProperty(JETTY_HEADER_SIZE, "16384");
        DEFAULTS.setProperty(JETTY_BUFFER_SIZE, "16384");
        DEFAULTS.setProperty(JETTY_STOP_AT_SHUTDOWN, "true");
        DEFAULTS.setProperty(JETTY_GRACEFUL_SHUTDOWN, "3000");
        DEFAULTS.setProperty(DEFAULT_SUBJECT_VALIDATORS, "");
        DEFAULTS.setProperty(LOGGING_ROUTE_JUL_TO_SLF4J, "true");
        DEFAULTS.setProperty(ZK_ENSEMBLE, "");
        DEFAULTS.setProperty(ZK_PATH_PREFIX, "/schema-repo");
        DEFAULTS.setProperty(ZK_SESSION_TIMEOUT, "5000");
        DEFAULTS.setProperty(ZK_CONNECTION_TIMEOUT, "2000");
        DEFAULTS.setProperty(ZK_CURATOR_SLEEP_TIME_BETWEEN_RETRIES, "2000");
        DEFAULTS.setProperty(ZK_CURATOR_NUMBER_OF_RETRIES, "10");
        DEFAULTS.setProperty(CLIENT_RETURN_NONE_ON_EXCEPTIONS, "true");
        DEFAULTS.setProperty(JSON_UTIL_IMPLEMENTATION, GsonJsonUtil.class.getName());
    }
}

