/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.CompatibilityChecker;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface ParsedSchema {
    public String schemaType();

    public String name();

    public String canonicalString();

    default public String formattedString(String format) {
        if (format == null || format.trim().isEmpty()) {
            return this.canonicalString();
        }
        throw new IllegalArgumentException("Format not supported: " + format);
    }

    public List<SchemaReference> references();

    default public void validate() {
    }

    public List<String> isBackwardCompatible(ParsedSchema var1);

    default public List<String> isCompatible(CompatibilityLevel level, List<? extends ParsedSchema> previousSchemas) {
        if (level != CompatibilityLevel.NONE) {
            for (ParsedSchema parsedSchema : previousSchemas) {
                if (this.schemaType().equals(parsedSchema.schemaType())) continue;
                return Collections.singletonList("Incompatible because of different schema type");
            }
        }
        return CompatibilityChecker.checker(level).isCompatible(this, previousSchemas);
    }

    public Object rawSchema();

    default public boolean deepEquals(ParsedSchema schema) {
        return Objects.equals(this.rawSchema(), schema.rawSchema());
    }
}

