/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import java.nio.ByteBuffer;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class DoublesSketchMergeBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector<DoublesSketch> selector;
    private final DoublesSketchMergeBufferAggregatorHelper helper;

    public DoublesSketchMergeBufferAggregator(ColumnValueSelector<DoublesSketch> selector, int k, int maxIntermediateSize) {
        this.selector = selector;
        this.helper = new DoublesSketchMergeBufferAggregatorHelper(k, maxIntermediateSize);
    }

    public void init(ByteBuffer buffer, int position) {
        this.helper.init(buffer, position);
    }

    public void aggregate(ByteBuffer buffer, int position) {
        DoublesSketchMergeAggregator.updateUnion(this.selector, this.helper.getSketchAtPosition(buffer, position));
    }

    public Object get(ByteBuffer buffer, int position) {
        return this.helper.getSketchAtPosition(buffer, position).getResult();
    }

    public float getFloat(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public synchronized void close() {
        this.helper.clear();
    }

    public synchronized void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

