/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;

public final class DitContentRuleHelper {
    private DitContentRuleHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(DitContentRule ditContentRule, SchemaErrorHandler errorHandler, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                ditContentRule.unlock();
                AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
                ObjectClassRegistry ocRegistry = registries.getObjectClassRegistry();
                if (ditContentRule.getMayAttributeTypeOids() != null) {
                    ditContentRule.getMayAttributeTypes().clear();
                    for (String oid : ditContentRule.getMayAttributeTypeOids()) {
                        ditContentRule.getMayAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                    }
                }
                if (ditContentRule.getMustAttributeTypeOids() != null) {
                    ditContentRule.getMustAttributeTypes().clear();
                    for (String oid : ditContentRule.getMustAttributeTypeOids()) {
                        ditContentRule.getMustAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                    }
                }
                if (ditContentRule.getNotAttributeTypeOids() != null) {
                    ditContentRule.getNotAttributeTypes().clear();
                    for (String oid : ditContentRule.getNotAttributeTypeOids()) {
                        ditContentRule.getNotAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                    }
                }
                if (ditContentRule.getAuxObjectClassOids() != null) {
                    ditContentRule.getAuxObjectClasses().clear();
                    for (String oid : ditContentRule.getAuxObjectClassOids()) {
                        ditContentRule.getAuxObjectClasses().add((ObjectClass)ocRegistry.lookup(oid));
                    }
                }
            }
            finally {
                ditContentRule.lock();
            }
        }
    }
}

