/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.extended;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedRequestValue
extends GrammarAction<LdapMessageContainer<ExtendedRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestValue.class);

    public StoreExtendedRequestValue() {
        super("Store ExtendedRequest value");
    }

    public void action(LdapMessageContainer<ExtendedRequest> container) throws DecoderException {
        ExtendedRequest extendedRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        ExtendedOperationFactory factory = container.getLdapCodecService().getExtendedRequestFactories().get(extendedRequest.getRequestName());
        try {
            if (tlv.getLength() == 0) {
                ((OpaqueExtendedRequest)extendedRequest).setRequestValue(Strings.EMPTY_BYTES);
            } else {
                ((OpaqueExtendedRequest)extendedRequest).setRequestValue(tlv.getValue().getData());
            }
            if (factory != null) {
                factory.decodeValue(extendedRequest, tlv.getValue().getData());
            }
        }
        catch (DecoderException de) {
            String msg = I18n.err((I18n)I18n.ERR_05158_INVALID_REQUEST_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])tlv.getValue().getData())});
            LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, de.getMessage()}));
            throw de;
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05127_EXTENDED_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])tlv.getValue().getData())}));
        }
    }
}

