/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.directory.api.ldap.codec.osgi;


import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.junit.jupiter.api.BeforeEach;


/**
 * Initialize the Codec service. This can later be removed.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public abstract class AbstractCodecServiceTest
{
    protected DefaultLdapCodecService codec;
    
    private static Lock lock = new ReentrantLock();

    /**
     * Initialize the codec service
     */
    @BeforeEach
    public void setupLdapCodecService()
    {
        lock.lock();
        
        try
        {
            codec = new DefaultLdapCodecService();
            
            codec.registerProtocolCodecFactory( new ProtocolCodecFactory()
            {
                @Override
                public ProtocolEncoder getEncoder( IoSession session ) throws Exception
                {
                    return null;
                }
    
    
                @Override
                public ProtocolDecoder getDecoder( IoSession session ) throws Exception
                {
                    return null;
                }
            } );
    
            if ( LdapApiServiceFactory.isInitialized() == false )
            {
                LdapApiServiceFactory.initialize( codec );
            }
        }
        finally
        {
            lock.unlock();
        }
    }
}
