/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export type ConfigureIfPredicate = (
  configVar: string,
  keyword: string
) => boolean

const ConfigureIfIncludes: ConfigureIfPredicate = (cfg, k) => {
  return cfg.includes(k)
}

export const WorkspaceKeyword = '${workspaceFolder}'
export const ServerPortKeyword = '${omegaEditPort}'

export type ConfigKeyReplace = {
  keyword: string
  replacement: string
}
export function configureIf(
  configVar: string,
  keyReplace: ConfigKeyReplace[],
  predicate: ConfigureIfPredicate = ConfigureIfIncludes
): string {
  let ret = configVar
  for (let i = 0; i < keyReplace.length; i++) {
    let { keyword, replacement } = keyReplace[i]
    if (predicate(ret, keyword)) ret = ret.replace(keyword, replacement)
  }
  return ret
}

export default { configureIf }
