/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.config.AbstractPersistedAddressSetting;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class PersistedAddressSettingJSON
extends AbstractPersistedAddressSetting
implements EncodingSupport {
    SimpleString jsonSetting;

    public PersistedAddressSettingJSON() {
    }

    @Override
    public AddressSettings getSetting() {
        if (this.setting == null) {
            this.setting = AddressSettings.fromJSON(this.jsonSetting.toString());
        }
        return super.getSetting();
    }

    public PersistedAddressSettingJSON(SimpleString addressMatch, AddressSettings setting, SimpleString jsonSetting) {
        super(addressMatch, setting);
        this.jsonSetting = jsonSetting;
    }

    public PersistedAddressSettingJSON(SimpleString addressMatch, AddressSettings setting, String jsonSetting) {
        this(addressMatch, setting, SimpleString.of((String)jsonSetting));
    }

    public void decode(ActiveMQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.jsonSetting = buffer.readSimpleString();
        this.setting = AddressSettings.fromJSON(this.jsonSetting.toString());
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.addressMatch);
        buffer.writeSimpleString(this.jsonSetting);
    }

    public int getEncodeSize() {
        return this.addressMatch.sizeof() + this.jsonSetting.sizeof();
    }

    public String toString() {
        return "PersistedAddressSettingJSON{jsonSetting=" + this.jsonSetting + ", storeId=" + this.storeId + ", addressMatch=" + this.addressMatch + ", setting=" + this.setting + "}";
    }
}

