/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.release.plugin.mojos.CommonsDistributionDetachmentMojo;
import org.apache.maven.api.plugin.testing.InjectMojo;
import org.apache.maven.api.plugin.testing.MojoTest;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@MojoTest
public class CommonsDistributionDetachmentMojoTest {
    private static final String COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH = "target/testing-commons-release-plugin";

    @BeforeEach
    public void setUp() throws Exception {
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        if (testingDirectory.exists()) {
            FileUtils.deleteDirectory((File)testingDirectory);
        }
    }

    @Test
    @InjectMojo(goal="detach-distributions", pom="src/test/resources/mojos/detach-distributions/detach-distributions-disabled.xml")
    public void testDisabled(CommonsDistributionDetachmentMojo mojo) throws Exception {
        mojo.execute();
        File testingDirectory = new File(COMMONS_RELEASE_PLUGIN_TEST_DIR_PATH);
        Assert.assertFalse((boolean)testingDirectory.exists());
    }

    @Test
    @InjectMojo(goal="detach-distributions", pom="src/test/resources/mojos/detach-distributions/detach-distributions.xml")
    public void testSuccess(CommonsDistributionDetachmentMojo mojo) throws Exception {
        mojo.execute();
        File detachedSrcTarGz = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz");
        File detachedSrcTarGzAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz.asc");
        File detachedSrcTarGzSha512 = new File("target/testing-commons-release-plugin/commons-text-1.4-src.tar.gz.sha512");
        File detachedSrcZip = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip");
        File detachedSrcZipAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip.asc");
        File detachedSrcZipSha512 = new File("target/testing-commons-release-plugin/commons-text-1.4-src.zip.sha512");
        File detachedBinTarGz = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz");
        File detachedBinTarGzAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz.asc");
        File detachedBinTarGzSha512 = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.tar.gz.sha512");
        File detachedBinZip = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip");
        File detachedBinZipAsc = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip.asc");
        File detachedBinZipSha512 = new File("target/testing-commons-release-plugin/commons-text-1.4-bin.zip.sha512");
        File notDetachedMockAttachedFile = new File("target/testing-commons-release-plugin/commons-text-1.4.jar");
        File sha512Properties = new File("target/testing-commons-release-plugin/sha512.properties");
        TestCase.assertTrue((boolean)detachedSrcTarGz.exists());
        TestCase.assertTrue((boolean)detachedSrcTarGzAsc.exists());
        TestCase.assertTrue((boolean)detachedSrcTarGzSha512.exists());
        TestCase.assertTrue((boolean)detachedSrcZip.exists());
        TestCase.assertTrue((boolean)detachedSrcZipAsc.exists());
        TestCase.assertTrue((boolean)detachedSrcZipSha512.exists());
        TestCase.assertTrue((boolean)detachedBinTarGz.exists());
        TestCase.assertTrue((boolean)detachedBinTarGzAsc.exists());
        TestCase.assertTrue((boolean)detachedBinTarGzSha512.exists());
        TestCase.assertTrue((boolean)detachedBinZip.exists());
        TestCase.assertTrue((boolean)detachedBinZipAsc.exists());
        TestCase.assertTrue((boolean)detachedBinZipSha512.exists());
        TestCase.assertTrue((boolean)sha512Properties.exists());
        Assert.assertFalse((boolean)notDetachedMockAttachedFile.exists());
    }
}

